const express = require('express');
const router = express.Router();
const jobTypeService = require('../../services/job_type_services/jobTypeService');

router.get('/getJobs', async (req, res) => {
    try {
        const jobs = await jobTypeService.getJobs();
        res.json(jobs);
    } catch (err) {
        console.error('Error fetching jobs:', err);
        res.status(500).send('Error fetching jobs');
    }
});

router.post('/addjth', async (req, res) => {
    try {
        const body = req.body;
        if (!body.JTH_ID || !body.JTH_job_type || !body.JTH_job_short_name || !body.JTH_time_limit || body.JTH_status === undefined || body.JTH_status === null) {
            return res.status(400).send('All fields are required');
        }

        await jobTypeService.addJob(body);
        res.status(200).json({ message: 'Job added successfully' });
    } catch (err) {
        console.error('Error adding job:', err);
        res.status(500).send('Error adding job');
    }
});

router.put('/updatejth', async (req, res) => {
    try {
        const body = req.body;
        if (!body.JTH_ID || !body.JTH_job_type || !body.JTH_job_short_name || !body.JTH_time_limit || body.JTH_status === undefined) {
            return res.status(400).send('All fields are required');
        }

        await jobTypeService.updateJob(body);
        res.status(200).json({ message: 'Job updated successfully' });
    } catch (err) {
        console.error('Error updating job:', err);
        res.status(500).send('Error updating job');
    }
});

router.delete('/deletejth', async (req, res) => {
    try {
        const body = req.body;

        await jobTypeService.deleteJob(body.JTH_ID);
        res.status(200).json({ message: 'Job deleted successfully' });
    } catch (err) {
        console.error('Error deleting job:', err);
        res.status(500).send('Error deleting job');
    }
});

module.exports = router;
