<?php
session_start();
require_once './includes/header.php';

$requisition_no = isset($_GET['requisition_no']) ? $_GET['requisition_no'] : '';
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <link rel="stylesheet" href="assets/css/style_for_requisition_items.css">
</head>

<body class="with-welcome-text">
    <div class="container-scroller">
        <!-- partial:partials/_navbar.html -->
        <?php include './includes/profilebasenavbar.php'; ?>
        <!-- partial -->
        <div class="container-fluid page-body-wrapper">
            <!-- partial:partials/_sidebar.html -->
            <?php include './includes/sidebarmenu.php'; ?>
            <!-- partial -->
            <div class="main-panel">
                <div class="content-wrapper">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="home-tab">
                                <div class="tab-content tab-content-basic" style="padding: 0;">
                                    <div class="tab-pane fade show active" id="overview" role="tabpanel"
                                        aria-labelledby="overview">
                                        <div class="container form-container" id="requisition-details-container">
                                            <!-- Requisition details will be populated here by JavaScript -->
                                        </div>

                                        <!-- Display the Added Items Table directly -->
                                        <div class="container form-container" style="margin-top: 20px;">
                                            <div class="">
                                                <div class="col-md-4 mx-auto text-center">
                                                    <label for="vendorSelect">Select Vendor for Allocation</label>
                                                    <div class="d-flex align-items-center">
                                                        <select id="vendorSelect" name="vendor_id"
                                                            onchange="generatePo(this.value, '<?php echo $_GET['requisition_no'] ?>');"
                                                            class="form-control">
                                                            <option value="" selected disabled>Select Vendor</option>
                                                        </select>
                                                        <input type="hidden" id="poidHidden">

                                                        <button class="btn btn-outline-success btn-sm ms-2"
                                                            style="width: 45%;" onclick="showVendorModal();">
                                                            New Vendor
                                                        </button>

                                                    </div>
                                                </div>

                                                <div id="vedDetails" class="col-md-4 mx-auto text-center"
                                                    style="display: ">


                                                </div>

                                                <div class="mt-3">
                                                    <table
                                                        class="table table-bordered table-sm text-center align-middle"
                                                        id="itemTable">
                                                        <thead class="table-light">
                                                            <tr>
                                                                <th class="hidden-column">Item Id</th>
                                                                <th>Item Name</th>
                                                                <th>Drawing No</th>
                                                                <th>Part No</th>
                                                                <th style="width: 100px;">Working Qty</th>
                                                                <th style="width: 100px;">prev vendors</th>
                                                                <th style="width: 100px;">Accepted Qty</th>
                                                                <th style="width: 100px;">Pending Qty</th>
                                                                <th style="width: 100px;">Allocate Qty</th>
                                                                <th style="width: 120px;">AMT per Unit</th>
                                                                <th>Select</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="itemListContainer">
                                                            <!-- Items will be inserted here dynamically by JavaScript -->
                                                        </tbody>
                                                    </table>

                                                    <div
                                                        style="display: flex; justify-content: center; margin-top: 10px;">
                                                        <button class="btn btn-outline-secondary btn-sm"
                                                            onclick="window.location.href='accepted_request.php';">Back</button>
                                                        <button class="btn btn-outline-primary btn-sm"
                                                            id="allocateVendorBtn" onclick="generatePoforVendor();"
                                                            style="display: none;">
                                                            <i class="menu-icon fa fa-tags"></i> Allocate Vendor
                                                        </button>
                                                        <button class="btn btn-outline-warning btn-sm" id="showItem"
                                                            onclick="showAllVendorItems();" style="display: none;">
                                                            <i class="menu-icon fa fa-list"></i> Show Item List
                                                        </button>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php include './includes/footer.php'; ?>
            </div>
        </div>
    </div>
    <?php include './includes/dependancy.php'; ?>
</body>

<!-- New Vendor Modal -->
<div class="modal-overlay" id="newVendorModal" style="display: none;">
    <div class="modal-box">
        <div class="modal-header">
            <h5 class="modal-title" id="newVendorModalLabel">Add New Vendor</h5>
            <button onclick="closeAddVendorModal();" style="width: 10%;">&times;</button>
        </div>
        <div class="modal-body">
            <form id="newVendorForm">
                <div class="mb-3">
                    <label for="vendorName" class="form-label">Vendor Name</label>
                    <input type="text" class="form-control" id="vendorName" name="vendor_name" required>
                </div>
                <div class="mb-3">
                    <label for="vendorAddress" class="form-label">Vendor Address</label>
                    <input type="text" class="form-control" id="vendorAddress" name="vendor_address" required>
                </div>

                <div class="flex-grow-1">
                    <label for="vendorCurrency" class="form-label">Vendor Currency</label>
                    <select id="vendorCurrency" name="vendor_currency" class="form-control">
                        <option value="" selected disabled>Select Currency</option>
                        <option value="USD">$ USD</option>
                        <option value="EUR">€ EUR</option>
                        <option value="INR">₹ INR</option>
                        <option value="GBP">£ GBP</option>
                        <option value="AUD">A$ AUD</option>
                        <option value="CAD">CA$ CAD</option>
                        <option value="JPY">¥ JPY</option>
                        <option value="CNY">¥ CNY</option>
                        <option value="MXN">$ MXN</option>
                        <option value="BRL">R$ BRL</option>
                    </select>
                </div>
                <div class="text-center">
                    <button type="submit" class="btn btn-outline-primary btn-sm">Add Vendor</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Structure  for PO-->
<div class="modal-overlay" id="expectedpoModal" style="display: none;">
    <!-- <div class="" id=""> -->
    <div class="modal-box">
        <div class="modal-header">
            Expected Delivery Details
            <button onclick="closeSuccessfulMsg();" style="width: 10%;">&times;</button>
        </div>
        <div class="modal-body">
            <div>
                <label for="deliveryDate">Expected Delivery Date:</label>
                <input type="date" id="deliveryDate" name="deliveryDate" min="" required>
                <input type="hidden" id="poIdModal" name="po_id" required>
                <input type="hidden" id="reqIdModal" name="req_id" required>
            </div>
            <div>
                <label for="shippingType">Shipping Type:</label>
                <select id="shippingType" name="shippingType" required>
                    <option value="">Select Shipping Type</option>
                    <option value="1">By Air</option>
                    <option value="2">By Sea</option>
                    <option value="3">By Road</option>
                    <option value="4">Self Pickup</option>
                    <option value="5">Express Delivery</option>
                    <option value="6">Standard Delivery</option>
                </select>
            </div>
            <div>
                <label for="poFile">Upload PO File:</label>
                <input type="file" id="poFile" name="poFile" accept=".pdf,.docx,.xlsx,.jpg,.png" />
                <p id="fileError" style="color: red; display: none;">Please upload a valid file.</p>
            </div>
            <div>
                <label for="remarkNote">Remark:</label>
                <textarea id="remarkNote" name="remarkNote" rows="4" placeholder="Enter any remark here..."
                    required></textarea>
            </div>

            <div class="text-center">
                <button class="btn btn-outline-info btn-sm" onclick="activatePOForOperations();">OK</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal for PO Created -->
<div class="modal-overlay" id="poModal" style="display: none;">
    <div class="modal-box">
        <div class="modal-body text-center">
            <h5 class="modal-title">Purchase order created successfully for this requisition..!</h5>
            <div class="modal-body text-center">
                <button class="btn btn-outline-success btn-sm" onclick = "closePoSuccessModal();" id="okBtn">OK</button>
            </div>
        </div>
    </div>
</div>

<div id="vendorModal" style="display: none; position: fixed; top: 10%; left: 50%; transform: translateX(-50%); width: 50%; background: #fff; border: 1px solid #ccc; padding: 20px; box-shadow: 0 0 10px rgba(0,0,0,0.3); z-index: 9999; border-radius: 10px;">
    <h3 style="text-align: center;padding: 10px;color: #2f618a;">Previous Vendors</h3>
    <!-- Make this section scrollable -->
    <div id="vendorModalContent" style="display: flex; flex-wrap: wrap; gap: 20px; max-height: 300px; overflow-y: auto; padding-right: 10px;"></div>
    <button class="btn btn-outline-success" onclick="closeVendorModal()" style="margin-top: 10px;">Close</button>
</div>


<!-- Enhanced Expected PO Modal with PDF structure -->
<!-- <div class="modal-overlay" id="expectedpoModal" style="display: none;"> -->
<div class="" id="">
    <div class="modal-box" style="max-width: 900px;">
        <div class="modal-header" style="position: relative; justify-content: center; padding-right: 40px;">
        <h4 style="margin: 0 auto;">PURCHASE ORDER</h4>

        <!-- Close button positioned absolutely on the right -->
        <button onclick="closeSuccessfulMsg();" style="position: absolute; right: 10px; top: 50%; transform: translateY(-50%); border: none; background: none; font-size: 20px;">
            &times;
        </button>
    </div>

        <div class="modal-body" id="poPdfContent" style="background:white;">
            <!-- Header with logo and company name -->
            <div style="display: flex; align-items: center; gap: 15px; margin-bottom: 10px;">
                <img src="assets/images/logo/ksm_logo.jpg" alt="Company Logo" style="height: 50px;">
                <h2 style="margin: 0; font-size: 20px; font-weight: bold;">
                    KAIZEN SHIP MANAGEMENT CO., LTD
                </h2>
            </div>

            <!-- Company Info and PO Meta -->
            <div style="display: flex; justify-content: space-between; font-size: 14px;">
                <div style="width: 48%;">
                    <strong>Company Address:</strong><br>
                    123 Ocean Tower, Seaview Road,<br>
                    Singapore 098765<br><br>

                    <strong>Phone:</strong> +65 1234 5678<br>
                    <strong>Fax:</strong> +65 8765 4321<br>
                    <strong>Email:</strong> info@kaizenship.com<br>
                </div>

                <div style="width: 48%;">
                    <div class="mb-1 d-flex align-items-center">
                        <label class="me-2">PO No:</label>
                        <span id="poNoDisplay">PO-XXXX</span>
                    </div>
                    <div class="mb-1 d-flex align-items-center">
                        <label class="me-2">Date:</label>
                        <span id="poDateDisplay">YYYY-MM-DD</span>
                    </div>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label class="me-2">Ref PR:</label>
                        <input type="text" class="form-control form-control-sm" id="refPrInput" style="width: 60%;">
                    </div>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label class="me-2">Credit Terms:</label>               
                        <input type="number" class="form-control form-control-sm" id="creditTerms" style="width: 60%;">
                    </div>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label class="me-2">Purchase Category:</label>
                        <input type="text" class="form-control form-control-sm" id="purchaseCategory" style="width: 60%;">
                    </div>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label class="me-2">F.O.B.:</label>
                        <input type="text" class="form-control form-control-sm" id="fobInput" style="width: 60%;">
                    </div>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label class="me-2">Ref No:</label>
                        <input type="text" class="form-control form-control-sm" id="refNoInput" style="width: 60%;">
                    </div>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label class="me-2">Currency:</label>
                        <input type="text" class="form-control form-control-sm" id="currencyInput" style="width: 60%;">
                    </div>
                </div>
            </div>

            <hr>

            <!-- Vendor & Ship To Info -->
            <div style="display: flex; justify-content: space-between; font-size: 14px;">
                <div style="width: 48%;">
                    <h6>Vendor Details:</h6>
                    <div class="mb-1 d-flex align-items-center">
                        <label class="me-2">Name:</label>
                        <span id="vendorNameDisplay">Vendor XYZ</span>
                    </div>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label class="me-2">Address:</label>
                        <input type="text" class="form-control form-control-sm" id="vendorAddressInput" style="width: 70%;">
                    </div>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label class="me-2">Email:</label>
                        <input type="email" class="form-control form-control-sm" id="vendorEmailInput" style="width: 70%;">
                    </div>
                </div>

                <div style="width: 48%;">
                    <h6>Send To:</h6>
                    <div class="mb-1 d-flex align-items-center">
                        <label class="me-2">Name:</label>
                        <span id="vendorNameDisplay">Vendor XYZ</span>
                    </div>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label class="me-2">Ship Name:</label>
                        <input type="text" class="form-control form-control-sm mb-2" id="shipNameInput" style="width: 70%;">
                    </div>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                    <label for="shippingType"><strong>Shipping Type:</strong></label>
                    <select id="shippingType" class="form-control form-control-sm" required style="width: 70%;">
                        <option value="">Select</option>
                        <option value="1">By Air</option>
                        <option value="2">By Sea</option>
                        <option value="3">By Road</option>
                        <option value="4">Self Pickup</option>
                        <option value="5">Express Delivery</option>
                        <option value="6">Standard Delivery</option>
                    </select>
</div>
                </div>

            </div>
            </div>

            <hr>

            <!-- Other Details -->
            <div class="mb-3">
                <label for="remarkNote"><strong>Remarks:</strong></label>
                <textarea id="remarkNote" name="remarkNote" rows="4" class="form-control form-control-sm" placeholder="Enter any remark here..." required></textarea>
            </div>

            <div class="text-center mt-3">
                <button class="btn btn-outline-info btn-sm" onclick="activatePOForOperations();">OK</button>
                <button class="btn btn-outline-danger btn-sm" onclick="generatePOPdf();">Download as PDF</button>
            </div>
        </div>
    </div>
</div>




<script src="assets/js/acceptedRequisition.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>

<script>
    async function generatePOPdf() {
        const { jsPDF } = window.jspdf;
        const doc = new jsPDF();

        // Example — Set font for the header
        doc.setFontSize(12);
        const logoUrl = "assets/images/logo/ksm_logo.jpg";
        const logoX = 20;
        const logoY = 10;
        const logoWidth = 20;  // Smaller logo
        const logoHeight = 15;

        doc.addImage(logoUrl, 'JPEG', logoX, logoY, logoWidth, logoHeight);

        // Company name next to the logo
        const companyNameX = logoX + logoWidth; // Add spacing after logo
        const companyNameY = logoY + 10; // Vertically center with the logo
        doc.setFont("helvetica", "bold");
        doc.text("KAIZEN SHIP MANAGEMENT CO., LTD", companyNameX, companyNameY);

        
        doc.text("PURCHASE ORDER", 150, 20);
        doc.line(20, 30, 190, 30);

        // Add other text
        doc.text("Vendor Name: " + document.getElementById("vendorNameDisplay").textContent, 20, 60);
        doc.text("Vendor Email: " + document.getElementById("vendorEmailInput").value, 20, 70);
        doc.text("Ship Name: " + document.getElementById("shipNameInput").value, 20, 80);
        doc.text("PO No: " + document.getElementById("poNoDisplay").textContent, 20, 90);
        doc.text("Date: " + document.getElementById("poDateDisplay").textContent, 20, 100);
        doc.text("Currency: " + document.getElementById("currencyInput").value, 20, 110);

        doc.text("Remarks:", 20, 130);
        doc.text(document.getElementById("remarkNote").value, 20, 140, { maxWidth: 170 });

        // Save the PDF
        doc.save("purchase_order.pdf");
    }
</script>



</html>