// Date : 01-04-2025
// Handle the response from the fetch_accepted_requisitions API with allocate vendor and PO generation.
// Handle add new vendor and upload qoatation file from the fetch_vendors API.

// Function to fetch requisitions data
let totalPages = 0;

// Function to fetch requisitions data
function fetchRequisitions(page = 1) {
    var formdata = {
        page: page
    };
    $.ajax({
        url: "./ajax/json_for_fetch_operational_requisitions_v1_0.php",
        type: "POST",
        data: formdata,
        dataType: "json",
        success: function (response) {
            if (response && response.requests) {
                updateRequisitionCards(response.requests);
                totalPages = response.totalPages;
                updatePagination(totalPages, page);  
            } else {
                console.error("Invalid response format:", response);
            }
        },
        error: function () {
            console.error("Failed to fetch requisitions. Please try again later.");
        }
    });
}


function updateRequisitionCards(requests) {
    const container = document.getElementById('request-cards-container');
    container.innerHTML = ''; 

    requests.forEach(request => {
        const card = document.createElement('div');
        card.classList.add('col-md-4');
        card.style.padding = '10px';
        card.innerHTML = `
            <div class="request-card bg-white" style="position: relative; border: 1px solid #ccc; border-radius: 10px; overflow: hidden;">
                ${request.closed ? `
                    <!-- Green Checkmark Badge -->
                    <span style="
                        position: absolute;
                        top: 40px;
                        right: 15px;
                        background-color: rgba(76, 175, 80, 0.1); /* light green */
                        color: green;
                        padding: 6px 10px;
                        border-radius: 50%;
                        font-size: 16px;
                        font-weight: bold;
                        box-shadow: 0 1px 4px rgba(0,0,0,0.1);
                    ">
                        <i class="fa fa-cart-arrow-down"></i> 
                    </span>
                ` : ''}
                ${request.delivery_comment ? `
                <!-- Dispute Sign with Tooltip -->
                <div class="dispute-tooltip" style="position: absolute; top: 40px; left: 237px;">
                    <span class="dispute-icon">
                        <i class="fa fa-exclamation"></i>
                    </span>
                    <div class="dispute-bubble">
                        ${request.delivery_comment}
                        <div class="dispute-bubble-arrow"></div>
                    </div>
                </div>
                ` : ''}

                <h5 class="card-title" style="margin-bottom: -7px; display: flex; justify-content: space-between;">
                    <p><strong>Req no.: ${request.requisition_no}</strong></p>
                    <p style="font-size: 10px;"><strong>Date: ${formatDate(request.requested_date)}</strong></p>
                </h5>
                <p style="margin-bottom: 3px;">Ship Name: ${request.ship_name}</p>
                <p style="margin-bottom: 3px;">Department: ${request.department}</p>

                <div style="display: flex; justify-content: center; margin-top: 10px; gap: 3px;">
                    <button type="button" class="btn btn-outline-info btn-sm flex-fill" style="font-size: 70%;" title="Show Details" onclick="openDetailsModal(${request.req_id});">
                        <i class="menu-icon fa fa-info-circle" style="font-size:13px;"></i> Details
                    </button>

                    ${request.closed ? '' : `
                    <button type="button" class="btn btn-outline-primary btn-sm" style="font-size: 70%;" title="Update Progress" onclick="openProgressModal(${request.req_id});">
                        <i class="menu-icon fa fa-arrow-circle-right" style="font-size:13px;"></i> Update
                    </button>`}

                    <button type="button" class="btn btn-outline-warning btn-sm flex-fill" style="font-size: 70%;" title="Track Requisition" onclick="opentrackerModal(${request.req_id});">
                        <i class="menu-icon fa fa-bullseye" style="font-size:13px;"></i> Track
                    </button>
                </div>
            </div>
        `;


        container.appendChild(card);
    });
}

// Function to update pagination links
function updatePagination(totalPages, currentPage) {
    const pagination = document.getElementById('pagination-links');
    pagination.innerHTML = '';  

    pagination.innerHTML += `<li class="page-item ${currentPage == 1 ? 'disabled' : ''}">
                                <a class="page-link" href="#" onclick="changePage(${currentPage - 1})"><<</a>
                              </li>`;

    for (let page = 1; page <= totalPages; page++) {
        pagination.innerHTML += `<li class="page-item ${page == currentPage ? 'active' : ''}">
                                    <a class="page-link" href="#" onclick="changePage(${page})">${page}</a>
                                  </li>`;
    }

    pagination.innerHTML += `<li class="page-item ${currentPage == totalPages ? 'disabled' : ''}">
                                <a class="page-link" href="#" onclick="changePage(${currentPage + 1})">>></a>
                              </li>`;
}


// Change page function
window.changePage = function (page) {
    if (page < 1 || page > totalPages) return;  
    fetchRequisitions(page);
};

// Function to format date 
function formatDate(dateString) {
    const date = new Date(dateString);
    const day = String(date.getDate()).padStart(2, '0');
    const month = String(date.getMonth() + 1).padStart(2, '0');
    const year = date.getFullYear();

    return `${day}/${month}/${year}`; 
};

fetchRequisitions(1);


// function for show details 
let currentRequisitionDetails = null;
let currentRequisitionItems = [];

function openDetailsModal(requisitionId) {
    $.ajax({
        url: './ajax/json_for_requisition_details_v1_0.php',
        type: 'POST',
        data: { req_id: requisitionId },
        dataType: 'json',
        success: function(response) {
            console.log('Response:', response);

            if (
                response &&
                response.error_code === 200 &&
                response.data &&
                response.data.header &&
                Array.isArray(response.data.items)
            ) {
                const details = response.data.header;
                const items = response.data.items;

                currentRequisitionDetails = details;
                currentRequisitionItems = items;

                $('#requisition-details-container').html(`
                    <div style="padding: 15px; border: 1px solid #ccc; border-radius: 6px; background-color: #f9f9f9; margin-bottom: 20px;">
                        <div style="display: flex; justify-content: space-between; border-bottom: 2px solid skyblue; padding-bottom: 5px; margin-bottom: 15px; background-color: #f1f8ff;">
                            <h5 style="margin: 0; color: #0056b3;">🚢 Requisition Number: <strong>${details.req_no}</strong></h5>
                            <h6 style="margin: 0; text-decoration: underline; color: #0056b3;">Date: ${details.creation_date}</h6>
                        </div>

                        <div class="row" style="display: flex; flex-wrap: wrap; gap: 10px;">
                            ${renderInfoRow("Vessel Name", details.ship_name, "Department Name", details.dept_name)}
                            ${renderInfoRow("Equipment Name / Engine Type", details.req_eq_name_engine_type, "Model Name / Type", details.req_model_type)}
                            ${renderInfoRow("Maker Name", details.req_maker_name, "Maker Address", details.req_maker_address)}
                            ${renderInfoRow("Priority Level", details.priority_level, "Category", details.req_eq_name_engine_type)}
                        </div>
                    </div>
                `);

                const tbody = document.getElementById("detailsTableBody");
                tbody.innerHTML = "";

                if (items.length > 0) {
                    items.forEach(item => {
                        const row = document.createElement("tr");
                        row.innerHTML = `
                            <td class="hidden-column">${item.item_id}</td>
                            <td>${item.item_name}</td>
                            <td>${item.item_drawing_no}</td>
                            <td>${item.item_part_no}</td>
                            <td>${item.working_qty}</td>
                            <td>${item.rob}</td>
                            <td>${item.req_qty}</td>
                            <td>${item.accepted_qty}</td>
                            <td>${item.remark}</td>
                        `;
                        tbody.appendChild(row);
                    });
                } else {
                    const row = document.createElement("tr");
                    row.innerHTML = `<td colspan="8" class="text-center">No items available</td>`;
                    tbody.appendChild(row);
                }

                document.getElementById("detailsModal").style.display = "block";
            } else {
                alert("No details found or invalid response.");
                console.error("Response Error:", response);
            }
        },
        error: function(xhr) {
            console.error("Error:", xhr.responseText);
            alert("Error fetching requisition details.");
        }
    });
}

// Helper to render two data in one row with four columns
function renderInfoRow(label1, value1, label2, value2) {
    return `
        <div class="info-row" style="display: flex; justify-content: space-between; width: 100%; margin-bottom: 10px;">
            <div style="width: 45%; display: flex; justify-content: space-between;">
                <strong>${label1}:</strong>
                <span>${value1 || '-'}</span>
            </div>
            <div style="width: 45%; display: flex; justify-content: space-between;">
                <strong>${label2}:</strong>
                <span>${value2 || '-'}</span>
            </div>
        </div>
    `;
}


// function for download excel
function downloadRequisitionExcel() {
    if (!currentRequisitionDetails || currentRequisitionItems.length === 0) {
        alert("No data available to export.");
        return;
    }

    const wb = XLSX.utils.book_new();
    const sheetData = [];

    const headerStartRow = sheetData.length;
    sheetData.push(["Vessel:", currentRequisitionDetails.ship_name || "", "", "", "Equipment Name / Engine Type:", currentRequisitionDetails.req_eq_name_engine_type || ""]);
    sheetData.push(["Date:", currentRequisitionDetails.creation_date || "", "", "", "Maker's Name:", currentRequisitionDetails.req_maker_name || ""]);
    sheetData.push(["Requisition No.:", currentRequisitionDetails.req_no || "", "", "", "Model Type:", currentRequisitionDetails.req_model_type || ""]);

    sheetData.push(["Department:", currentRequisitionDetails.dept_name, "", "", "Serial No.:", currentRequisitionDetails.req_serial_no]);
    
    sheetData.push(["Priority:", currentRequisitionDetails.priority_level || "", "", "", "Category:", currentRequisitionDetails.req_eq_name_engine_type  || ""]);
    sheetData.push([]);  

    sheetData.push(["IMPORTANT NOTE:"]);
    sheetData.push(["1. TO CREATE NEW REQUISITION, CLICK 'NEW' BUTTON FROM MENU."]);
    sheetData.push(["2. SELECT FROM SPARE PARTS MASTER LIST BY DOUBLE CLICKING ON THE LINE ITEM."]);
    sheetData.push(["3. YOU MAY ENTER ADDITIONAL PARTS BY CLICKING 'ADD ITEM' BUTTON."]);
    sheetData.push(["4. TO DELETE A ROW, CLICK 'DELETE ITEM' BUTTON."]);
    sheetData.push(["5. ONCE COMPLETED, CLICK 'SAVE' TO SUBMIT THE REQUISITION."]);
    sheetData.push([]);  
    sheetData.push(["", "", "", "", "", "", ""]); // Add space for formatting

    const tableHeaderRow = sheetData.length;
    sheetData.push([
        "Pos.",
        "Name of Part(s)",
        "Drawing No.",
        "Part No.",
        "Working Qty",
        "ROB",
        "Required Qty",
        "Accepted Qty",
        "Remarks"
    ]);

    let position = 1;
    const grouped = groupItemsBySystem(currentRequisitionItems);
    for (const [section, items] of Object.entries(grouped)) {
        sheetData.push([section]);
        items.forEach(item => {
            sheetData.push([
                position++,
                item.item_name,
                item.item_drawing_no,
                item.item_part_no,
                item.working_qty,
                item.rob,
                item.req_qty,
                item.accepted_qty,
                item.remark
            ]);
        });
    }

    sheetData.push([]);  
    sheetData.push(["Remarks:", currentRequisitionDetails.remarks || ""]);
    sheetData.push([]);  // Empty row for spacing
    sheetData.push(["Prepared by:", "", "", "", "", "", "Chief Engineer:"]);
    sheetData.push(["", "", "", "", "", "", "Master:"]);

    const ws = XLSX.utils.aoa_to_sheet(sheetData);

    applyHeaderStyle(ws, tableHeaderRow);

    XLSX.utils.book_append_sheet(wb, ws, "Requisition");
    const fileName = `Requisition_${currentRequisitionDetails.req_no || 'Details'}.xlsx`;
    XLSX.writeFile(wb, fileName);
}

// function for header style in excel 
function applyHeaderStyle(ws, headerRow) {
    const range = XLSX.utils.decode_range(ws['!ref']);
    for (let C = range.s.c; C <= range.e.c; ++C) {
        const cellAddress = XLSX.utils.encode_cell({ r: headerRow, c: C });
        const cell = ws[cellAddress];
        if (cell) {
            cell.s = {
                fill: {
                    patternType: "solid",
                    fgColor: { rgb: "FFFF00" }  // Light yellow background
                },
                font: {
                    bold: true,
                    color: { rgb: "000000" }  // Black text
                },
                alignment: {
                    horizontal: "center"
                }
            };
        }
    }

    if (!ws['!cols']) ws['!cols'] = [];
}

// function for items grouping
function groupItemsBySystem(items) {
    const grouped = {};
    items.forEach(item => {
        const section = item.system || "General";
        if (!grouped[section]) grouped[section] = [];
        grouped[section].push(item);
    });
    return grouped;
}

// script to close details modal
function closeDetailsModal() {
    document.getElementById("detailsModal").style.display = "none";
}

// Function to open progress modal
const progressOrder = [
    'order_placed',
    'prepare_for_dispatch',
    'ready_to_ship',
    'intransit',
    'delivered',
    'closed'
];

function openProgressModal(requisitionId) {
    window.currentRequisitionId = requisitionId;

    $.ajax({
        url: './ajax/json_for_tracker_v1_0.php',
        type: 'POST',
        data: { req_id: requisitionId },
        dataType: 'json',
        success: function (response) {
            if (response.error_code === 200) {
                const data = response.data[0];
                let currentStepIndex = -1;

                progressOrder.forEach((step, index) => {
                    if (data[step]) currentStepIndex = index;
                });

                const select = document.getElementById('orderProgress');
                [...select.options].forEach((option, index) => {
                    option.disabled = index <= currentStepIndex;
                });

                
                if (data.delivered) {
                    showDeliveryNoteInProgressModal(data);
                } else {
                    document.getElementById('deliveryNoteWrapper').style.display = 'none';
                }


                document.getElementById('progressModal').style.display = 'flex';
            } else {
                alert('Unable to fetch progress data.');
            }
        },
        error: function () {
            alert('Server error while fetching progress.');
        }
    });
}


// Show the delivery note in progress modal if delivered
function showDeliveryNoteInProgressModal(orderData) {
    const progressModal = document.getElementById('progressModal');
    const deliveryNoteWrapper = document.getElementById('deliveryNoteWrapper');
    const deliveryNoteComment = document.getElementById('deliveryNoteComment');
    const deliveryNoteLink = document.getElementById('deliveryNoteLink');

    if (orderData.delivery_file) {
        deliveryNoteComment.textContent = orderData.delivery_note || "Delivery Note Available";

        deliveryNoteLink.onclick = function () {
            openDeliveryModal(orderData.delivery_file);
        };

        deliveryNoteWrapper.style.display = 'block';
    } else {
        deliveryNoteWrapper.style.display = 'none';
    }

    progressModal.style.display = 'flex';
}



// Function to submit progress update
function submitProgressUpdate() {
    const progress = document.getElementById('orderProgress').value;
    const requisitionId = window.currentRequisitionId;

    $.ajax({
        url: './ajax/json_for_tracker_v1_0.php',
        type: 'POST',
        data: {
            req_id: requisitionId,
            action: 'update_progress',
            progress: progress
        },
        dataType: 'json',
        success: function (response) {
            if (response.error_code === 200) {
                alert("Progress updated successfully!");
                closeProgressModal();
                location.reload();
            } else {
                alert("Error: " + response.message);
            }
        },
        error: function (xhr) {
            console.error("AJAX Error:", xhr.responseText);
            alert("Server error. Please try again.");
        }
    });
}

function closeProgressModal() {
    document.getElementById('progressModal').style.display = 'none';
}

// Function to open tracker Modal
function opentrackerModal(requisitionId) {
    window.currentRequisitionId = requisitionId;
    document.getElementById('trackerModal').style.display = '';
    tracker(requisitionId);
}

const tracker = (requisitionId) => {
    $.ajax({
        url: "./ajax/json_for_tracker_v1_0.php",
        type: "POST",
        data: { req_id: requisitionId },
        dataType: "json",
        success: function (response) {
            if (response.error_code === 200) {
                const orderData = response.data[0];

                const steps = [
                    { key: "requested", label: "Order Requested" },
                    { key: "order_placed", label: "Order Placed" },
                    { key: "prepare_for_dispatch", label: "Prepare for Dispatch" },
                    { key: "ready_to_ship", label: "Ready to Ship" },
                    { key: "intransit", label: "In Transit" },
                    { key: "delivered", label: "Delivered" },
                    { key: "closed", label: "Closed" }
                ];

                const tracker = document.getElementById("orderTracker");
                tracker.innerHTML = "";

                // Loop through each progress step
                steps.forEach((step, index) => {
                    const isCompleted = orderData[step.key] !== null;

                    const stepElement = document.createElement("div");
                    stepElement.classList.add("step");
                    if (isCompleted) stepElement.classList.add("completed");

                    stepElement.innerHTML = `
                        <div class="circle">${index + 1}</div>
                        <div class="text">${step.label} ${isCompleted ? `(${orderData[step.key]})` : ""}</div>
                    `;

                    tracker.appendChild(stepElement);
                });

                document.getElementById("trackerModal").style.display = "block";
            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr.responseText);
            alert("Server error. Please try again.");
        }
    });
};

// Trigger file download directly
function openDeliveryModal(fileName) {
    const downloadLink = document.createElement('a');
    //downloadLink.href = `http://localhost/E-SHIP/e_ship_ksm/uploads/${fileName}`;
    downloadLink.href = `https://kaizen.miscos.in/v1_1/e_ship_ksm/uploads/${fileName}`;
    downloadLink.download = fileName;  // This triggers the file download
    downloadLink.click();
}



function closeTrackerModal() {
    document.getElementById('trackerModal').style.display = 'none';
}