// Date : 25-03-2025
// Handle the response from the fetch_requisition API with Status update and edit items in requisition.

// Function to fetch requisitions data
let totalPages = 0;
function fetchRequisitions(page = 1) {
    var formdata = {
        page: page
    };

    $.ajax({
        url: "./ajax/json_for_fetch_requisitions_v1_0.php", 
        type: "GET",   
        data: formdata,
        dataType: "json",
        success: function (response) {
            if (response && response.requests) {
                updateRequisitionCards(response.requests);
                totalPages = response.totalPages; 
                updatePagination(totalPages, page);
            } else {
                console.error("Invalid response format:", response);
            }
        },
        error: function () {
            console.error("Failed to fetch requisitions. Please try again later.");
        }
    });
}

// Function to update requisition cards
function updateRequisitionCards(requests) {
    const container = document.getElementById('request-cards-container');
    container.innerHTML = '';

    requests.forEach(request => {
        const card = document.createElement('div');
        card.classList.add('col-md-4');
        card.innerHTML = `
            <div class="request-card bg-white">
                <h5 class="card-title" style="margin-bottom: -7px; display: flex; justify-content: space-between;">
                    <p><strong>Req no.: ${request.req_no}</strong></p>
                    <p style="font-size: 10px;"><strong>Date: ${formatDate(request.requested_date)}</strong></p>
                </h5>
                <p style="margin-bottom: 3px;">Ship Name: ${request.ship_name}</p>
                <p style="margin-bottom: 3px;">Department: ${request.department}</p>
                <div class="btn-group d-flex justify-content-center mt-2" role="group" aria-label="Request actions">
                    <button type="button" class="btn btn-outline-info btn-sm" title="View" onclick="openItemForm('view', '${request.requisition_id}')">
                        <i class="menu-icon fa fa-eye"></i>
                    </button>
                    <button type="button" class="btn btn-outline-primary btn-sm" title="Edit" onclick="openItemForm('edit', '${request.requisition_id}')">
                        <i class="menu-icon fa fa-edit"></i>
                    </button>
                    <button type="button" class="btn btn-outline-success btn-sm" title="accept" onclick="openItemForm('accept', '${request.requisition_id}')">
                        <i class="menu-icon fa fa-check"></i>
                    </button>
                    <button type="button" class="btn btn-outline-danger btn-sm" title="reject" onclick="openItemForm('reject', '${request.requisition_id}')">
                        <i class="menu-icon fa fa-times"></i>
                    </button>
                </div>
            </div>
        `;
        container.appendChild(card);
    });
}

// Function to update pagination links
function updatePagination(totalPages, currentPage) {
    const pagination = document.getElementById('pagination-links');
    pagination.innerHTML = '';  

    pagination.innerHTML += `<li class="page-item ${currentPage == 1 ? 'disabled' : ''}">
                                <a class="page-link" href="#" onclick="changePage(${currentPage - 1})"><<</a>
                              </li>`;

    for (let page = 1; page <= totalPages; page++) {
        pagination.innerHTML += `<li class="page-item ${page == currentPage ? 'active' : ''}">
                                    <a class="page-link" href="#" onclick="changePage(${page})">${page}</a>
                                  </li>`;
    }

    pagination.innerHTML += `<li class="page-item ${currentPage == totalPages ? 'disabled' : ''}">
                                <a class="page-link" href="#" onclick="changePage(${currentPage + 1})">>></a>
                              </li>`;
}

window.changePage = function(page) {
    if (page < 1 || page > totalPages) return;
    fetchRequisitions(page);
};

// function to format date 
function formatDate(dateString) {
    const date = new Date(dateString);
    const day = String(date.getDate()).padStart(2, '0');
    const month = String(date.getMonth() + 1).padStart(2, '0');
    const year = date.getFullYear();

    return `${day}/${month}/${year}`;  // Format as 'DD/MM/YYYY'
};

fetchRequisitions(1);

// Function to open requisition form
window.openItemForm = function(action, requisitionId) {
    if (action === 'reject') {
        window.location.href = 'reject_items_in_requisition.php?action=' + action + '&requisition_id=' + requisitionId;
    } else {
        window.location.href = 'items_in_requisition.php?action=' + action + '&requisition_id=' + requisitionId;
    }
};

// Fetch the requisition id from the URL
const urlParams = new URLSearchParams(window.location.search);
const requisitionId = urlParams.get('requisition_id');

// function to fetch requisition header 
$.ajax({
    url: './ajax/json_for_fetch_requisitions_v1_0.php',
    type: 'GET',
    data: { requisition_id: requisitionId },
    success: function(response) {
        const data = JSON.parse(response);
        if (data.status === 'success') {
            const details = data.data;

            // Populate the requisition details dynamically
            $('#requisition-details-container').html(`
                <form>
                    <div class="row">
                        <div class="col-md-12 d-flex justify-content-between align-items-center"
                             style="border-bottom: 1px solid skyblue; padding-bottom: 5px; margin-bottom: 10px;">
                             <h6 class="mb-0">🚢 Requisition Number : ${details.req_no}</h6>
                             <h6 class="mb-0" style="text-decoration: underline;">Date: ${details.creation_date}</h6>
                        </div>

                        <div class="col-md-6 info-row">
                            <div class="info-label">Vessel Name:</div>
                            <div class="info-value">${details.ship_name}</div>
                        </div>

                        <div class="col-md-6 info-row">
                            <div class="info-label">Department Name:</div>
                            <div class="info-value">${details.dept_name}</div>
                        </div>

                        <div class="col-md-6 info-row">
                            <div class="info-label">Equipment Name/Engine Type:</div>
                            <div class="info-value">${details.req_eq_name_engine_type}</div>
                        </div>

                        <div class="col-md-6 info-row">
                            <div class="info-label">Model Name/Type:</div>
                            <div class="info-value">${details.req_model_type}</div>
                        </div>

                        <div class="col-md-6 info-row">
                            <div class="info-label">Maker Name:</div>
                            <div class="info-value">${details.req_maker_name}</div>
                        </div>

                        <div class="col-md-6 info-row">
                            <div class="info-label">Maker Address:</div>
                            <div class="info-value">${details.req_maker_address}</div>
                        </div>

                        <div class="col-md-6 info-row">
                            <div class="info-label">Priority Level:</div>
                            <div class="info-value">${details.priority_level}</div>
                        </div>

                        <div class="col-md-6 info-row">
                            <div class="info-label">Category:</div>
                            <div class="info-value">${details.req_eq_name_engine_type}</div>
                        </div>
                    </div>
                </form>
            `);
        } else {
            // alert(data.message);
        }
    }
});

//  funtion to show items in requisition data 
$(document).ready(function() {
    const requisitionId = new URLSearchParams(window.location.search).get('requisition_id');

    // Fetch requisition items
    $.ajax({
        url: './ajax/json_for_fetch_requisitions_v1_0.php',
        type: 'GET',
        data: { requisition_id: requisitionId },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                const data = response.data;
        
                if (data.items) {
                    let tableRows = '';
        
                    data.items.forEach(item => {
                        const itemDetails = item.item_details;
                        
                        tableRows += `
                            <tr>
                                <td class="hidden-column">${itemDetails.item_id}</td>
                                <td>${itemDetails.item_name}</td>
                                <td>${itemDetails.item_drawing_no}</td>
                                <td>${itemDetails.item_part_no}</td>
                                <td>${itemDetails.working_qty}</td>
                                <td>${itemDetails.rob}</td>
                                <td>${itemDetails.req_qty}</td>
                                <td>
                                    <input type="number" id="acceptQty-${itemDetails.item_id}" class="accepted-qty"
                                           style="width:73%; padding: 5px; text-align: center;"
                                           value="${itemDetails.accepted_qty}" 
                                           data-item-id="${itemDetails.item_id}" 
                                           data-requisition-id="${requisitionId}">
                                </td>
                                <td>${itemDetails.remark}</td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary edit-btn" 
                                            onclick="updateItem('${requisitionId}', ${itemDetails.item_id})" 
                                            data-item-id="${itemDetails.item_id}">
                                        Edit
                                    </button>
                                </td>
                            </tr>
                        `;
                    });
        
                    $('#itemListContainer').html(tableRows);
                } else {
                    console.log("No items found in the response data.");
                    alert('No items available.');
                }
            }
        },
               
        
        error: function() {
            alert('Error fetching data from the server.');
        }
    });

    $(document).on('click', '.edit-btn', function() {
        const itemId = $(this).data('item-id');
        const acceptedQtyInput = $('input[data-item-id="' + itemId + '"]');
    
        acceptedQtyInput.prop('disabled', false);
    });
    

    $('.accept-btn').click(function() {
        var requisitionId = $(this).data('requisition-id'); 
        $('#acceptWarning').show();

        $('#confirmAcceptBtn').click(function() {
            // AJAX call for accept button
            $.ajax({
                url: './ajax/json_for_fetch_requisitions_v1_0.php',
                type: 'POST',
                data: {
                    action: 'accept',
                    requisition_id: requisitionId
                },
                success: function(response) {
                    var data = JSON.parse(response);
                    console.log(data);
                    if (data.success) {
                        $('#acceptWarning').hide();
                        $('#acceptedModal').show();
                    } else {
                        alert('Error updating status: ' + (data.error || 'Unknown error'));
                    }
                },
                error: function(xhr, status, error) {
                    // Handle any AJAX errors
                    alert('AJAX Error: ' + error);
                }
            });
        });
    });

    $('#acceptWarning .btn-outline-info').click(function() {
        $('#acceptWarning').hide();
    });

    $('#okBtn').click(function() {
        $('#acceptedModal').hide();
        window.location.href = 'generated_request.php';
    });
});

// Function to update the status after click on reject button 
$(document).ready(function() {
    $('.reject-btn').click(function() {
        var requisitionId = $(this).data('requisition-id'); 
        
        $('#rejectWarning').show();

        $('#confirmRejectBtn').click(function() {
            // AJAX call for reject action
            $.ajax({
                url: './ajax/json_for_fetch_requisitions_v1_0.php',
                type: 'POST',
                data: {
                    action: 'reject',
                    requisition_id: requisitionId
                },
                success: function(response) {
                    var data = JSON.parse(response);
                    if (data.success) {
                        $('#rejectWarning').hide();
                        $('#rejectedModal').show();
                    } else {
                        alert('Error updating status: ' + (data.error || 'Unknown error'));
                    }
                },
                error: function(xhr, status, error) {
                    // Handle any AJAX errors
                    alert('AJAX Error: ' + error);
                }
            });
        });
    });

    $('#rejectWarning .btn-outline-info').click(function() {
        $('#rejectWarning').hide();
    });

    $('#okBtnReject').click(function() {
        $('#rejectedModal').hide();
        window.location.href = 'generated_request.php';  
    });
});


// function to update accepted qty
const updateItem = (reqId, itemId) => {
    let acceptQty = document.getElementById(`acceptQty-${itemId}`).value;
    const formData = {
        req_id: reqId,
        item_id: itemId,
        accepted_qty: acceptQty
    };

    $.ajax({
        url: "./ajax/json_for_items_operation_v1_0.php",
        type: "POST",
        data: $.param(formData), // Serialize data
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "mode": "1"
        },
        success: function (response) {
            console.log(response);
            if (response.error_code === 200) {
                alert("Qntity Update successfully");
            } else {
                // alert('Error: ' + response.message);
                alert('Error: Check your network or try after some time');
            }
        },
        error: function (xhr, status, error) {
            console.log("AJAX Error: ", status, error);
            console.log("Response Text: ", xhr.responseText);
            alert("Server error. Please check the console.");
        }
    });
};
