// Date : 28-03-2025
// Handle the response from the add_user API.

$(document).ready(function() {
    var currentPage = 1;
    var totalPages = 1;

    // Fetch profile data
    function loadProfiles() {
        $.ajax({
            url: "./ajax/json_for_add_user_v1_0.php?action=get_profiles", 
            type: "GET",
            success: function(response) {
                var result = JSON.parse(response);
                if (result.success) {
                    var profiles = result.profiles;
                    var profileHtml = '<option value="">Select Profile</option>';

                    profiles.forEach(function(profile) {
                        profileHtml += `<option value="${profile.profile_id}">${profile.profile_name}</option>`;
                    });
                    $("#profile").html(profileHtml);
                } else {
                    alert(result.message);
                }
            },
            error: function(xhr, status, error) {
                alert("An error occurred while fetching profiles: " + error);
            }
        });
    }

    // Function to load users with pagination
    function loadUsers(searchQuery = '', page = 1) {
        $.ajax({
            url: "./ajax/json_for_add_user_v1_0.php",
            type: "GET",
            data: { search: searchQuery, page: page },
            success: function(response) {
                var result = JSON.parse(response);
                if (result.success) {
                    var users = result.data;
                    var usersHtml = '';

                    users.forEach(function(user) {
                        usersHtml += `
                            <tr>
                                <td>${user.user_name}</td>
                                <td>${user.user_email}</td>
                                <td>${user.user_mobile_no}</td>
                                <td>${user.user_type == 1 ? 'Land' : 'Ship'}</td>
                                <td>${user.profile_name}</td>
                            </tr>
                        `;
                    });

                    $("#usersList").html(usersHtml);
                    totalPages = result.total_pages;
                    currentPage = result.current_page;

                    // Update pagination after search or page change
                    updatePagination(totalPages, currentPage);
                } else {
                    alert(result.message);
                }
            },
            error: function(xhr, status, error) {
                alert("An error occurred while fetching users: " + error);
            }
        });
    }

    // Update pagination links
    function updatePagination(totalPages, currentPage) {
        const pagination = document.getElementById('pagination-links');
        pagination.innerHTML = ''; 

        if (totalPages < 1) return;

        pagination.innerHTML += `<li class="page-item ${currentPage == 1 ? 'disabled' : ''}">
                                    <a class="page-link" href="#" onclick="changePage(${currentPage - 1})"><<</a>
                                  </li>`;

        for (let page = 1; page <= totalPages; page++) {
            pagination.innerHTML += `<li class="page-item ${page == currentPage ? 'active' : ''}">
                                        <a class="page-link" href="#" onclick="changePage(${page})">${page}</a>
                                      </li>`;
        }

        pagination.innerHTML += `<li class="page-item ${currentPage == totalPages ? 'disabled' : ''}">
                                    <a class="page-link" href="#" onclick="changePage(${currentPage + 1})">>></a>
                                  </li>`;
    }

    // Function to handle page change
    window.changePage = function(page) {
        if (page < 1 || page > totalPages) return;  
        loadUsers($("#searchUser").val(), page);  
    };

    // Load initial users
    loadUsers();

    $("#searchUser").on('input', function() {
        var searchQuery = $(this).val();
        loadUsers(searchQuery, 1);  
    });

    // Load profile data when the page loads
    loadProfiles();

    // Script for Email Validation
    function validateEmail(email) {
        const emailRegex = /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
        return emailRegex.test(email);
    }

    // Script for Mobile Number Validation
    function validateMobile(mobile) {
        const mobileRegex = /^[6-9]\d{9}$/; // Starts with 6-9 and followed by 9 digits
        return mobileRegex.test(mobile);
    }

    // Handle form submission to add a new user
    $("#addUserForm").submit(function(event) {
        event.preventDefault();

        var userData = {
            name: $("#name").val(),
            email: $("#email").val(),
            mobile: $("#mobile").val(),
            user_type: $("#user_type").val(),
            profile: $("#profile").val(),
            username: $("#username").val(),
            password: $("#password").val()
        };

        if (!validateEmail(userData.email)) {
            alert("Please enter a valid email address.");
            return;
        }

        if (!validateMobile(userData.mobile)) {
            alert("Please enter a valid mobile number (starting with 6-9 and no more than 10 digits).");
            return;
        }

        // Check if the username, email, or name already exists
        $.ajax({
            url: "./ajax/json_for_add_user_v1_0.php",
            type: "POST",
            data: userData,
            success: function(response) {
                var result = JSON.parse(response);

                if (result.success_code === 200) {
                    alert(result.message);
                    loadUsers($("#searchUser").val(), 1); 
                    $("#addUserForm")[0].reset(); 
                } else {
                    alert(result.message);
                }
            },
            error: function(xhr, status, error) {
                alert("An error occurred: " + error);
            }
        });
    });

    loadUsers();
});
