 // Date : 27-03-2025
    // Handle the response from the add_equipment API.
    $(document).ready(function() {
        // Fetch departments on page load
        $.ajax({
            url: './ajax/json_for_add_equipment_v1_0.php',
            type: 'GET',
            data: { action: 'fetch_departments' },
            success: function(response) {
                var departments = JSON.parse(response);
                var departmentSelect = $('#department_select');
                departmentSelect.empty();
                departmentSelect.append('<option value="">Select Department</option>');
                departments.forEach(function(department) {
                    departmentSelect.append('<option value="' + department.dept_id + '">' + department.dept_name + '</option>');
                });
    
                // Load all equipment initially (without filtering)
                loadEquipment();
            },
            error: function(xhr, status, error) {
                console.error("Error fetching departments: " + error);
                alert("An error occurred while fetching departments.");
            }
        });
    
        // Fetch categories when department is selected
        $('#department_select').change(function() {
            var deptId = $(this).val();
            if (deptId !== '') {
                // Load categories based on selected department
                $.ajax({
                    url: './ajax/json_for_add_equipment_v1_0.php',
                    type: 'GET',
                    data: { action: 'fetch_categories', dept_id: deptId },
                    success: function(response) {
                        var categories = JSON.parse(response);
                        var categorySelect = $('#category_select');
                        categorySelect.empty();
                        categorySelect.append('<option value="">Select Category</option>');
                        categories.forEach(function(category) {
                            categorySelect.append('<option value="' + category.cat_id + '">' + category.cat_name + '</option>');
                        });
    
                        // Now load equipment data based on the department selection
                        loadEquipment(deptId);
                    },
                    error: function(xhr, status, error) {
                        console.error("Error fetching categories: " + error);
                        alert("An error occurred while fetching categories.");
                    }
                });
            } else {
                // Clear categories if no department is selected
                $('#category_select').empty().append('<option value="">Select Category</option>');
                loadEquipment();
            }
        });
    
        // Function to load equipment based on selected department and category
        function loadEquipment(deptId = '', catId = '', searchQuery = '', page = 1) {
            $.ajax({
                url: "./ajax/json_for_add_equipment_v1_0.php",
                type: "GET",
                data: { dept_id: deptId, cat_id: catId, search: searchQuery, page: page },
                success: function(response) {
                    var result = JSON.parse(response);
    
                    if (result.success) {
                        var equipmentHtml = '';
                        result.data.forEach(function(equipment) {
                            equipmentHtml += ` 
                                <tr>
                                    <td>${equipment.eq_name}</td>
                                    <td>${equipment.eq_engine_type}</td>
                                    <td>${equipment.model_name}</td>
                                    <td>${equipment.maker_name}</td>
                                    <td>${equipment.dept_name}</td>
                                    <td>${equipment.cat_name || 'N/A'}</td>
                                </tr>
                            `;
                        });
    
                        $("#equipmentList").html(equipmentHtml);
                        updatePagination(result.total_pages, result.current_page);
                    } else {
                        alert(result.message);
                    }
                },
                error: function(xhr, status, error) {
                    alert("An error occurred while fetching equipment: " + error);
                }
            });
        }
    
        // Update pagination links
        function updatePagination(totalPages, currentPage) {
            const pagination = document.getElementById('pagination-links');
            pagination.innerHTML = '';
    
            if (totalPages <= 1) return;
    
            pagination.innerHTML += ` 
                <li class="page-item ${currentPage === 1 ? 'disabled' : ''}">
                    <a class="page-link" href="#" onclick="changePage(${currentPage - 1})"><<</a>
                </li>
            `;
    
            for (let page = 1; page <= totalPages; page++) {
                pagination.innerHTML += ` 
                    <li class="page-item ${page === currentPage ? 'active' : ''}">
                        <a class="page-link" href="#" onclick="changePage(${page})">${page}</a>
                    </li>
                `;
            }
    
            pagination.innerHTML += ` 
                <li class="page-item ${currentPage === totalPages ? 'disabled' : ''}">
                    <a class="page-link" href="#" onclick="changePage(${currentPage + 1})">>></a>
                </li>
            `;
        }
    
        // Handle page change (pagination)
        window.changePage = function(page) {
            var deptId = $("#department_select").val();
            var catId = $("#category_select").val();
            var searchQuery = $("#searchEquipment").val();
            loadEquipment(deptId, catId, searchQuery, page);
        };
    
        // Search equipment
        $("#searchEquipment").on("input", function() {
            var searchQuery = $(this).val();
            var deptId = $("#department_select").val();
            var catId = $("#category_select").val();
            loadEquipment(deptId, catId, searchQuery);
        });
    
        // Handle form submission using AJAX
        $('#addEquipmentForm').on('submit', function(e) {
            e.preventDefault(); 
    
            // Gather form data
            var formData = {
                dept_id: $('#department_select').val(),
                cat_id: $('#category_select').val(),
                eq_name: $('#eq_name').val(),
                eq_type: $('#eq_type').val(),
                model_name: $('#model_name').val(),
                maker_name: $('#maker_name').val(),
                maker_address: $('#maker_address').val()
            };
    
            // AJAX request to submit the form data
            $.ajax({
                url: './ajax/json_for_add_equipment_v1_0.php',  
                type: 'POST',
                data: formData,
                success: function(response) {
                    var result = JSON.parse(response);
    
                    // Check if the response is successful
                    if (result.success) {
                        alert(result.message);
    
                        $('#addEquipmentForm')[0].reset();
                        loadEquipment(); 
                    } else {
                        alert(result.message); 
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Error occurred: " + error);
                    alert("An error occurred while adding equipment.");
                }
            });
        });
    });
    