<?php
/*
objective : This API handles the submission of requisition data into two tables: requisition_header_all and item_requisition_header_all.
file version : 1.0
API NO : KDN03
Date of creation : 06/05/2025

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Logic Zone :

Date  : 06/05/2025

Request Method:
Type: POST

Headers: Content-Type: application/json

Execution Process

*Step 1: Database Connection
- Establishes a connection using a defined SqlServerConnection class.
- If connection fails, returns error_code 500.

*Step 2: Requisition Header Insert
- Inserts data into the requisition_header_all table.
- If insertion fails, returns error_code 501.

*Step 3: Item Requisition Header Insert
- Inserts each item from the 'items' array into the item_requisition_header_all table.
- If insertion fails, returns error_code 502.

*Step 4: Commit Transaction
- If all insertions are successful, commits the transaction.
- If any insertion fails, rolls back the transaction.

Response Structure

*Success Response
{
    "error_code": 200,
    "message": "Requisition data submitted successfully"
}

*Failure Responses

error_code: 500
message: "SQL Server connection failed"

error_code: 501
message: "Requisition header insert failed"

error_code: 502
message: "Item requisition header insert failed"

-------------------------------------------------------------------------------------------------------------------------------

Date :

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Error Zone :

Date : 

*/

session_start();
require_once '../config/config.php';
header('Content-Type: application/json');

function escapeStr($str) {
    return str_replace("'", "''", $str);
}

function logError($label, $data) {
    file_put_contents(__DIR__ . '/debug_log.txt', "[$label] " . print_r($data, true) . "\n", FILE_APPEND);
}

$data = json_decode(file_get_contents("php://input"), true);
if (!$data) {
    echo json_encode(['error_code' => 400, 'message' => 'Invalid input data']);
    exit;
}

$conn = SqlServerConnection::getConnection();
if ($conn === false) {
    $errors = sqlsrv_errors();
    logError('SQL Connection Failed', $errors);
    echo json_encode(['error_code' => 500, 'message' => 'SQL Server connection failed', 'sql_errors' => $errors]);
    exit;
}

sqlsrv_begin_transaction($conn);

$req_no = escapeStr($data['req_no']);
$req_serial_no = escapeStr($data['req_serial_no']);
$req_eq_name_engine_type = escapeStr($data['req_eq_name_engine_type']);
$req_model_type = escapeStr($data['req_model_type']);
$req_maker_name = escapeStr($data['req_maker_name']);
$req_maker_address = escapeStr($data['req_maker_address']);
$req_remark = escapeStr($data['req_remark']);
$req_for = ($data['req_for'] === 'Spare') ? 1 : (($data['req_for'] === 'Store') ? 2 : 0);
$req_priority = (int)$data['req_priority'];
$req_status = isset($data['req_status']) ? (int)$data['req_status'] : 1;
$dept_id = (int)$data['dept_id'];
$cat_id = (int)$data['cat_id'];
$sub_cat_id = (int)$data['sub_cat_id'];
$sec_sub_cat_id = (int)$data['sec_sub_cat_id'];
$third_sub_cat_id = (int)$data['third_sub_cat_id'];  
$ship_id = 1;  

// Insert requisition header
$insertHeaderSQL = "
    INSERT INTO requisition_header_all (
        req_no, ship_id, dept_id,
        req_serial_no, req_for, req_priority, req_status,
        req_eq_name_engine_type, req_model_type, req_maker_name,
        req_maker_address, req_remark, req_date_of_creation
    ) VALUES (
        N'$req_no', $ship_id, $dept_id,
        N'$req_serial_no', $req_for, $req_priority, $req_status,
        N'$req_eq_name_engine_type', N'$req_model_type', N'$req_maker_name',
        N'$req_maker_address', N'$req_remark', GETDATE()
    )
";

$insertHeaderResult = sqlsrv_query($conn, $insertHeaderSQL);
if (!$insertHeaderResult) {
    $errors = sqlsrv_errors();
    sqlsrv_rollback($conn);
    logError('Header Insert Failed', $errors);
    echo json_encode(['error_code' => 501, 'message' => 'Requisition header insert failed', 'sql_errors' => $errors]);
    exit;
}

// Retrieve req_id for the inserted header
$req_id = null;
$stmt = sqlsrv_query($conn, "SELECT SCOPE_IDENTITY() AS req_id");
if ($stmt && $row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
    $req_id = (int)$row['req_id'];
} else {
    sqlsrv_rollback($conn);
    logError('SCOPE_IDENTITY Failed', sqlsrv_errors());
    echo json_encode(['error_code' => 503, 'message' => 'Failed to retrieve req_id']);
    exit;
}

// Prepare items data
$items = $data['items'] ?? [];
$max_items = 40;
$item_ids = array_fill(0, $max_items, 'NULL');
$ref_array = array_fill(0, $max_items, 'NULL');
$item_details = array_fill(0, $max_items, 'NULL');

foreach ($items as $index => $item) {
    if ($index >= $max_items) break;

    $item_id = (int)($item['item_id'] ?? 0);
    
    $item_ids[$index] = $item_id;

    $cat_id = (int)($item['cat_id'] ?? 0);
    $sub_cat_id = (int)($item['sub_cat_id'] ?? 0);
    $sec_sub_cat_id = (int)($item['sec_sub_cat_id'] ?? 0);
    $third_sub_cat_id = (int)($item['third_sub_cat_id'] ?? 0); 

    if($third_sub_cat_id != 0) {
        $ref = 4;
    } else if($sec_sub_cat_id != 0){
        $ref = 3;
    } else if($sub_cat_id  != 0){
        $ref = 2;
    } else if($cat_id != 0){
        $ref = 1;
    }
$ref_array[$index] = $ref;
    $details = [
        'req_no' => $req_no,
        'cat_id' => (int)($item['cat_id'] ?? 0),
        'sub_cat_id' => (int)($item['sub_cat_id'] ?? 0),
        'sec_sub_cat_id' => (int)($item['sec_sub_cat_id'] ?? 0),
        'third_sub_cat_id' => (int)($item['third_sub_cat_id'] ?? 0),  
        'item_id' => $item_id,
        'drawing_no' => $item['drawing_no'] ?? '',
        'part_no' => $item['part_no'] ?? '',
        'working_qty' => $item['working_qty'] ?? '',
        'rob' => $item['rob'] ?? '',
        'req_qty' => $item['req_qty'] ?? '',
        'unit' => $item['unit'] ?? '',
        'remark' => $item['remark'] ?? ''
    ];

    $jsonDetail = json_encode($details, JSON_UNESCAPED_UNICODE);
    if ($jsonDetail === false) {
        sqlsrv_rollback($conn);
        $jsonError = json_last_error_msg();
        logError('JSON Encode Failed', $details);
        echo json_encode(['error_code' => 504, 'message' => 'JSON encoding failed', 'details' => $jsonError]);
        exit;
    }

    $item_details[$index] = "N'" . escapeStr($jsonDetail) . "'";
}

$columns = "req_id, irq_line_no, current_col_no";
$values = "$req_id, 1, " . count($items);

for ($i = 0; $i < $max_items; $i++) {
    $columns .= ", item_id_" . ($i + 1);
    $values .= ", " . $item_ids[$i];
}
for ($i = 0; $i < $max_items; $i++) {
    $columns .= ", ref_" . ($i + 1);
    $values .= ", " . $ref_array[$i];
}
for ($i = 0; $i < $max_items; $i++) {
    $columns .= ", item_details_" . ($i + 1);
    $values .= ", " . $item_details[$i];
}

$insertItemsSQL = "
    INSERT INTO item_requisition_header_all (
        $columns, item_date_of_creation
    ) VALUES (
        $values, GETDATE()
    )
";

$insertItemsResult = sqlsrv_query($conn, $insertItemsSQL);
if (!$insertItemsResult) {
    $errors = sqlsrv_errors();
    sqlsrv_rollback($conn);
    logError('Items Insert Failed', $errors);
    echo json_encode(['error_code' => 502, 'message' => 'Item requisition insert failed', 'sql_errors' => $errors]);
    exit;
}

// Insert into tracker_header_all
$insertTrackerSQL = "
    INSERT INTO tracker_header_all (req_id, requested)
    VALUES ($req_id, GETDATE())
";

$insertTrackerResult = sqlsrv_query($conn, $insertTrackerSQL);
if (!$insertTrackerResult) {
    $errors = sqlsrv_errors();
    sqlsrv_rollback($conn);
    logError('Tracker Insert Failed', $errors);
    echo json_encode(['error_code' => 505, 'message' => 'Tracker insert failed', 'sql_errors' => $errors]);
    exit;
}

sqlsrv_commit($conn);
echo json_encode(['error_code' => 200, 'message' => 'Requisition data submitted successfully']);
?>