<?php

/*
Objective: This API handles requisition-related operations, including creating a new requisition, fetching requisition details, and managing requisition items.
File Version: 1.0
API NO: SBK03
Date of Creation: 29/03/2025

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Logic Zone:

Date: 28/03/2025

Request Method:
Type: POST

Headers: Content-Type: application/json

Request Parameters:
The API expects the following parameters in the request body:

mode (integer, required) – Determines the operation type:
  - 1: Create a new requisition.
  - 2: Retrieve requisition details.
  - 3: Fetch paginated item details.
  - 4: Add/update requisition items.

req_no (string, optional) – The requisition number (required for modes 2, 3, 4).

sub_cat_id (integer, optional) – The sub-category ID (required for mode 3).

items (array, optional) – List of item details to be added or updated (required for mode 4).

If any required parameter is missing for the selected mode, the API returns an error response.

***********

Authentication & Security

*Step 1: Verify User Session
The system checks if a valid user session exists.

The stored session token is compared against the user_token from the database.

If the tokens do not match, the session is destroyed, and an error response is returned.

***********

Processing Based on Mode

*Mode 1: Create a New Requisition
- A new requisition entry is created in the database.
- The requisition number (req_no) is auto-generated and returned.

*Mode 2: Retrieve Requisition Details
- Fetches requisition details based on req_no.
- Retrieves sub-category details linked to the requisition.

*Mode 3: Fetch Paginated Item Details
- Retrieves item details based on sub_cat_id with pagination.
- Returns item list and pagination metadata.

*Mode 4: Add or Update Requisition Items
- Validates req_no and item data.
- Adds new items or updates existing ones in the requisition.
- Returns success response upon completion.

*Mode 5: Show Item List
- Validates if 'req_no' is provided.
- Fetches and organizes items based on requisition number.
- Returns categorized items.

*Mode 6: Submit Requisition
- Validates if 'req_no' is provided.
- Updates the requisition status to 'submitted' (status = 1).
- Returns success or failure message.

*Mode 7: Update Item Quantity or Remove Item
- Validates required fields.
- Fetches item details and updates 'req_qty' or 'status'.
- Returns success or failure message.

********

Response Structure

*Success Response:
If the request is successful, the API returns:

error_code: 200 (indicating success).

data: The requested information or confirmation message.

*Failure Responses:
If authentication fails, the response contains:

error_code: 401
message: "Unauthorized access. Please log in again."

If a required parameter is missing, the response contains:

error_code: 400
message: "Missing required fields."

If an invalid mode is provided, the response contains:

error_code: 300
message: "Invalid mode specified."

If the request method is not POST, the response contains:

error_code: 405
message: "Invalid request method."

-------------------------------------------------------------------------------------------------------------------------------

Date:

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Error Zone:

Date:

*/


session_start();
require_once '../config/config.php';
// Get the database connection
$conn = connection::getConnection();
// Set response header to return JSON
ob_clean();
header('Content-Type: application/json');
// Retrieve headers
$headers = function_exists('getallheaders') ? getallheaders() : [];
$token_id = $headers['token_id'] ?? null;
$mode = $headers['mode'] ?? null;
$user_id = $_SESSION['user_id'];
$query_for_get_user_token = "SELECT user_token FROM user_header_all WHERE user_id = '$user_id'";
$result_for_get_user_token = mysqli_query($conn, $query_for_get_user_token);
if ($result_for_get_user_token) {
    $row = mysqli_fetch_assoc($result_for_get_user_token);
    if (!$row || $row['user_token'] !== $_SESSION['user_token']) {
        // Token mismatch - clear session
        session_destroy();
        echo json_encode(['error_code' => 900, 'message' => 'session expired']);
        exit;
    }
}
// Default response
$response = ['error_code' => 300];
// Check request method
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if required fields exist
    if($mode == 1){
        if (!isset($_POST['user_id'], $_POST['dept_id'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }
        // Sanitize user inputs
        $ship_id = mysqli_real_escape_string($conn, trim($_POST['ship_id'] ?? ''));
        $user_id = mysqli_real_escape_string($conn, trim($_POST['user_id'] ?? ''));
        $dept_id = mysqli_real_escape_string($conn, trim($_POST['dept_id'] ?? ''));
        $cat_id = mysqli_real_escape_string($conn, trim($_POST['cat_id'] ?? ''));
        $serial_no = mysqli_real_escape_string($conn, trim($_POST['serial_no'] ?? ''));
        $priority = mysqli_real_escape_string($conn, trim($_POST['priority'] ?? ''));
        $eq_id = mysqli_real_escape_string($conn, trim($_POST['engine_type_id'] ?? ''));
        $m_id = mysqli_real_escape_string($conn, trim($_POST['m_id'] ?? ''));
        $req_remark = '';

        $query_for_department = "SELECT dept_name FROM department_header_all WHERE dept_id = '$dept_id'";
        $result_for_department = $conn->query($query_for_department);
        $row_dept_details = mysqli_fetch_assoc($result_for_department);
        $formatted_name = strtoupper(substr($row_dept_details['dept_name'], 0, 1));
        $year = date('y');
        // Fetch latest req_no
        $result_for_get_req_no = mysqli_query($conn, "SELECT u_no FROM unique_id_header_all WHERE u_table_name = 'requisition_header_all'");
        if ($result_for_get_req_no && mysqli_num_rows($result_for_get_req_no) == 1) {
            $row = mysqli_fetch_assoc($result_for_get_req_no);
            $req_no = intval($row['u_no']) + 1;
            $req_no_str = $formatted_name . '-' . $req_no .'-'. $year;
        } else {
            $req_no = 1; 
            $req_no_str = $formatted_name . '-' . $req_no .'-'. $year;
            mysqli_query($conn, "INSERT INTO unique_id_header_all (u_table_name, u_no, u_date_of_creation) VALUES ('requisition_header_all', 1, NOW())");
        }
        // Insert requisition into main table
        $query_for_add_req_header = "INSERT INTO requisition_header_all  
        (req_no, ship_id, dept_id, cat_id, eq_id, m_id, user_id, req_serial_no, req_priority, req_status, req_remark, req_view, req_date_of_creation)
        VALUES 
        ('$req_no_str', '$ship_id', '$dept_id', '$cat_id', '$eq_id', '$m_id', '$user_id', '$serial_no', '$priority', '0', '$req_remark', '0', NOW())";
        if (mysqli_query($conn, $query_for_add_req_header)) {
            // Update `req_no` in unique_header_all
            mysqli_query($conn, "UPDATE unique_id_header_all SET u_no = '$req_no' WHERE u_table_name = 'requisition_header_all'");
            // Store in session
            $_SESSION['req_no'] = $req_no_str;
            $response = [
                'error_code' => 200,
                'message' => "Requisition added successfully",
                'req_no' => $req_no_str
            ];
        } else {
            $response = ['error_code' => 400]; 
        }
    }
    if ($mode == 2) {
        if (!isset($_POST['req_no'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }
        $req_no = mysqli_real_escape_string($conn, $_POST['req_no']);
        $query_for_get_req_details = "SELECT r.req_serial_no, r.req_priority, s.ship_no, s.ship_name, d.dept_no, d.dept_name, 
                                      c.cat_id, c.cat_name, e.eq_name, e.eq_engine_type, m.model_name, m.maker_name, m.maker_address, 
                                      u.user_name 
                                      FROM requisition_header_all r 
                                      LEFT JOIN ship_header_all s ON r.ship_id = s.ship_id 
                                      LEFT JOIN department_header_all d ON r.dept_id = d.dept_id 
                                      LEFT JOIN category_header_all c ON r.cat_id = c.cat_id 
                                      LEFT JOIN equipment_header_all e ON r.eq_id = e.eq_id 
                                      LEFT JOIN modal_maker_header_all m ON r.m_id = m.m_id 
                                      LEFT JOIN user_header_all u ON r.user_id = u.user_id 
                                      WHERE r.req_no = '$req_no'";
        $result_for_get_req_details = mysqli_query($conn, $query_for_get_req_details);
        if ($result_for_get_req_details && mysqli_num_rows($result_for_get_req_details) == 1) {
            $row_req_details = mysqli_fetch_assoc($result_for_get_req_details);
            $cat_id = $row_req_details['cat_id'];
            $query_for_get_sub_cat = "SELECT s.sub_cat_id, s.sub_cat_name FROM sub_category_header_all s LEFT JOIN category_header_all c ON s.cat_id = c.cat_id WHERE s.cat_id = '$cat_id'";
            $result_for_get_sub_cat = mysqli_query($conn, $query_for_get_sub_cat);
            $sub_cat_details = [];
            if (mysqli_num_rows($result_for_get_sub_cat) > 0) {
                while ($row_sub_cat_details = mysqli_fetch_assoc($result_for_get_sub_cat)) {
                    $sub_cat_details[] = $row_sub_cat_details;
                }
            }
            $response = ['error_code' => 200, 'data' => $row_req_details, 'sub_cat' => $sub_cat_details];
        } else {
            $response = ['error_code' => 400, 'message' => 'No data found for the given req_id'];
        }
    }
    if ($mode == 3) {
        if (!isset($_POST['sub_cat_id']) || !isset($_POST['page']) || !isset($_POST['limit']) || !isset($_POST['req_no'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields','data' => $_POST]);
            exit;
        }
        $sub_cat_id = mysqli_real_escape_string($conn, $_POST['sub_cat_id']);
        $page = intval($_POST['page']);
        $limit = intval($_POST['limit']);
        $offset = ($page - 1) * $limit;
        // Get total item count for pagination
        $totalQuery = "SELECT COUNT(*) AS total FROM item_header_all WHERE sub_cat_id = '$sub_cat_id'";
        $totalResult = mysqli_query($conn, $totalQuery);
        $totalRow = mysqli_fetch_assoc($totalResult);
        $totalItems = $totalRow['total'];
        // Fetch only the required page items
        $query_for_get_items_details = "SELECT item_id, item_name, item_drawing_no, item_part_no 
                                        FROM item_header_all 
                                        WHERE sub_cat_id = '$sub_cat_id'
                                        LIMIT $limit OFFSET $offset";
        $result_for_get_items_details = mysqli_query($conn, $query_for_get_items_details);
        $items_details = [];
        while ($row_items_details = mysqli_fetch_assoc($result_for_get_items_details)) {
            $items_details[] = $row_items_details;
        }
        $req_no = mysqli_real_escape_string($conn, trim($_POST['req_no'] ?? ''));
        $query_for_get_items_from_req = "SELECT * FROM item_requisition_header_all WHERE sub_cat_id = '$sub_cat_id' AND req_id = (SELECT req_id FROM requisition_header_all WHERE req_no = '$req_no')";
        $result_for_get_items_from_req = mysqli_query($conn, $query_for_get_items_from_req);
        $items = [];
        if (mysqli_num_rows($result_for_get_items_from_req) > 0) {
            while ($row_get_items_from_req = mysqli_fetch_assoc($result_for_get_items_from_req)) {
                for ($i = 1; $i <= 40; $i++) {
                    if (!empty($row_get_items_from_req["item_id_$i"])) {
                        $item_details_json = $row_get_items_from_req["item_details_$i"];
                        $item_details_array = json_decode($item_details_json, true);
                        $lastItem = end($item_details_array);
                        if (intval($lastItem['status']) !== 2) {
                            $items[] = $row_get_items_from_req["item_id_$i"];
                        }
                    } else {
                        break;
                    }
                }
            }
        }
        $response = [
            'error_code' => 200,
            'data' => $items_details,
            'items' => $items,
            'total_items' => $totalItems // Send total item count for frontend pagination
        ];
    }
    if ($mode == 4) {
        // Check if required POST parameters are set
        if (!isset($_POST['req_no']) || !isset($_POST['item_id']) || !isset($_POST['req_qty']) || !isset($_POST['sub_cat_id'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }
        // Sanitize input values
        $req_no = mysqli_real_escape_string($conn, trim($_POST['req_no'] ?? ''));
        $sub_cat_id = mysqli_real_escape_string($conn, trim($_POST['sub_cat_id'] ?? ''));
        $item_id = mysqli_real_escape_string($conn, trim($_POST['item_id'] ?? ''));
        $working_qty = mysqli_real_escape_string($conn, trim($_POST['working_qty'] ?? ''));
        $rob = mysqli_real_escape_string($conn, trim($_POST['rob'] ?? ''));
        $req_qty = mysqli_real_escape_string($conn, trim($_POST['req_qty'] ?? ''));
        $remark = mysqli_real_escape_string($conn, trim($_POST['remark'] ?? ''));
        // Fetch req_id from requisition_header_all table using req_no
        $query_for_get_req_id = "SELECT req_id FROM requisition_header_all WHERE req_no = '$req_no'";
        $result_for_get_req_id = mysqli_query($conn, $query_for_get_req_id);
        $row_req_details = mysqli_fetch_assoc($result_for_get_req_id);
        $req_id = $row_req_details['req_id'];
        // Create a JSON object for item details
        $item_details = [
            [
                "req_no" => $req_no,
                "sub_cat_id" => $sub_cat_id,
                "item_id" => $item_id,
                "working_qty" => $working_qty,
                "rob" => $rob,
                "req_qty" => $req_qty,
                "accepted_qty" => '',
                "allocated_qty" => '',
                "remark" => $remark,
                "status" => 0
            ]
        ];
        $check_flag = 0;
        // Convert the item details array to a JSON string
        $json_item_details = json_encode($item_details, JSON_UNESCAPED_UNICODE);
        // check previously added or not 
        $query_for_get_items_from_req = "SELECT * FROM item_requisition_header_all WHERE sub_cat_id = '$sub_cat_id' AND req_id = (SELECT req_id FROM requisition_header_all WHERE req_no = '$req_no')";
        $result_for_get_items_from_req = mysqli_query($conn, $query_for_get_items_from_req);
        if (mysqli_num_rows($result_for_get_items_from_req) > 0) {
            while ($row_get_items_from_req = mysqli_fetch_assoc($result_for_get_items_from_req)) {
                $irq_line_no = $row_get_items_from_req['irq_line_no'];
                for ($i = 1; $i <= 40; $i++) {
                    if (!empty($row_get_items_from_req["item_id_$i"]) && $row_get_items_from_req["item_id_$i"] == $item_id) {
                        $col_name_details = 'item_details_' . $i;
                        $update_item_row = "UPDATE item_requisition_header_all SET $col_name_details = '$json_item_details' WHERE req_id = '$req_id' AND sub_cat_id = '$sub_cat_id' AND irq_line_no = '$irq_line_no'";
                        $result_fupdate_item_row = mysqli_query($conn, $update_item_row);
                        // Response based on query execution success or failure
                        if ($result_fupdate_item_row) {
                            $response = ['error_code' => 200];
                        } else {
                            $response = ['error_code' => 500];
                        }
                        $check_flag = 1;
                    } 
                }
            }
        }
        
        if($check_flag == 0){
            // Fetch the last inserted row's column number and line number for the given req_id and sub_cat_id
        $query_for_get_item_row = "SELECT current_col_no, irq_line_no FROM item_requisition_header_all WHERE req_id = '$req_id' AND sub_cat_id = '$sub_cat_id' AND irq_line_no = (SELECT MAX(irq_line_no) FROM item_requisition_header_all WHERE req_id = '$req_id' AND sub_cat_id = '$sub_cat_id')";
        $result_for_get_item_row = mysqli_query($conn, $query_for_get_item_row);
        // If existing row is found, update the item requisition table
        if (mysqli_num_rows($result_for_get_item_row) > 0) {
            $row_current_col = mysqli_fetch_assoc($result_for_get_item_row);
            $col_no = $row_current_col['current_col_no']; // Current column number
            $irq_line_no = $row_current_col['irq_line_no']; // Line number of the row
            $col_name_id = 'item_id_' . $col_no; // Column name for item_id
            $col_name_details = 'item_details_' . $col_no; // Column name for item details
            // Increment column number
            $col_no += 1;
            // Update query to insert item data into the next available column
            $update_item_row = "UPDATE item_requisition_header_all SET current_col_no = '$col_no', $col_name_id = '$item_id', $col_name_details = '$json_item_details' WHERE req_id = '$req_id' AND sub_cat_id = '$sub_cat_id' AND irq_line_no = '$irq_line_no'";
            $result_fupdate_item_row = mysqli_query($conn, $update_item_row);
            // Response based on query execution success or failure
            if ($result_fupdate_item_row) {
                $response = ['error_code' => 200];
            } else {
                $response = ['error_code' => 500];
            }
        } else {
            // If no existing row is found, insert a new row with item details
            $insert_item_row = "INSERT INTO item_requisition_header_all 
                (req_id, sub_cat_id, irq_line_no, current_col_no, item_id_1, item_details_1) 
                VALUES ('$req_id', '$sub_cat_id', 1, 2, '$item_id', '$json_item_details')";
            $result_insert_item_row = mysqli_query($conn, $insert_item_row);
            // Response based on query execution success or failure
            if ($result_insert_item_row) {
                $response = ['error_code' => 200];
            } else {
                $response = ['error_code' => 500];
            }
        }
        }   
    }
    if($mode == 5) {
// for show item list 
        if (!isset($_POST['req_no'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }
        // Sanitize input values
        $req_no = mysqli_real_escape_string($conn, trim($_POST['req_no'] ?? ''));
        $query_for_get_items_from_req = "SELECT * FROM item_requisition_header_all WHERE  req_id = (SELECT req_id FROM requisition_header_all WHERE req_no = '$req_no')";
        $result_for_get_items_from_req = mysqli_query($conn, $query_for_get_items_from_req);
        if($result_for_get_items_from_req && mysqli_num_rows($result_for_get_items_from_req) > 0) {
        while ($row = mysqli_fetch_assoc($result_for_get_items_from_req)) {
            $sub_cat_id = $row['sub_cat_id'];
            $query_for_get_sub_cat_name = "SELECT sub_cat_name FROM sub_category_header_all WHERE sub_cat_id  = '$sub_cat_id'";
            $result_for_get_sub_cat_name = mysqli_query($conn, $query_for_get_sub_cat_name);
            $row_sub_cat_name  = mysqli_fetch_assoc($result_for_get_sub_cat_name);
            $sub_cat_name = $row_sub_cat_name['sub_cat_name'];
            // Initialize array if sub_cat_id not exists
            if (!isset($data[$sub_cat_id])) {
                $data[$sub_cat_id] = [
                    "sub_cat_id" => $sub_cat_id,
                    "sub_cat_name" => $sub_cat_name,
                    "items" => []
                ];
            }
            // Extract item details
            $items = [];
            for ($i = 1; $i <= 40; $i++) {
                if (!empty($row["item_id_$i"])) {
                    $item_details = json_decode($row["item_details_$i"]);
                    // print_r($item_details);
                    $last_item = end($item_details);
                    $item_id = $last_item->item_id;
                    if($last_item->status != 2){
                        $query_for_get_item_details = "SELECT item_id, item_name, item_drawing_no, item_part_no FROM item_header_all WHERE item_id  = '$item_id'";
                        $result_for_get_item_details = mysqli_query($conn, $query_for_get_item_details);
                        $row_item_details  = mysqli_fetch_assoc($result_for_get_item_details);
                        $item_details_for_perticuler_item = [
                            "item_id" => $last_item->item_id,
                            "item_name" => $row_item_details['item_name'],
                            "item_drawing_no" => $row_item_details['item_drawing_no'],
                            "item_part_no" => $row_item_details['item_part_no'],
                            "working_qty" => $last_item->working_qty,
                            "rob" => $last_item->rob,
                            "req_qty" => $last_item->req_qty,
                            "accepted_qty" => '',
                            "allocated_qty" => '',
                            "remark" => $last_item->remark,
                            "status" => $last_item->status
                        ];
                        
                        $items[] = [
                            "item_id" => $row["item_id_$i"],
                            "item_details" => $item_details_for_perticuler_item
                        ];
                    }
                }
            }
            // Add items to corresponding sub_cat_id
            $data[$sub_cat_id]["items"] = array_merge($data[$sub_cat_id]["items"], $items);
        }
        // Re-index array (convert associative keys to sequential)
        $data = array_values($data);
        // Return JSON response
        $response = [
            "error_code" => 200,
            "message" => "Data retrieved successfully",
            "data" => $data
        ];
    } else {
        $response = [
            "error_code" => 700,
            "message" => "empty requisition"
        ]; 
    }  
        }
    if($mode == 6) {
        // Check if required fields are present
        if (!isset($_POST['req_no'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }
        // Sanitize the input
        $req_no = mysqli_real_escape_string($conn, trim($_POST['req_no'] ?? ''));

        $query_for_get_items_from_req = "SELECT * FROM item_requisition_header_all WHERE req_id = (SELECT req_id FROM requisition_header_all WHERE req_no = '$req_no')";
        $result_for_get_items_from_req = mysqli_query($conn, $query_for_get_items_from_req);
        $items = [];
        $item_flag = 0;
        if (mysqli_num_rows($result_for_get_items_from_req) > 0) {
            while ($row_get_items_from_req = mysqli_fetch_assoc($result_for_get_items_from_req)) {
                for ($i = 1; $i <= 40; $i++) {
                    if (!empty($row_get_items_from_req["item_id_$i"])) {
                        $item_details_json = $row_get_items_from_req["item_details_$i"];
                        $item_details_array = json_decode($item_details_json, true);
                        $lastItem = end($item_details_array);
                        if (intval($lastItem['status']) !== 2) {
                            $item_flag = 1;

                            break 2;
                        }
                    } else {
                        break;
                    }
                }
                if($item_flag == 1){
                    break;
                }
            }

            if( $item_flag == 1) {
                $query_for_submit_req = "UPDATE requisition_header_all SET req_status = 1 WHERE req_id = (SELECT req_id FROM requisition_header_all WHERE req_no = '$req_no')";
                $result_for_submit_req = mysqli_query($conn, $query_for_submit_req);
                if($result_for_submit_req) {
                    // Remove the session variable as the request is submitted
                    // unset($_SESSION['req_no']);
                    $response = [
                        'error_code' => 200,
                        'msg' => 'Requisition submitted successfully.'
                    ];
                } else {
                    $response = [
                        'error_code' => 500,
                        'msg' => 'Failed to submit requisition. Please try again.'
                    ];
                }
            } else {
                $response = [
                    'error_code' => 700,
                    'msg' => 'please add item'
                ]; 
            }
        } else {
            $response = [
                'error_code' => 700,
                'msg' => 'please add item'
            ]; 
        }
    }  
    if($mode == 7) {
        if (!isset($_POST['req_no']) || !isset($_POST['item_id']) || !isset($_POST['req_qty']) || !isset($_POST['sub_cat_id']) || !isset($_POST['status'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }
        $req_no = mysqli_real_escape_string($conn, trim($_POST['req_no'] ?? ''));
        $sub_cat_id = mysqli_real_escape_string($conn, trim($_POST['sub_cat_id'] ?? ''));
        $item_id = mysqli_real_escape_string($conn, trim($_POST['item_id'] ?? ''));
        $new_req_qty = mysqli_real_escape_string($conn, trim($_POST['req_qty'] ?? ''));
        $status = mysqli_real_escape_string($conn, trim($_POST['status'] ?? ''));
        // Step 1: Get matching rows
        $query_for_update_qty = "SELECT * FROM item_requisition_header_all 
        WHERE req_id = (SELECT req_id FROM requisition_header_all WHERE req_no = '$req_no') AND sub_cat_id = '$sub_cat_id'";
        $result_for_update_qty = mysqli_query($conn, $query_for_update_qty);
        if (mysqli_num_rows($result_for_update_qty) > 0) {
        while ($row = mysqli_fetch_assoc($result_for_update_qty)) {
            $irq_line_no = $row['irq_line_no'];
        // Step 2: Check for item_id in columns item_id_1 to item_id_40
        for ($i = 1; $i <= 40; $i++) {
        $column_item_id = "item_id_" . $i;
        $column_item_details = "item_details_" . $i;
        if ($row[$column_item_id] == $item_id) { 
            // Step 3: Get item details in JSON format
            $item_details_json = $row[$column_item_details];
            if (!empty($item_details_json)) {
                // Step 4: Decode JSON to PHP array
                $item_details_array = json_decode($item_details_json, true);
                if($status != 2) {
                // Step 5: Update req_qty
                foreach ($item_details_array as &$item) {
                    if ($item['item_id'] == $item_id) {
                        $item['req_qty'] = $new_req_qty; // Update requested quantity
                    }
                }
                // Step 6: Encode updated array back to JSON
                $updated_item_details_json = json_encode($item_details_array);
                // Step 7: Update the database
                $query_for_update_item_qty= "UPDATE item_requisition_header_all 
                                SET $column_item_details = '$updated_item_details_json' 
                                WHERE req_id = (SELECT req_id FROM requisition_header_all WHERE req_no = '$req_no') AND sub_cat_id = '$sub_cat_id' AND irq_line_no = '$irq_line_no'";

                if(mysqli_query($conn, $query_for_update_item_qty)) {
                    $response = [
                        'error_code' => 200,
                        'msg' => 'item update successfully.'
                    ];
                } else {
                    $response = [
                        'error_code' => 500,
                        'msg' => 'internal server error'
                    ];
                }
            } else {
                // Step 5: Update req_qty
                foreach ($item_details_array as &$item) {
                    if ($item['item_id'] == $item_id) {
                        $item['status'] = $status; // Update requested quantity
                    }
                }
                // Step 6: Encode updated array back to JSON
                $updated_item_details_json = json_encode($item_details_array);
                // Step 7: Update the database
                $query_for_update_item_qty= "UPDATE item_requisition_header_all 
                                SET $column_item_details = '$updated_item_details_json' 
                                WHERE req_id = (SELECT req_id FROM requisition_header_all WHERE req_no = '$req_no') AND sub_cat_id = '$sub_cat_id' AND irq_line_no = '$irq_line_no'";

                if(mysqli_query($conn, $query_for_update_item_qty)) {
                    $response = [
                        'error_code' => 600,
                        'msg' => 'item removed successfully.'
                    ];
                } else {
                    $response = [
                        'error_code' => 500,
                        'msg' => 'internal server error'
                    ];
                }
            }
            }
            break 2; // Stop loop once item is found
        }
        }
        }
        } else {
            $response = [
                'error_code' => 400,
                'msg' => 'Not updated'
            ];
        }
    }  
}
// Return JSON response
echo json_encode($response);
?>