<?php
/*
File: json_for_requisition_details_v1_0.php
Purpose: Fetch item details for a specific requisition ID (req_id)
Created: 13/05/2025
*/


session_start();
require_once("../config/config.php");

header('Content-Type: application/json');

$conn = SqlServerConnection::getConnection();

$req_id = isset($_POST['req_id']) ? $_POST['req_id'] : null;

if (!$req_id) {
    echo json_encode([
        "error_code" => 400,
        "message" => "Missing requisition ID"
    ]);
    exit;
}

$header_sql = "SELECT r.req_id, r.req_no, r.ship_id, r.dept_id, r.req_serial_no,
                      r.req_for, r.req_priority, r.req_status, r.req_eq_name_engine_type, r.req_model_type,
                      r.req_maker_name, r.req_maker_address, r.req_remark, r.req_date_of_creation,
                      r.user_id, r.req_view, r.req_edit_count, r.req_edit_details, r.req_quotation_files,
                      (SELECT ship_name FROM ship_header_all WHERE ship_id = r.ship_id) AS ship_name,
                      (SELECT dept_name FROM department_header_all WHERE dept_id = r.dept_id) AS dept_name
               FROM requisition_header_all r
               WHERE r.req_id = ?";
$header_stmt = sqlsrv_query($conn, $header_sql, [$req_id]);

if (!$header_stmt || !($header = sqlsrv_fetch_array($header_stmt, SQLSRV_FETCH_ASSOC))) {
    echo json_encode([
        "error_code" => 404,
        "message" => "Requisition not found."
    ]);
    exit;
}

$priority_level = ($header['req_priority'] == 1) ? 'Normal' : 'Urgent';
$creation_date = $header['req_date_of_creation'] instanceof DateTime
    ? $header['req_date_of_creation']->format('d/m/Y')
    : '';

$items = [];
$item_sql = "SELECT * FROM item_requisition_header_all WHERE req_id = ?";
$item_stmt = sqlsrv_query($conn, $item_sql, [$req_id]);

if ($item_stmt) {
    while ($item_row = sqlsrv_fetch_array($item_stmt, SQLSRV_FETCH_ASSOC)) {
        for ($i = 1; $i <= 40; $i++) {
            $item_id = $item_row["item_id_$i"] ?? null;
            $item_details_json = $item_row["item_details_$i"] ?? null;

            if (!empty($item_id) && !empty($item_details_json)) {
                $item_details = json_decode($item_details_json, true);

                $item_info_stmt = sqlsrv_query(
                    $conn,
                    "SELECT item_id, item_name, item_drawing_no, item_part_no FROM item_header_all WHERE item_id = ?",
                    [$item_id]
                );
                $item_info = sqlsrv_fetch_array($item_info_stmt, SQLSRV_FETCH_ASSOC);

                $items[] = [
                    "item_id" => $item_id,
                    "item_name" => $item_info['item_name'] ?? '',
                    "item_drawing_no" => $item_info['item_drawing_no'] ?? '',
                    "item_part_no" => $item_info['item_part_no'] ?? '',
                    "working_qty" => $item_details['working_qty'] ?? '',
                    "rob" => $item_details['rob'] ?? '',
                    "req_qty" => $item_details['req_qty'] ?? '',
                    "accepted_qty" => $item_details['accepted_qty'] ?? '',
                    "remark" => $item_details['remark'] ?? ''
                ];
            }
        }
    }
}

echo json_encode([
    "error_code" => 200,
    "data" => [
        "header" => [
            "requisition_id" => $header['req_id'],
            "req_no" => $header['req_no'],
            "creation_date" => $creation_date,
            "priority_level" => $priority_level,
            "ship_name" => $header['ship_name'],
            "dept_name" => $header['dept_name'],
            "req_serial_no" => $header['req_serial_no'],
            "req_for" => $header['req_for'],
            "req_eq_name_engine_type" => $header['req_eq_name_engine_type'],
            "req_model_type" => $header['req_model_type'],
            "req_maker_name" => $header['req_maker_name'],
            "req_maker_address" => $header['req_maker_address'],
            "req_remark" => $header['req_remark'],
            "user_id" => $header['user_id'],
            "req_view" => $header['req_view'],
            "req_edit_count" => $header['req_edit_count'],
            "req_edit_details" => $header['req_edit_details'],
            "req_quotation_files" => $header['req_quotation_files']
        ],
        "items" => $items
    ]
]);
?>
