<?php 
/*
objective : This API retrieves hierarchical category and item data including departments, categories, sub-categories, and second-level sub-categories. It also fetches specific item details based on item_name if provided via GET.
file version : 1.0
API NO : KDN02
Date of creation : 05/05/2025

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Logic Zone :

Date  : 06/05/2025

Request Method:
Type: GET

Headers: Content-Type: application/json

Request Parameters (Optional):
item_name (string) – Name of the item to fetch its drawing and part number.

***********

Execution Process

*Step 1: Database Connection
- Establishes a connection using a defined SqlServerConnection class.
- If connection fails, returns error_code 500.

*Step 2: Item Details Fetch (if item_name is provided)
- Queries the item_header_all table using the provided item_name.
- If query fails, returns error_code 501.
- If no result is found, returns null values.

*Step 3: Department Fetch
- Retrieves departments from department_header_all.
- If query fails, returns error_code 502.

*Step 4: Category and Item Hierarchy
- Fetches categories and their sub-categories.
- Each sub-category retrieves second-level sub-categories and items with requisition_type = 1.
- If any sub-query fails, returns error_code 503.

*Step 5: Flat Item List
- Fetches items where requisition_type = 2 from item_header_all.
- If query fails, returns error_code 504.

********

Response Structure

*Success Response
{
    "error_code": 200,
    "departments": [...],
    "categories": [...],
    "flatItems": [...]
}

*Failure Responses

error_code: 500
message: "SQL Server connection failed"

error_code: 501
message: "Item query failed"

error_code: 502
message: "Department query failed"

error_code: 503
message: "Category or Sub-category query failed"

error_code: 504
message: "Flat items query failed"

-------------------------------------------------------------------------------------------------------------------------------

Date :

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Error Zone :

Date : 

*/

session_start();
require_once '../config/config.php';

$conn = SqlServerConnection::getConnection();
header('Content-Type: application/json');

if ($conn === false) {
    die(json_encode([
        'error_code' => 500,
        'error' => 'SQL Server connection failed',
        'details' => sqlsrv_errors()
    ]));
}

if (isset($_GET['item_name'])) {
    $item_name = $_GET['item_name'];

    $sql = "SELECT item_drawing_no, item_part_no FROM item_header_all WHERE item_name = N'$item_name'";
    $result = sqlsrv_query($conn, $sql);

    if ($result === false) {
        echo json_encode([
            'error_code' => 501,
            'item_drawing_no' => null,
            'item_part_no' => null,
            'message' => 'Item query failed'
        ]);
        exit;
    }

    $row = sqlsrv_fetch_array($result, SQLSRV_FETCH_ASSOC);
    echo json_encode([
        'error_code' => 200,
        'item_drawing_no' => $row['item_drawing_no'] ?? null,
        'item_part_no' => $row['item_part_no'] ?? null
    ]);
    exit;
}

//Department Fetch
$departments = [];
$sql_dept = "SELECT dept_id, dept_name FROM department_header_all";
$dept_result = sqlsrv_query($conn, $sql_dept);

if ($dept_result === false) {
    die(json_encode([
        'error_code' => 502,
        'error' => 'Department query failed',
        'details' => sqlsrv_errors()
    ]));
}

while ($row = sqlsrv_fetch_array($dept_result, SQLSRV_FETCH_ASSOC)) {
    $departments[] = $row;
}

//Category and Item Hierarchy
$categories = [];
$sql_cat = "SELECT cat_id, cat_name FROM category_header_all";
$cat_result = sqlsrv_query($conn, $sql_cat);

if ($cat_result === false) {
    die(json_encode([
        'error_code' => 503,
        'error' => 'Category query failed',
        'details' => sqlsrv_errors()
    ]));
}

while ($cat = sqlsrv_fetch_array($cat_result, SQLSRV_FETCH_ASSOC)) {
    $sub_categories = [];

    $sql_sub_cat = "SELECT sub_cat_id, sub_cat_name FROM sub_category_header_all WHERE cat_id = {$cat['cat_id']}";
    $sub_cat_result = sqlsrv_query($conn, $sql_sub_cat);

    if ($sub_cat_result === false) {
        die(json_encode([
            'error_code' => 503,
            'error' => 'Sub-category query failed',
            'details' => sqlsrv_errors()
        ]));
    }

    while ($sub_cat = sqlsrv_fetch_array($sub_cat_result, SQLSRV_FETCH_ASSOC)) {
        $second_sub_categories = [];

        $sql_sec_sub = "SELECT sec_sub_cat_id, sec_sub_cat_name FROM second_sub_category_header_all WHERE sub_cat_id = {$sub_cat['sub_cat_id']}";
        $sec_sub_result = sqlsrv_query($conn, $sql_sec_sub);

        if ($sec_sub_result === false) {
            die(json_encode([
                'error_code' => 503,
                'error' => 'Second sub-category query failed',
                'details' => sqlsrv_errors()
            ]));
        }

        while ($sec_sub = sqlsrv_fetch_array($sec_sub_result, SQLSRV_FETCH_ASSOC)) {
            $third_sub_categories = [];

            $sql_third_sub = "SELECT third_sub_cat_id, third_sub_cat_name FROM third_sub_category_header_all WHERE sec_sub_cat_id = {$sec_sub['sec_sub_cat_id']}";
            $third_sub_result = sqlsrv_query($conn, $sql_third_sub);

            if ($third_sub_result === false) {
                die(json_encode([
                    'error_code' => 503,
                    'error' => 'Third sub-category query failed',
                    'details' => sqlsrv_errors()
                ]));
            }

            while ($third_sub = sqlsrv_fetch_array($third_sub_result, SQLSRV_FETCH_ASSOC)) {
                $items = [];

                $sql_items = "SELECT item_id, item_name FROM item_header_all WHERE third_sub_cat_id = {$third_sub['third_sub_cat_id']} AND type = 1";
                $item_result = sqlsrv_query($conn, $sql_items);

                if ($item_result === false) {
                    die(json_encode([
                        'error_code' => 503,
                        'error' => 'Item query failed under third sub-category',
                        'details' => sqlsrv_errors()
                    ]));
                }

                while ($item = sqlsrv_fetch_array($item_result, SQLSRV_FETCH_ASSOC)) {
                    $items[] = $item;
                }

                $third_sub['items'] = $items;
                $third_sub_categories[] = $third_sub;
            }

            $sec_sub['third_sub_categories'] = $third_sub_categories;
            $second_sub_categories[] = $sec_sub;
        }

        $sub_cat['second_sub_categories'] = $second_sub_categories;
        $sub_categories[] = $sub_cat;
    }

    $cat['sub_categories'] = $sub_categories;
    $categories[] = $cat;
}

//Flat Items
$flatItems = [];
$sql_flat = "SELECT item_id, item_name FROM item_header_all WHERE type = 2";
$flat_result = sqlsrv_query($conn, $sql_flat);

if ($flat_result === false) {
    die(json_encode([
        'error_code' => 504,
        'error' => 'Flat item query failed',
        'details' => sqlsrv_errors()
    ]));
}

while ($item = sqlsrv_fetch_array($flat_result, SQLSRV_FETCH_ASSOC)) {
    $flatItems[] = $item;
}

$response = [
    'error_code' => 200,
    'departments' => $departments,
    'categories' => $categories,
    'flatItems' => $flatItems
];

echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
?>