<?php
session_start();
include './includes/header.php';
?>

<link rel="stylesheet" href="assets/css/style_for_generated_requisitions.css">

<div class="container-scroller">
    <?php include './includes/profilebasenavbar.php'; ?>
    <div class="container-fluid page-body-wrapper">
        <?php include './includes/sidebarmenu.php'; ?>
        <div class="main-panel">
            <div class="content-wrapper">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="home-tab">
                            <div class="tab-content tab-content-basic" style="padding: 0;">
                                <div class="tab-pane fade show active" id="overview" role="tabpanel" aria-labelledby="overview">
                                    <div class="container form-container">
                                        <div class="container mt-2">
                                            <h4 class="mb-4">Add New Equipment</h4>

                                            <div class="card">
                                                <form id="addEquipmentForm" action="add_equipment.php" method="POST">
                                                    <div class="form-group text-center row justify-content-center">
                                                        <div class="col-md-3">
                                                            <label for="department_select"><strong>Department</strong></label>
                                                            <select id="department_select" class="form-control" required>
                                                                <option value="">Select Department</option>
                                                            </select>
                                                        </div>
                                                        
                                                        <div class="col-md-3">
                                                            <label for="category_select"><strong>Category</strong></label>
                                                            <select id="category_select" class="form-control">
                                                                <option value="">Select Category</option>
                                                            </select>
                                                        </div>

                                                        <div class="col-md-3">
                                                            <label for="eq_name"><strong>Equipment Name</strong></label>
                                                            <input type="text" id="eq_name" name="eq_name" class="form-control" placeholder="Enter equipment name" required>
                                                        </div>

                                                        <div class="col-md-3">
                                                            <label for="eq_type"><strong>Equipment Type</strong></label>
                                                            <input type="text" id="eq_type" name="eq_type" class="form-control" placeholder="Enter equipment type" required>
                                                        </div>
                                                    </div>

                                                    <div class="form-group text-center row justify-content-center mt-4">
                                                        <div class="col-md-3">
                                                            <label for="model_name"><strong>Model Name</strong></label>
                                                            <input type="text" id="model_name" name="model_name" class="form-control" placeholder="Enter model name" required>
                                                        </div>

                                                        <div class="col-md-3">
                                                            <label for="maker_name"><strong>Maker Name</strong></label>
                                                            <input type="text" id="maker_name" name="maker_name" class="form-control" placeholder="Enter maker name" required>
                                                        </div>

                                                        <div class="col-md-3">
                                                            <label for="maker_address"><strong>Maker Address</strong></label>
                                                            <input type="text" id="maker_address" name="maker_address" class="form-control" placeholder="Enter maker address" required>
                                                        </div>
                                                    </div>

                                                    <button type="submit" class="btn btn-outline-primary mx-auto d-block">Add Equipment</button>
                                                </form>

                                                <div class="mt-1" style="display: flex; justify-content: flex-end;">
                                                    <input type="text" id="searchEquipment" class="form-control" placeholder="Search equipment" style="max-width: 17%;height: 30px;font-size: 82%;">
                                                </div>

                                                <div id="equipmentTable" class="mt-4">
                                                    <table class="table datatable">
                                                        <thead>
                                                            <tr>
                                                                <th>Equipment Name</th>
                                                                <th>Equipment Type</th>
                                                                <th>Model Name</th>
                                                                <th>Maker Name</th>
                                                                <th>Department</th>
                                                                <th>Category</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="equipmentList">
                                                            <!-- Equipment data will be loaded here -->
                                                        </tbody>
                                                    </table>
                                                </div>

                                                <div id="pagination-links" class="pagination justify-content-center">
                                                    <!-- Pagination buttons will be injected here -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include './includes/footer.php'; ?>
        </div>
    </div>
</div>

<?php include './includes/dependancy.php'; ?>
<script src="assets/js/addEquipment.js"></script>
