<?php
session_start();
include './includes/header.php';
?>

<link rel="stylesheet" href="assets/css/style_for_generated_requisitions.css">

<div class="container-scroller">
    <?php include './includes/profilebasenavbar.php'; ?>
    <div class="container-fluid page-body-wrapper">
        <?php include './includes/sidebarmenu.php'; ?>
        <div class="main-panel">
            <div class="content-wrapper">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="home-tab">
                            <div class="tab-content tab-content-basic" style="padding: 0;">
                                <div class="tab-pane fade show active" id="overview" role="tabpanel"
                                    aria-labelledby="overview">
                                    <div class="container form-container">
                                        <div class="container mt-2">
                                            <h4 class="mb-1">Add New Category</h4>

                                            <div class="card">
                                                <form id="addCategoryForm" action="add_category.php" method="POST">
                                                    <div class="form-group text-center row justify-content-center">
                                                        <div class="col-md-4">
                                                            <label for="department_id"><strong>Select Department</strong></label>
                                                            <select id="department_select" name="department_id" class="form-control mx-auto" required style="max-width: 100%;">
                                                                <option value="">Select a Department</option>
                                                            </select>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <label for="category_name"><strong>Category Name</strong></label>
                                                            <input type="text" id="category_name" name="category_name" class="form-control mx-auto" placeholder="Enter category name" required style="max-width: 100%;">
                                                        </div>
                                                    </div>

                                                    <button type="submit" class="btn btn-outline-primary mx-auto d-block">Add Category</button>
                                                </form>

                                                <div class="mt-1" style="display: flex; justify-content: flex-end;">
                                                    <input type="text" id="searchCategory" class="form-control" placeholder="Search category" style="max-width: 17%; height: 30px;">
                                                </div>

                                                <div id="categoriesTable" class="mt-4">
                                                    <table class="table datatable">
                                                        <thead>
                                                            <tr>
                                                                <th>Category Name</th>
                                                                <th>Department Name</th>
                                                                <th>Status</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="categoriesList">
                                                            <!-- Categories will be loaded here -->
                                                        </tbody>
                                                    </table>
                                                </div>

                                                <div id="pagination-links" class="pagination justify-content-center">
                                                    <!-- Pagination buttons will be injected here -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include './includes/footer.php'; ?>
        </div>
    </div>
</div>

<?php include './includes/dependancy.php'; ?>
<script src="assets/js/addCategory.js"></script>
