const getRequisitionDetails = (userToken, shipId) => {
    let fromDate = document.getElementById("fromDate").value;
    let toDate = document.getElementById("toDate").value;
    let reqType = document.getElementById("reqType").value;
    let department = document.getElementById("department").value;

    // Create a data object
    let formData = {
        ship_id: shipId,
        form_date: fromDate,
        to_date: toDate,
        req_type: reqType,
        dept: department
    };

    $.ajax({
        url: "./ajax/json_for_requisition_report_v1_0.php",
        type: "POST",
        data: $.param(formData), // Serialize data
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "token_id": userToken, // Pass token in headers
            "mode": "1"
        },
        success: function (response) {
            const data = response.data;
            if (response.error_code === 200) { 
                let tableBody = document.getElementById("itemListContainer");
        tableBody.innerHTML = ""; // Clear previous data
        document.getElementById("tot_req").innerText = '';
        document.getElementById("tot_req").innerText = response.total_req;

        data.forEach((item) => {
            let row = document.createElement("tr");
            let statusText = getStatusText(item.req_status);
            row.innerHTML = `
                <td>${item.req_no}</td>
                <td>${item.user_name}</td>
                <td>${item.dept_name}</td>
                <td>${statusText}</td>
                <td>${item.total_po}</td>
                <td>-</td> <!-- Placeholder for Total Amount -->
                <td>
                    <button class="btn btn-outline-primary btn-sm" onclick="viewDetailReport(${item.req_id}, '${userToken}')">View</button>
                </td>
            `;

            tableBody.appendChild(row);
            document.getElementById("req_details").style.display = 'block';
        });
            } else {
                // alert('Error: ' + response.message);
                document.getElementById("req_details").style.display = 'none';
                alert('No requisition found');
            }
        },
        error: function (xhr, status, error) {
            console.log("AJAX Error: ", status, error);
            console.log("Response Text: ", xhr.responseText);
            alert("Server error. Please check the console.");
        }
    });
};

const getAllDepartment = (userToken) => {
    $.ajax({
        url: "./ajax/json_for_requisition_report_v1_0.php",
        type: "POST",
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "token_id": userToken, // Pass token in headers
            "mode": "2"
        },
        success: function (response) {
            const data = response.data;
            if (response.error_code === 200) { 
                const departmentSelect = document.getElementById("department");
        
                data.forEach(dept => {
                    let option = document.createElement("option");
                    option.value = dept.dept_id;
                    option.textContent = dept.dept_name;
                    departmentSelect.appendChild(option);
                });
            } else {
                // alert('Error: ' + response.message);
                alert('Error: Check your network or try after some time');
            }
        },
        error: function (xhr, status, error) {
            console.log("AJAX Error: ", status, error);
            console.log("Response Text: ", xhr.responseText);
            alert("Server error. Please check the console.");
        }
    });

}

const getStatusText = (status) => {
    switch (parseInt(status)) {
        case 0:
            return "partial";
        case 1:
            return "pending";
        case 2:
            return "accepted";
        case 3:
            return "cancel";
        case 4:
            return "return";
        case 5:
            return "operational";
        case 6:
            return "complete";
        default:
            return "unknown"; // Handle unexpected statuses
    }
}

const viewDetailReport = (reqId, userToken) => {

    let formData = {
        req_id: reqId
    };

    $.ajax({
        url: "./ajax/json_for_requisition_report_v1_0.php",
        type: "POST",
        data: $.param(formData), // Serialize data
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "token_id": userToken, // Pass token in headers
            "mode": "3"
        },
        success: function (response) {
            alert('test');
            if (response.error_code === 200) { 
                displayReport(response);
                $("#reqReport").show(); 
                    // document.getElementById("reqReport").style.display = 'block';
               
            } else {
                // alert('Error: ' + response.message);
                alert('Error: Check your network or try after some time');
            }
        },
        error: function (xhr, status, error) {
            console.log("AJAX Error: ", status, error);
            console.log("Response Text: ", xhr.responseText);
            alert("Server error. Please check the console.");
        }
    });

}

const displayReport = (response) => {
    let html = `
        <h3>Requisition Details</h3>
        <table>
            <tr><th>Serial No</th><td>${response.data.req_serial_no}</td></tr>
            <tr><th>Priority</th><td>${response.data.req_priority}</td></tr>
            <tr><th>Ship Name</th><td>${response.data.ship_name} (${response.data.ship_no})</td></tr>
            <tr><th>Department</th><td>${response.data.dept_name} (${response.data.dept_no})</td></tr>
            <tr><th>Equipment</th><td>${response.data.eq_name} - ${response.data.eq_engine_type}</td></tr>
        </table>
        
        <h3>Total Vendors: ${response.totalVendors}</h3>

        <h3>Item List</h3>
        <table>
            <tr>
                <th>Item Name</th>
                <th>Drawing No</th>
                <th>Part No</th>
                <th>Working Qty</th>
                <th>Req Qty</th>
                <th>Remark</th>
            </tr>`;

    response.item_details[0].items.forEach(item => {
        html += `
            <tr>
                <td>${item.item_details.item_name}</td>
                <td>${item.item_details.item_drawing_no}</td>
                <td>${item.item_details.item_part_no}</td>
                <td>${item.item_details.working_qty}</td>
                <td>${item.item_details.req_qty}</td>
                <td>${item.item_details.remark}</td>
            </tr>`;
    });

    html += `</table><h3>Vendor-wise Items</h3>`;

    response.po.forEach((vendor, index) => {
        html += `
            <h4>Vendor ${index + 1}: ${vendor.vendor_name} (${vendor.vendor_address})</h4>
            <table>
                <tr>
                    <th>Item Name</th>
                    <th>Part No</th>
                    <th>Ordered Qty</th>
                    <th>Rate</th>
                    <th>Currency</th>
                </tr>`;

        vendor.poi_items.forEach(item => {
            html += `
                <tr>
                    <td>${item.item_details.item_name}</td>
                    <td>${item.item_details.item_part_no}</td>
                    <td>${item.item_details.ordered_qty}</td>
                    <td>${item.item_details.rate}</td>
                    <td>${item.item_details.currency}</td>
                </tr>`;
        });

        html += `</table>`;
    });

    document.getElementById("viewReport").innerHTML = html;
    // Create the buttons dynamically
    let buttonContainer = document.createElement("div");
    buttonContainer.style.textAlign = "center";
    buttonContainer.style.marginTop = "10px";

    let downloadButton = document.createElement("button");
    downloadButton.className = "btn btn-outline-success btn-sm";
    downloadButton.innerText = "Download PDF";
    downloadButton.onclick = () => generatePDF(response); // Passing response as a parameter

    let closeButton = document.createElement("button");
    closeButton.className = "btn btn-outline-danger btn-sm";
    closeButton.innerText = "Close";
    closeButton.onclick = closeTrackerModal;

    // Append buttons to container
    buttonContainer.appendChild(downloadButton);
    buttonContainer.appendChild(closeButton);

    // Append the button container to the modal
    document.getElementById("viewReport").appendChild(buttonContainer);
}

function generatePDF(responseData) {
    const { jsPDF } = window.jspdf;
    let doc = new jsPDF("p", "mm", "a4");

    // Title
    doc.setFont("helvetica", "bold");
    doc.setFontSize(16);
    doc.text("Requisition Report", 105, 15, null, null, "center");

    let y = 25; // Starting Y position

    // Requisition Details
    doc.setFontSize(12);
    doc.setFont("helvetica", "bold");
    doc.text("Requisition Details", 10, y);
    y += 5;
    
    const requisitionDetails = [
        ["Serial No", responseData.data.req_serial_no],
        ["Priority", responseData.data.req_priority],
        ["Ship Name", `${responseData.data.ship_name} (${responseData.data.ship_no})`],
        ["Department", `${responseData.data.dept_name} (${responseData.data.dept_no})`],
        ["Equipment", `${responseData.data.eq_name} - ${responseData.data.eq_engine_type}`]
    ];
    
    doc.autoTable({
        startY: y,
        head: [["Field", "Value"]],
        body: requisitionDetails,
        theme: "grid",
        styles: { fontSize: 10, cellPadding: 3 },
        headStyles: { fillColor: [0, 123, 255] }
    });
    
    y = doc.lastAutoTable.finalY + 10;

    // Vendor Count
    doc.setFontSize(12);
    doc.setFont("helvetica", "bold");
    doc.text(`Total Vendors: ${responseData.totalVendors}`, 10, y);
    y += 5;

    // Item List
    doc.setFontSize(12);
    doc.text("Item List", 10, y);
    y += 5;

    let items = responseData.item_details[0].items.map(item => [
        item.item_details.item_name,
        item.item_details.item_drawing_no,
        item.item_details.item_part_no,
        item.item_details.working_qty,
        item.item_details.req_qty,
        item.item_details.remark
    ]);

    doc.autoTable({
        startY: y,
        head: [["Item Name", "Drawing No", "Part No", "Working Qty", "Req Qty", "Remark"]],
        body: items,
        theme: "striped",
        styles: { fontSize: 10, cellPadding: 3 },
        headStyles: { fillColor: [0, 123, 255] }
    });

    y = doc.lastAutoTable.finalY + 10;

    // Vendor-wise Item List
    doc.setFontSize(12);
    doc.text("Vendor-wise Items", 10, y);
    y += 5;

    responseData.po.forEach((vendor, index) => {
        doc.setFont("helvetica", "bold");
        doc.text(`${index + 1}. ${vendor.vendor_name} (${vendor.vendor_address})`, 10, y);
        y += 5;

        let vendorItems = vendor.poi_items.map(item => [
            item.item_details.item_name,
            item.item_details.item_part_no,
            item.item_details.ordered_qty,
            item.item_details.rate,
            item.item_details.currency
        ]);

        doc.autoTable({
            startY: y,
            head: [["Item Name", "Part No", "Ordered Qty", "Rate", "Currency"]],
            body: vendorItems,
            theme: "striped",
            styles: { fontSize: 10, cellPadding: 3 },
            headStyles: { fillColor: [0, 123, 255] }
        });

        y = doc.lastAutoTable.finalY + 10;
    });

    doc.save("Requisition_Report.pdf");
}

function closeTrackerModal() {
    $("#reqReport").hide();
}