// Date : 25-03-2025

// Handle the response from the json_for_get_dept_data API.
const getDepartmentDetails = () => {
    var formData = {
        mode: "1"
    };

    $.ajax({
        url: "./ajax/json_for_get_dept_data_v1_0.php",
        type: "POST",
        data: formData,
        dataType: "json",
        success: function (response) {
            let departmentSelect = $("#departmentSelect");
            let categoryDropdown = $("#categoryDropdown");
            let engineDropdown = $("#engineDropdown");
        
            // Clear existing options and hide errors
            categoryDropdown.empty().append('<option value="" selected disabled>Select Category</option>');
            engineDropdown.empty().append('<option value="" selected disabled>Equipment Name/Engine Type</option>');

            let errorMessageDiv = $("#departmentError");
            departmentSelect.empty(); // Clear existing options
            errorMessageDiv.hide(); // Hide previous errors

            $("#modelType").val(' ');
            $("#makerName").val(' ');
            $("#makerAddress").val(' ');

            switch (response.error_code) {
                case 200:
                    if (response.data.length > 0) {
                        departmentSelect.append('<option value="" selected disabled>Select Department</option>');
                        response.data.forEach(dept => {
                            departmentSelect.append(`<option value="${dept.dept_id}">${dept.dept_name}</option>`);
                        });
                    } else {
                        errorMessageDiv.text("No departments available. Please contact support.").show();
                    }
                    break;

                case 400:
                    errorMessageDiv.text("Error: Missing required fields.").show();
                    break;

                case 500:
                    errorMessageDiv.text("Server error! Please try again later.").show();
                    break;

                default:
                    errorMessageDiv.text("Unexpected error occurred while fetching department details.").show();
                    break;
            }
        },
        error: function () {
            $("#departmentError").text("Failed to connect to the server.").show();
        }
    });
};

// Call function on page load
$(document).ready(function () {
    getDepartmentDetails();
});


// select department function 

const getCategoryDetails = (deptId) => {
    if (!deptId) return;

    var formData = {
        dept_id: deptId,
        mode: "2"
    };

    $.ajax({
        url: "./ajax/json_for_get_dept_data_v1_0.php",
        type: "POST",
        data: formData,
        dataType: "json",
        success: function (response) {
            let categoryDropdown = $("#categoryDropdown");
            let engineDropdown = $("#engineDropdown");
            let errorMessageDiv = $("#departmentError");

            // Clear existing options and hide errors
            categoryDropdown.empty().append('<option value="" selected disabled>Select Category</option>');
            engineDropdown.empty().append('<option value="" selected disabled>Equipment Name/Engine Type</option>');
            errorMessageDiv.hide();

            // Check response status
            if (response.error_code === 200) {
                if (response.data.length > 0) {
                    if (response.data_from === "cat") {
                        response.data.forEach(cat => {
                            categoryDropdown.append(`<option value="${cat.cat_id}">${cat.cat_name}</option>`);
                        });
                        categoryDropdown.prop("disabled", false); 
                    } else {
                        response.data.forEach(engine => {
                            engineDropdown.append(`<option value="${engine.eq_id}">${engine.eq_name}</option>`);
                        });
                        categoryDropdown.prop("disabled", true); 
                    }
                } else {
                    errorMessageDiv.text("No data available. Please contact support.").show();
                }
            } else {
                errorMessageDiv.text("Unexpected error occurred while fetching data.").show();
            }
        },
        error: function () {
            $("#departmentError").text("Failed to connect to the server.").show();
        }
    });
};

const getMakerDetails = (catId) => {
    if (!catId) return;

    var formData = {
        cat_id: catId,
        mode: "3"
    };

    $.ajax({
        url: "./ajax/json_for_get_dept_data_v1_0.php",
        type: "POST",
        data: formData,
        dataType: "json",
        success: function (response) {
            let engineDropdown = $("#engineDropdown");
            let errorMessageDiv = $("#departmentError");
            engineDropdown.empty().append('<option value="" selected disabled>Equipment Name/Engine Type</option>');
            errorMessageDiv.hide();

            // Check response status
            if (response.error_code === 200) {
                if (response.data.length > 0 || response.data != '') {
                    if (response.data_from === "eq") {
                        response.data.forEach(engine => {
                            engineDropdown.append(`<option value="${engine.eq_id}">${engine.eq_name}</option>`);
                        });
                        engineDropdown.prop("disabled", false); 
                    } else {
                        $("#modelMakerId").val(response.data.m_id);
                        $("#modelType").val(response.data.model_name);
                        $("#makerName").val(response.data.maker_name);
                        $("#makerAddress").val(response.data.maker_address);
                        engineDropdown.prop("disabled", true); 
                    }
                } else {
                    errorMessageDiv.text("No data available. Please contact support.").show();
                }
            } else {
                errorMessageDiv.text("Unexpected error occurred while fetching data.").show();
            }
        },
        error: function () {
            $("#departmentError").text("Failed to connect to the server.").show();
        }
    });
};

const getMakerDetailsByequType = (eqId) => {
    if (!eqId) return;

    var formData = {
        eq_id: eqId,
        mode: "4"
    };

    $.ajax({
        url: "./ajax/json_for_get_dept_data_v1_0.php",
        type: "POST",
        data: formData,
        dataType: "json",
        success: function (response) {
            let errorMessageDiv = $("#departmentError");
            errorMessageDiv.hide();

            // Check response status
            console.log(response);
            if (response.error_code === 200) {
                if (response.data != '') {   
                    $("#modelMakerId").val(response.data.m_id);
                    $("#modelType").val(response.data.model_name);
                    $("#makerName").val(response.data.maker_name);
                    $("#makerAddress").val(response.data.maker_address);
                } else {
                    errorMessageDiv.text("No data available. Please contact support.").show();
                }
            } else {
                errorMessageDiv.text("Unexpected error occurred while fetching data.").show();
            }
        },
        error: function () {
            $("#departmentError").text("Failed to connect to the server.").show();
        }
    });
};


// function for check validation 

const submitRequisitionHeaderCheckValiodation = () => {
    let isValid = true;

    $('#requestForm input, #requestForm select').each(function() {
        const value = $(this).val();

        if (typeof value === 'undefined' || value === null) {
            return true;
        }

        if (value.trim() === '') {
            isValid = false;
            return false;
        }
    });

    if (!isValid) {
        alert('All fields are mandatory!');
    } else {
        document.getElementById('shipModal').style.display = '';
    }
} 

// function for submit request header 

const submitRequisitionHeader = (user_id, ship_id, user_token) => {
    // Collect form data
    const formData = {
        vessel_name: document.getElementById('vesselName').value,
        ship_id: ship_id,
        user_id: user_id,
        dept_id: document.getElementById('departmentSelect').value,
        cat_id: document.getElementById('categoryDropdown').value,
        serial_no: document.getElementById('serialNo').value,
        priority: document.getElementById('priority').value,
        engine_type_id: document.getElementById('engineDropdown').value,
        model_type: document.getElementById('modelType').value,
        maker_name: document.getElementById('makerName').value,
        maker_address: document.getElementById('makerAddress').value,
        m_id: document.getElementById('modelMakerId').value,

    };

    $.ajax({
        url: "./ajax/json_for_submit_requisition_header_v1_0.php",
        type: "POST",
        data: $.param(formData), // Serialize data
        dataType: "json",
        contentType: "application/x-www-form-urlencoded", // Explicitly setting content type
        headers: {
            "token_id": user_token, // Pass token in headers
            "mode":"1"
        },
        success: function (response) {
            console.log(response);
            if (response.error_code === 200) {
                // alert('Requisition generated successfully. Add items you need in it.');
                window.location.href = 'add_item_to_requisition.php'; // Corrected redirect
            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function () {
            $("#departmentError").text("Failed to connect to the server.").show();
        }
    });
};
