// script for fetch tree data
document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('tree').style.display = 'none';
    const treeRoot = document.getElementById('tree');
    const departmentSelect = document.getElementById('departmentSelect');
    
    $.ajax({
        url: './ajax/fetch_tree_data.php',
        type: 'GET',
        dataType: 'json',
        success: function (response) {
            buildTree(response.categories, treeRoot);
            populateDepartments(response.departments, departmentSelect);
        },
        error: function () {
            console.error("Failed to fetch tree data.");
        }
    });
});

// script for radio button type
function handleRequisitionTypeChange() {
    const radio = document.querySelector('input[name="requisitionType"]:checked')?.value || null;
    const type = document.querySelector('input[name="requisitionType"]:checked')?.value;
    const spareFields = document.getElementById('spareFields');
    const storeFields = document.getElementById('storeFields');
    const treeRoot = document.getElementById('tree');
    const itemTableSection = document.getElementById('itemTableSection');
    const searchContainer = document.getElementById('searchContainer');
    itemTableSection.style.display = 'none';

    
    if(radio == 'Store') {
        const req_eq_name_engine_type = document.getElementById('engineDiv');
        const req_model_type = document.getElementById('modelDiv');
        const req_maker_name = document.getElementById('makerDiv');
        const req_maker_address = document.getElementById('makeraddressDiv');
        const serial_no = document.getElementById('serialNoDiv');
        const departmentDiv = document.getElementById('departmentDiv');
        const priorityDiv = document.getElementById('priorityDiv');
        req_eq_name_engine_type.style.display = 'none';
        req_model_type.style.display = 'none';
        req_maker_name.style.display = 'none';
        req_maker_address.style.display = 'none';
        serial_no.style.display = 'none';

        [departmentDiv, priorityDiv].forEach(el => {
            el.classList.remove('col-md-4');
            el.classList.add('col-md-6');
        });
    }
    

    const radios = document.querySelectorAll('input[name="requisitionType"]');
    radios.forEach(radio => {
        radio.disabled = true;
    });

    if (type === 'Spare') {
        var typeToSend = 1;
        spareFields.style.display = 'flex';
    } else if (type === 'Store') {
        var typeToSend = 2;
        storeFields.style.display = 'flex';
    }
    searchContainer.style.display = type === 'Store' ? 'block' : 'none';
    treeRoot.innerHTML = '';
    treeRoot.style.display = 'block';
    $.ajax({
        url: './ajax/fetch_tree_data.php',
        type: 'GET',
        data:{type: typeToSend},
        dataType: 'json',
        success: function (response) {
            itemTableSection.style.display = 'block';
            if (type === 'Spare') {
                treeRoot.classList.remove('store-mode');
                buildTree(response.categories, treeRoot);
            } else {
                treeRoot.classList.add('store-mode');
                buildFlatItemList(response.flatItems, treeRoot);
            }
        },
        error: function () {
            console.error("Failed to fetch tree data.");
        }
    });
}

// Populate department dropdown
function populateDepartments(departments, dropdown) {
    dropdown.innerHTML = '<option value="" selected disabled>Select Department</option>';
    departments.forEach(dept => {
        const option = document.createElement('option');
        option.value = dept.dept_id;
        option.textContent = dept.dept_name;
        dropdown.appendChild(option);
    });
}

// script for spare tree
function buildFlatItemList(items, parent) {
    const radios = document.querySelector('input[name="requisitionType"]:checked')?.value || null;

    items.forEach(item => {
        const itemLi = document.createElement('li');
        itemLi.textContent = `${item.item_name} (${item.item_part_no})`;
        itemLi.dataset.itemId = item.item_id;
        itemLi.classList.add('item');
        itemLi.style.cursor = 'pointer';
        itemLi.addEventListener('click', () => addItemToTable(item, item.item_id,radios.value));
        parent.appendChild(itemLi);
    });
}

// Collapse all previously expanded nodes
function collapseAllExpandedNodes() {
    const expandedNodes = document.querySelectorAll('#tree .expanded');
    expandedNodes.forEach(node => {
        node.classList.remove('expanded');  
    });
}

// Build the tree with categories, subcategories, and items
const buildTree = (categories, parent) => {
    categories.forEach(category => {
        const catLi = document.createElement('li');
        catLi.textContent = category.cat_name;
        catLi.classList.add('folder', 'category');
        const subCatUl = document.createElement('ul');

        catLi.dataset.catId = category.cat_id;

        if (category.sub_categories?.length) {
            category.sub_categories.forEach(subcat => {
                const subCatLi = document.createElement('li');
                subCatLi.textContent = subcat.sub_cat_name;
                subCatLi.classList.add('folder', 'subcategory');
                const secondSubUl = document.createElement('ul');

                subCatLi.dataset.subCatId = subcat.sub_cat_id;

                if (subcat.second_sub_categories?.length) {
                    subcat.second_sub_categories.forEach(secSub => {
                        const secSubLi = document.createElement('li');
                        secSubLi.textContent = secSub.sec_sub_cat_name;
                        secSubLi.classList.add('folder', 'secondsubcategory');
                        const thirdSubUl = document.createElement('ul');

                        secSubLi.dataset.secSubCatId = secSub.sec_sub_cat_id;

                        if (secSub.third_sub_categories?.length) {
                            secSub.third_sub_categories.forEach(thirdSub => {
                                const thirdSubLi = document.createElement('li');
                                thirdSubLi.textContent = thirdSub.third_sub_cat_name;
                                thirdSubLi.classList.add('folder', 'thirdsubcategory');
                                const itemUl = document.createElement('ul');

                                thirdSubLi.dataset.thirdSubCatId = thirdSub.third_sub_cat_id;
                                const radios = document.querySelector('input[name="requisitionType"]:checked')?.value || null;
                                if (thirdSub.items?.length) {
                                    thirdSub.items.forEach(item => {
                                        const itemLi = document.createElement('li');
                                        itemLi.textContent = item.item_name;
                                        itemLi.classList.add('item');
                                        itemLi.style.cursor = 'pointer';
                                        // Add hidden data attributes
                                        itemLi.dataset.itemId = item.item_id;
                                        itemLi.dataset.catId = catLi.dataset.catId;
                                        itemLi.dataset.subCatId = subCatLi.dataset.subCatId;
                                        itemLi.dataset.secSubCatId = secSubLi.dataset.secSubCatId;
                                        itemLi.dataset.thirdSubCatId = thirdSubLi.dataset.thirdSubCatId;

                                        itemLi.addEventListener('click', (event) => {
                                            event.stopPropagation();
                                            addItemToTable(item, 
                                                itemLi.dataset.itemId,
                                                radios, 
                                                itemLi.dataset.catId, 
                                                itemLi.dataset.subCatId, 
                                                itemLi.dataset.secSubCatId, 
                                                itemLi.dataset.thirdSubCatId
                                            );
                                        });

                                        itemUl.appendChild(itemLi);

                                    });
                                } else {
                                    const noItemLi = document.createElement('li');
                                    noItemLi.textContent = 'No data found for this';
                                    noItemLi.classList.add('no-data');
                                    itemUl.appendChild(noItemLi);
                                }

                                thirdSubLi.appendChild(itemUl);
                                thirdSubUl.appendChild(thirdSubLi);
                                addToggleIfHasChildren(thirdSubLi);
                            });
                        } else {
                            const noThirdSubLi = document.createElement('li');
                            noThirdSubLi.textContent = 'No data found for this';
                            noThirdSubLi.classList.add('no-data');
                            thirdSubUl.appendChild(noThirdSubLi);
                        }

                        secSubLi.appendChild(thirdSubUl);
                        secondSubUl.appendChild(secSubLi);
                        addToggleIfHasChildren(secSubLi);
                    });
                } else {
                    const noSecSubLi = document.createElement('li');
                    noSecSubLi.textContent = 'No data found for this';
                    noSecSubLi.classList.add('no-data');
                    secondSubUl.appendChild(noSecSubLi);
                }

                subCatLi.appendChild(secondSubUl);
                subCatUl.appendChild(subCatLi);
                addToggleIfHasChildren(subCatLi);
            });
        } else {
            const noSubCatLi = document.createElement('li');
            noSubCatLi.textContent = 'No data found for this';
            noSubCatLi.classList.add('no-data');
            subCatUl.appendChild(noSubCatLi);
        }

        catLi.appendChild(subCatUl);
        addToggleIfHasChildren(catLi);

        catLi.addEventListener('click', function (e) {
            e.stopPropagation();
            collapseAllExpandedNodes(); 

            this.classList.add('expanded');

            const requisitionType = document.querySelector('input[name="requisitionType"]:checked').value;

            if (requisitionType === 'Spare') {
                document.getElementById('engineDropdown').value = category.cat_name;
            }

            if (category.cat_name === 'Store') {
                document.querySelectorAll('.category, .subcategory, .secondsubcategory, .thirdsubcategory, .item').forEach(el => {
                    el.style.display = 'none';
                });

                document.getElementById('flatItemContainer').style.display = 'block';

            } else {
                document.querySelectorAll('.category, .subcategory, .secondsubcategory, .thirdsubcategory, .item').forEach(el => {
                    el.style.display = '';
                });

                document.getElementById('flatItemContainer').style.display = 'none';
            }
        });


        parent.appendChild(catLi);
    });
};


// Script for search result
function searchTree(query) {
    const type = document.querySelector('input[name="requisitionType"]:checked')?.value;
    const items = document.querySelectorAll('#tree li');
    query = query.trim().toLowerCase();

    if (!query) {
        handleRequisitionTypeChange(); 
        return;
    }
    items.forEach(li => {
        const text = li.textContent.toLowerCase();
        if (text.includes(query)) {
            li.style.display = '';
            showParents(li);
        } else {
            li.style.display = 'none';
        }
    });
}

// show parent tree data 
function showParents(el) {
    let parent = el.parentElement;
    while (parent && parent.id !== 'tree') {
        if (parent.tagName === 'UL') parent.style.display = 'block';
        if (parent.tagName === 'LI') {
            parent.classList.add('expanded');
            parent.style.display = '';
        }
        parent = parent.parentElement;
    }
}

// script to expand tree structure
function addToggleIfHasChildren(liElement) {
    const hasChildList = liElement.querySelector('ul');
    if (hasChildList) {
        liElement.classList.add('has-children');
        liElement.addEventListener('click', function (e) {
            e.stopPropagation();
            this.classList.toggle('expanded');
        });
    }
}

// script to add item in datatable
let currentSrNo = 0;
function addItemToTable(item, item_id, radios, cat_id = 0, sub_cat_id = 0, sec_sub_cat_id = 0, third_sub_cat_id = 0) {
    const tbody = document.querySelector('#itemDetailsTable tbody');
     const thead = document.querySelector('#itemDetailsTable thead');

    console.log(item);
    const existing = Array.from(tbody.querySelectorAll('td:nth-child(2)')).find(td => td.textContent === item.item_name);
    if (existing) return;

    currentSrNo++; 
    const row = document.createElement('tr');
    
    row.innerHTML = `
        <td style="text-align: center;">${currentSrNo}</td>
        <td style="text-align: center;">${item.item_name}</td>
        <td class="drawingNo" style="text-align: center;">Loading...</td>
        <td class="" style="text-align: center;">Loading...</td>
        <td class="workingQty" style="text-align: center;"><input type="number" class="form-control" name="working_qty[]" style="height: 2px;"></td>
        <td style="text-align: center;"><input type="number" class="form-control" name="rob[]" style="height: 2px;"></td>
        <td style="text-align: center;"><input type="number" class="form-control" name="req_qty[]" style="height: 2px;"></td>
        <td class="unitField" style="text-align: center;"><input type="text" class="form-control" value = '${item.uom}' name="units[]" style="height: 2px;"></td>
        <td style="text-align: center;"><input type="text" class="form-control" name="remarks[]" style="height: 2px;"></td>
     
    `;
    
    row.dataset.itemId = item_id;
    row.dataset.catId = cat_id;
    row.dataset.subCatId = sub_cat_id;
    row.dataset.secSubCatId = sec_sub_cat_id;
    row.dataset.thirdSubCatId = third_sub_cat_id;

    tbody.appendChild(row);
    if (radios === 'Spare') {
        // Hide "Unit" column
        row.querySelectorAll('.unitField').forEach(el => el.style.display = 'none');
        thead.querySelectorAll('th')[7].style.display = 'none'; // 8th column = index 7
    } else {
        // Hide Drawing No and Working Qty columns
        row.querySelectorAll('.drawingNo, .workingQty').forEach(el => el.style.display = 'none');
        thead.querySelectorAll('th')[2].style.display = 'none'; // 3rd column
        
        thead.querySelectorAll('th')[4].style.display = 'none'; // 5th column
    }

    // Fetch item details via AJAX
    $.ajax({
        url: `./ajax/fetch_tree_data.php?item_name=${encodeURIComponent(item.item_name)}`,
        type: 'GET',
        dataType: 'json',
        success: function (data) {
            row.children[2].textContent = data.item_drawing_no || 'N/A';
            row.children[3].textContent = data.item_part_no || 'N/A';
        },
        error: function () {
            row.children[2].textContent = 'N/A';
            row.children[3].textContent = 'N/A';
        }
    });
}

function removeRow(btn) {
    const row = btn.closest('tr');
    row.remove();
    updateSerialNumbers();
}

function storeRowData(btn) {
    const row = btn.closest('tr');
    const workingQty = row.querySelector('[name="working_qty[]"]').value;
    const rob = row.querySelector('[name="rob[]"]').value;
    const reqQty = row.querySelector('[name="req_qty[]"]').value;
    const units = row.querySelector('[name="units[]"]').value;
    const remarks = row.querySelector('[name="remarks[]"]').value;

    const itemId = row.dataset.itemId;
    const catId = row.dataset.catId;
    const subCatId = row.dataset.subCatId;
    const secSubCatId = row.dataset.secSubCatId;
    const thirdSubCatId = row.dataset.thirdSubCatId;




    const rowData = {
        itemId: itemId,
        catId: catId,
        subCatId: subCatId,
        secSubCatId:secSubCatId,
        thirdSubCatId:thirdSubCatId,
        item_name: row.children[1].textContent,
        working_qty: workingQty,
        rob: rob,
        req_qty: reqQty,
        units: units,
        remarks: remarks
    };
    console.log(rowData);
}

function updateSerialNumbers() {
    const rows = document.querySelectorAll('#itemDetailsTable tbody tr');
    rows.forEach((row, index) => {
        row.children[0].textContent = index + 1;
    });
}


function submitRequisition() {
    const getValue = id => document.getElementById(id)?.value.trim();
    const getRadioValue = name => document.querySelector(`input[name="${name}"]:checked`)?.value;

    const req_no = getValue('requisitionNumber');
    const dept_id = getValue('departmentSelect');
    const req_serial_no = getValue('serialNo');
    const req_for = getRadioValue('requisitionType');
    const req_priority = getValue('priority');
    const req_eq_name_engine_type = getValue('engineDropdown');
    const req_model_type = getValue('modelType');
    const req_maker_name = getValue('makerName');
    const req_maker_address = getValue('makerAddress');
    const req_remark = getValue('remark');

    const cat_id = window.selectedCatId || null;
    const sub_cat_id = window.selectedSubCatId || null;
    const sec_sub_cat_id = window.selectedSecSubCatId || null;
    const third_sub_cat_id = window.selectedThirdSubCatId || null;

    // Validate required fields
    if (!req_no || !req_for) {
        alert("Please enter requisition number.");
        return;
    }

    // Extract item rows
    const rows = document.querySelectorAll('#itemDetailsTable tbody tr');
    if (rows.length === 0) {
        alert("Please add at least one item to the requisition.");
        return;
    }

    const items = Array.from(rows).map(row => {
        
        return {
            item_id: row.dataset.itemId,
            item_name: row.children[1].textContent.trim(),
            drawing_no: row.children[2].textContent.trim(),
            part_no: row.children[3].textContent.trim(),
            working_qty: row.querySelector('[name="working_qty[]"]').value.trim(),
            rob: row.querySelector('[name="rob[]"]').value.trim(),
            req_qty: row.querySelector('[name="req_qty[]"]').value.trim(),
            unit: row.querySelector('[name="units[]"]').value.trim(),
            remark: row.querySelector('[name="remarks[]"]').value.trim(),
            cat_id: row.dataset.catId,
            sub_cat_id: row.dataset.subCatId,
            sec_sub_cat_id: row.dataset.secSubCatId,
            third_sub_cat_id: row.dataset.thirdSubCatId
        };
    });

    const data = {
        req_no,
        dept_id,
        req_serial_no,
        req_for,
        req_priority,
        req_eq_name_engine_type,
        req_model_type,
        req_maker_name,
        req_maker_address,
        req_remark,
        cat_id,
        sub_cat_id,
        sec_sub_cat_id,
        third_sub_cat_id,
        items
    };

    // Submit usiing AJAX
    $.ajax({
        url: './ajax/submit_requisition.php',
        type: 'POST',
        contentType: 'application/json',
        data: JSON.stringify(data),
        dataType: 'json',
        success: function (response) {
            if (response.error_code === 200) {
                alert('Requisition submitted successfully');
                location.reload();
            } else {
                alert('Error: ' + response.message);
                console.error('Server Response:', response);
            }
        },
        error: function (xhr, status, error) {
            alert('An unexpected error occurred.');
            console.error('AJAX Error:', error);
        }
    });
}

