// Date : 01-04-2025
// Handle the response from the fetch_accepted_requisitions API with allocate vendor and PO generation.
// Handle add new vendor and upload qoatation file from the fetch_vendors API.

// Function to fetch requisitions data
let totalPages = 0;

// Function to fetch requisitions data
function fetchRequisitions(page = 1) {
    var formdata = {
        page: page
    };
    $.ajax({
        url: "./ajax/json_for_fetch_operational_requisitions_v1_0.php",
        type: "POST",
        data: formdata,
        dataType: "json",
        success: function (response) {
            if (response && response.requests) {
                updateRequisitionCards(response.requests);
                totalPages = response.totalPages;
                updatePagination(totalPages, page);  
            } else {
                console.error("Invalid response format:", response);
            }
        },
        error: function () {
            console.error("Failed to fetch requisitions. Please try again later.");
        }
    });
}


// Function to update requisition cards
function updateRequisitionCards(requests) {
    const container = document.getElementById('request-cards-container');
    container.innerHTML = ''; // Clear the existing cards

    requests.forEach(request => {
    if (request.delivered != null) {
        return; // Skip this iteration
    }
        console.log(requests);
        const card = document.createElement('div');
        card.classList.add('col-md-4');
        let updateButton = '';
if (request.intransit != null) {
    updateButton = `
        <button type="button" class="btn btn-outline-primary btn-sm flex-fill" style="width:50%; font-size: 70%;" title="Update Progress" onclick="openProgressModal(${request.req_id});">
            <i class="menu-icon fa fa-arrow-circle-right" style="font-size:13px;"></i> Update
        </button>`;
}
        card.innerHTML = `
            <div class="request-card bg-white">
                <h5 class="card-title" style="margin-bottom: -7px; display: flex; justify-content: space-between;">
                    <p><strong>Req no.: ${request.requisition_no}</strong></p>
                    <p style="font-size: 10px;"><strong>Date: ${formatDate(request.requested_date)}</strong></p>
                </h5>
                <p style="margin-bottom: 3px;">Ship Name: ${request.ship_name}</p>
                <p style="margin-bottom: 3px;">Department: ${request.department}</p>

                <div style="display: flex; justify-content: center; margin-top: 10px;">
                    <button type="button" class="btn btn-outline-info btn-sm flex-fill" style="width:50%; font-size: 70%;" title="Show Details" onclick="openDetailsModal(${request.req_id});">
                        <i class="menu-icon fa fa-info-circle" style="font-size:13px;"></i>Details
                    </button>
                    ${updateButton}
                    <button type="button" class="btn btn-outline-warning btn-sm flex-fill" style="width:50%; font-size: 70%;" title="Track Requisition" onclick="opentrackerModal(${request.req_id});">
                        <i class="menu-icon fa fa-bullseye" style="font-size:13px;"></i> Track
                    </button>
                </div>
            </div>
        `;
        container.appendChild(card);
    });
}

// Function to update pagination links
function updatePagination(totalPages, currentPage) {
    const pagination = document.getElementById('pagination-links');
    pagination.innerHTML = '';  

    pagination.innerHTML += `<li class="page-item ${currentPage == 1 ? 'disabled' : ''}">
                                <a class="page-link" href="#" onclick="changePage(${currentPage - 1})"><<</a>
                              </li>`;

    for (let page = 1; page <= totalPages; page++) {
        pagination.innerHTML += `<li class="page-item ${page == currentPage ? 'active' : ''}">
                                    <a class="page-link" href="#" onclick="changePage(${page})">${page}</a>
                                  </li>`;
    }

    pagination.innerHTML += `<li class="page-item ${currentPage == totalPages ? 'disabled' : ''}">
                                <a class="page-link" href="#" onclick="changePage(${currentPage + 1})">>></a>
                              </li>`;
}


// Change page function
window.changePage = function (page) {
    if (page < 1 || page > totalPages) return;  
    fetchRequisitions(page);
};

// Function to format date 
function formatDate(dateString) {
    const date = new Date(dateString);
    const day = String(date.getDate()).padStart(2, '0');
    const month = String(date.getMonth() + 1).padStart(2, '0');
    const year = date.getFullYear();

    return `${day}/${month}/${year}`;  // Format as 'DD/MM/YYYY'
};

fetchRequisitions(1);


function openDetailsModal(requisitionId) {
    $.ajax({
        url: './ajax/json_for_requisition_details_v1_0.php',
        type: 'POST',
        data: { req_id: requisitionId },
        dataType: 'json',
        success: function(response) {
            if (response.error_code === 200 && response.data) {
                const tbody = document.getElementById("detailsTableBody");
                tbody.innerHTML = "";

                response.data.forEach(item => {
                    const row = document.createElement("tr");
                    row.innerHTML = `
                        <td class="hidden-column">${item.item_id}</td>
                        <td>${item.item_name}</td>
                        <td>${item.item_drawing_no}</td>
                        <td>${item.item_part_no}</td>
                        <td>${item.working_qty}</td>
                        <td>${item.rob}</td>
                        <td>${item.req_qty}</td>
                        <td>${item.remark}</td>
                    `;
                    tbody.appendChild(row);
                });

                document.getElementById("detailsModal").style.display = "block";
            } else {
                alert("No details found.");
            }
        },
        error: function(xhr) {
            console.error("Error:", xhr.responseText);
            alert("Error fetching requisition details.");
        }
    });

}

function closeDetailsModal() {
    document.getElementById("detailsModal").style.display = "none";
}



function openProgressModal(reqId) {
    // Remove existing modal if any
    const existingModal = document.getElementById("deliveryPopup");
    if (existingModal) existingModal.remove();

    // Create overlay
    const overlay = document.createElement("div");
    overlay.id = "deliveryPopup";
    overlay.style.cssText = `
        position: fixed;
        top: 0; left: 0;
        width: 100%; height: 100%;
        background: rgba(0,0,0,0.5);
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 9999;
    `;

    // Create modal content
    const modal = document.createElement("div");
    modal.style.cssText = `
        background: #fff;
        padding: 20px;
        border-radius: 8px;
        width: 30%;
        box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    `;

    modal.innerHTML = `
        <h3 class="text-center" style="margin-top: 0; color: #1d5589;">Update Delivery Status</h3>

        <div class="form-group" style="margin-bottom: 10px;">
            <label for="deliveryDate"><strong>Date:</strong></label>
            <input type="date" class="form-control" id="deliveryDate" style="width: 50%;">
        </div>

        <div class="form-group" style="margin-bottom: 10px;">
            <label for="deliveryNote"><strong>Delivery Note:</strong></label>
            <input type="text" class="form-control" id="deliveryNote" style="width: 100%;">
        </div>

        <div class="form-group" style="margin-bottom: 10px;">
            <label for="uploadFile"><strong>Upload File:</strong></label>
            <input type="file" class="form-control" id="uploadFile" style="width: 100%;">
        </div>

        <div class="form-group" style="margin-bottom: 10px;">
            <label>
                <input type="checkbox" id="disputeCheck"> Dispute
            </label>
        </div>

        <div id="disputeExtraFields" class="form-group" style="display: none; margin-bottom: 10px;">
            <label for="disputeComment"><strong>Comment:</strong></label>
            <textarea class="form-control" id="disputeComment" rows="3" style="width: 100%;"></textarea>
        </div>

        <div style="text-align: center;">
            <button class="btn btn-outline-success btn-sm" onclick="submitProgressUpdate('${reqId}')">Submit</button>
            <button class="btn btn-outline-danger btn-sm" onclick="document.getElementById('deliveryPopup').remove()">Cancel</button>
        </div>
    `;

    overlay.appendChild(modal);
    document.body.appendChild(overlay);

    // Enable conditional textarea
    setTimeout(() => {
        document.getElementById("disputeCheck").addEventListener("change", function () {
            document.getElementById("disputeExtraFields").style.display = this.checked ? "block" : "none";
        });
    }, 10);
}

function submitProgressUpdate(reqId) {
    const deliveryDate = document.getElementById("deliveryDate").value;
    const deliveryNote = document.getElementById("deliveryNote").value;
    const fileInput = document.getElementById("uploadFile");
    const isDispute = document.getElementById("disputeCheck").checked;
    const disputeComment = isDispute ? document.getElementById("disputeComment").value : '';

    if (!deliveryDate || !deliveryNote) {
        alert("Date and Note are required.");
        return;
    }

    const formData = new FormData();
    formData.append('req_id', reqId);
    formData.append('delivery_date', deliveryDate);
    formData.append('delivery_note', deliveryNote);
    formData.append('delivery_comment', disputeComment);
    formData.append('req_status', 4); // Delivered

    if (fileInput.files[0]) {
        formData.append('delivery_file', fileInput.files[0]);
    }

    formData.append('action', 'update_delivery');

    $.ajax({
        url: './ajax/json_for_tracker_v1_0.php',
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function (response) {
            try {
                const res = JSON.parse(response);
                alert(res.message);
                if (res.error_code === 200) {
                    document.getElementById("deliveryPopup").remove();
                    location.reload();
                }
            } catch (e) {
                alert("Invalid response from server.");
            }
        },
        error: function () {
            alert("Error submitting the form.");
        }
    });
}


// Function to open tracker Modal
function opentrackerModal(requisitionId) {
    window.currentRequisitionId = requisitionId;
    document.getElementById('trackerModal').style.display = ''; 
    tracker(requisitionId);
}

const tracker = (requisitionId) => {
    $.ajax({
        url: "./ajax/json_for_tracker_v1_0.php",
        type: "POST",
        data: { req_id: requisitionId },
        dataType: "json",
        success: function (response) {
            if (response.error_code === 200) {
                const orderData = response.data[0];

                const steps = [
                    { key: "requested", label: "Order Requested" },
                    { key: "order_placed", label: `Order Placed` },
                    { key: "prepare_for_dispatch", label: "Prepare for Dispatch" },
                    { key: "ready_to_ship", label: "Ready to Ship" },
                    { key: "intransit", label: "In Transit" },
                    { key: "delivered", label: "Delivered" }
                ];

                const tracker = document.getElementById("orderTracker");
                tracker.innerHTML = ""; 

                steps.forEach((step, index) => {
                    const isCompleted = orderData[step.key] !== null;

                    const stepElement = document.createElement("div");
                    stepElement.classList.add("step");
                    if (isCompleted) stepElement.classList.add("completed");

                    stepElement.innerHTML = `
                        <div class="circle">${index + 1}</div>
                        <div class="text">${step.label} ${isCompleted ? `(${formatDate(orderData[step.key])})` : ""}</div>
                    `;

                    tracker.appendChild(stepElement);
                });

                document.getElementById("trackerModal").style.display = "block";

            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr.responseText);
            alert("Server error. Please try again.");
        }
    });
}

function closeTrackerModal() {
    document.getElementById('trackerModal').style.display = 'none'; 
}

