<?php 
/*
objective : This API authenticates users by verifying their credentials (username, password, and user type). If authentication is successful, it returns user details along with a secure token.
file version : 1.0
API NO : KDN01
Date of creation : 24/03/2015

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Logic Zone :

Date  : 24/03/2015

Request Method
Type: POST

Headers: Content-Type: application/json

Request Parameters
The API expects the following parameters in the request body:

user_name (string, required) – The username for login.

pass (string, required) – The password provided by the user.

user_type (string, required) – The type of user (e.g., ship_user, admin).
If any required parameter is missing, the API returns an error response.

***********

Authentication Process

*Step 1: Input Validation
The system checks if all required fields are provided.

If any field is missing, it returns an error response indicating "Missing required fields."

*Step 2: Fetch User Details
The provided username and user type are sanitized to prevent SQL injection.

A query is executed to retrieve user details from the database based on the provided username and user type.

*Step 3: Password Verification
If no matching user is found, an error response is returned indicating "Invalid credentials."

If a user is found, the provided password is compared against the stored hashed password.

If the password is incorrect, an error response is returned indicating "Invalid credentials."

*Step 4: Generate Secure Token
If authentication is successful, a secure token is generated using a cryptographic function.

The token is added to the response to be used for further authenticated requests.

********

Response Structure

*Success Response
If authentication is successful, the API returns:

error_code: 200 (indicating success).

data: The user’s details retrieved from the database.

token: A secure session token.

*Failure Responses
If the username or password is incorrect, the response contains:

error_code: 100

message: "Invalid credentials"

*If required fields are missing, the response contains:

error_code: 400

message: "Missing required fields"

If the request method is not POST, the response contains:

error_code: 300

-------------------------------------------------------------------------------------------------------------------------------

Date :

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Error Zone :

Date : 

*/
session_start();
require_once '../config/config.php';

// Get the database connection
$conn = SqlServerConnection::getConnection();

// Set response header to return JSON
header('Content-Type: application/json');

$response = ['error_code' => 300]; // Default response for invalid request

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check for required fields
    if (!isset($_POST['user_name'], $_POST['pass'], $_POST['user_type'])) {
        echo json_encode(['error_code' => 400, 'message' => 'Missing required fields']);
        exit;
    }

    // Sanitize input (parameterized queries will also prevent SQL injection)
    $user_name = trim($_POST['user_name']);
    $pass = $_POST['pass'];
    $type = trim($_POST['user_type']);

    // Step 1: Fetch user from database
    $query_for_find_user = "
        SELECT 
            u.user_id, u.ship_id, u.user_no, u.user_name, u.user_email, u.user_type, 
            u.user_profile_id, u.user_token, s.ship_name 
        FROM user_header_all u 
        LEFT JOIN ship_header_all s ON u.ship_id = s.ship_id 
        WHERE u.user_name_for_login = ? AND u.user_pass = ? AND u.user_type = ?
    ";
    $params = [$user_name, $pass, $type];
    $stmt = sqlsrv_query($conn, $query_for_find_user, $params);

    if ($stmt && ($user_details = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC))) {
        // Step 2: Generate secure token
        $token = substr(bin2hex(random_bytes(16)), 0, 16);

        // Step 3: Update token in database
        $query_for_update_token = "
            UPDATE user_header_all 
            SET user_token = ? 
            WHERE user_name_for_login = ? AND user_pass = ? AND user_type = ?
        ";
        $update_params = [$token, $user_name, $pass, $type];
        $update_stmt = sqlsrv_query($conn, $query_for_update_token, $update_params);

        if ($update_stmt) {
            $profile_id = $user_details['user_profile_id'];
            $ship_id = $user_details['ship_id'];

            // Step 4: Fetch profile name
            $query_for_get_profile_details = "SELECT profile_name FROM profile_header_all WHERE profile_id = ?";
            $profile_stmt = sqlsrv_query($conn, $query_for_get_profile_details, [$profile_id]);
            $profile_details = sqlsrv_fetch_array($profile_stmt, SQLSRV_FETCH_ASSOC);

            // Step 5: Set session variables
            $_SESSION['user_id'] = $user_details['user_id'];
            $_SESSION['ship_id'] = $user_details['ship_id'];
            $_SESSION['user_no'] = $user_details['user_no'];
            $_SESSION['user_name'] = $user_details['user_name'];
            $_SESSION['user_email'] = $user_details['user_email'];
            $_SESSION['user_type'] = $user_details['user_type'];
            $_SESSION['user_profile_id'] = $user_details['user_profile_id'];
            $_SESSION['ship_name'] = $user_details['ship_name'];
            $_SESSION['user_token'] = $token;
            $_SESSION['profile_name'] = $profile_details['profile_name'] ?? '';
            $_SESSION['user_initials'] = getInitials($user_details['user_name']);

            // Step 6: Return response
            $response = [
                'error_code' => 200,
                'data' => $user_details,
                'token' => $token,
                'profile name' => $profile_details['profile_name'] ?? ''
            ];
        } else {
            $response = ['error_code' => 500, 'message' => 'Failed to update token'];
        }
    } else {
        $response = ['error_code' => 100, 'message' => 'Invalid credentials'];
    }
}

// Function to get initials from full name
function getInitials($fullName) {
    $nameParts = explode(" ", trim($fullName));
    if (count($nameParts) == 1) {
        return strtoupper(substr($nameParts[0], 0, 1));
    } else {
        return strtoupper(substr($nameParts[0], 0, 1) . substr(end($nameParts), 0, 1));
    }
}

// Output final response
echo json_encode($response);
?>
