<?php
session_start();
  include './includes/header.php';
?>
<!DOCTYPE html>
<html lang="en">
<link rel="stylesheet" href="assets/css/style_for_generated_requisitions.css">
<style>
    .rmodel {
        display: none;
        position: fixed;
        z-index: 1000;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.5);
        overflow: auto;
    }

    .rmodel-content {
        background-color: #fff;
        margin: 5% auto;
        padding: 20px;
        width: 70%;
        border-radius: 8px;
        box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
        animation: fadeIn 0.3s ease-in-out;
    }

    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }

    #reqReport .report {
        max-height: 400px;
        overflow-y: auto;
        padding: 10px;
        border: 1px solid #ddd;
        border-radius: 5px;
        background: #f9f9f9;
    }

    #reqReport h2, h3 {
        text-align: center;
        color: #333;
    }

    #reqReport table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 15px;
    }
    /* 
    #reqReport th, td {
        padding: 10px;
        border: 1px solid #ddd;
        text-align: left;
    } */

    #reqReport th {
        background-color: #007bff;
        color: white;
    }

    #reqReport ul {
        list-style: none;
        padding: 0;
    }

    #reqReport ul li {
        padding: 5px 0;
        border-bottom: 1px solid #ddd;
    }

    #reqReport button {
        margin: 10px;
    }
</style>

<body class="with-welcome-text">
    <div class="container-scroller">
        <!-- partial:partials/_navbar.html -->
        <?php
          include './includes/profilebasenavbar.php';
        ?>
        <!-- partial -->
        <div class="container-fluid page-body-wrapper">
            <!-- partial:partials/_sidebar.html -->
            <?php
              include './includes/sidebarmenu.php';
            ?>
            <!-- partial -->
            <!-- style="background:rgb(4 74 226 / 6%);" -->
            <div class="main-panel">
            <div class="content-wrapper">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="home-tab">
                            <div class="tab-content tab-content-basic" style="padding: 0;">
                                <div class="tab-pane fade show active" id="overview" role="tabpanel" aria-labelledby="overview">
                                    <div class="container form-container" style="width:100%;">
                                        <div class="container">
                                            <h3 class="mb-1 text-center">Requisition Report</h3>
                                            <div class="row" id="reqId">
                                                <div class="card">
                                                    <h6 style="color: green;">*Note: Not all fields are mandatory.</h6>
                                                    <div class="form-group text-center row justify-content-center">
                                                        <div class="col-md-3">
                                                            <label for="fromDate"><strong>From Date:</strong></label>
                                                            <input type="date" class="form-control" id="fromDate" name="fromDate">
                                                        </div>
                                                        
                                                        <div class="col-md-3">
                                                            <label for="category_select"><strong>To Date:</strong></label>
                                                            <input type="date" class="form-control" id="toDate" name="toDate">
                                                        </div>

                                                        <div class="col-md-3">
                                                            <label for="reqType"><strong>Requisition Type:</strong></label>
                                                            <select id="reqType" class="form-control" name="reqType">
                                                                <option value="" selected disabled>Select requisition type</option>
                                                                <option value="1">Partial</option>
                                                                <option value="2">Pending</option>
                                                                <option value="3">Accepted</option>
                                                                <option value="4">Cancelled</option>
                                                                <option value="5">Return</option>
                                                                <option value="6">Operational</option>
                                                                <option value="7">Complete</option>
                                                            </select>
                                                        </div>

                                                        <div class="col-md-3">
                                                            <label for="department"><strong>Department:</strong></label>
                                                            <select id="department" class="form-control" name="department">
                                                                <option value="" selected disabled>Select departmnet</option>
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="text-center">
                                                        <button class="btn btn-outline-success btn-sm" type="button" onclick = "getRequisitionDetails();">Show</button>
                                                    </div>
                                                </div>
                                            </div> 
                                        </div>
                                    </div>

                                    <div id = "req_details" class="container form-container mt-2" style="width:100%;">
                                        <div class="container">
                                            <div class="text-center" style="width: 50%; margin: auto;">
                                                <b>Total no of requisition :</b> <span id = "tot_req">0</span>
                                            </div>
                                        </div>
                                        <div class="mt-3">
                                            <table class="table table-sm text-center align-middle" id="itemTable" style="width: 100%; table-layout: fixed;">
                                                <thead class="table-light">
                                                    <tr>
                                                        <th style="font-size:75%;">Req No.</th>
                                                        <th style="font-size:75%;">Generated By</th>
                                                        <th style="font-size:75%;">Generated <br>Date Time</th>
                                                        <th style="font-size:75%;">Department</th>
                                                        <th style="font-size:75%;">Status</th>
                                                        <th style="font-size:75%;">Accepted By</th>
                                                        <th style="font-size:75%;">Accepted <br>Date Time</th>
                                                        <th style="font-size:75%;">Total <br>Quantity</th>
                                                        <th style="font-size:75%;">Total <br>Vendors</th>
                                                        <th style="font-size:75%;">Total Amount</th>
                                                        <th style="font-size:75%;">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="itemListContainer">
                                                    <tr>
                                                        <td style="font-size:75%; font-weight:bold;">E-1-25</td>
                                                        <td style="font-size:75%;">Sanket Kanawade</td>
                                                        <td style="font-size:75%;">10/04/2025<br>03:10:10</td>
                                                        <td style="font-size:75%;">Engine</td>
                                                        <td style="font-size:75%;">Approved</td>
                                                        <td style="font-size:75%;">Gaurav</td>
                                                        <td style="font-size:75%;">10/04/2025<br>03:10:10</td>
                                                        <td style="font-size:75%;">200</td>
                                                        <td style="font-size:75%;">4</td>
                                                        <td style="font-size:75%; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">INR(200),USD(500),PKR(100),DSB(20)</td>
                                                        <td style="font-size:75%;"><button class="btn btn-outline-primary btn-sm" type="button">View</button></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include './includes/footer.php'; ?>
        </div>
            <!-- main-panel ends -->
        </div>
        <!-- page-body-wrapper ends -->
    </div>
    <?php
    include './includes/dependancy.php';
    ?>

<div id="reqReport" class="rmodel">
    <div class="rmodel-content">
        <h2>Requisition Report</h2>
        <div class="report" id="viewReport"></div>
        <!-- <div style="text-align: center;">
            <button class="btn btn-outline-success btn-sm" onclick="generatePDF()">Download PDF</button>
            <button class="btn btn-outline-danger btn-sm" onclick="closeTrackerModal()">Close</button>
        </div> -->
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.27/jspdf.plugin.autotable.min.js"></script>


<script src="assets/js/requisitionReport.js"></script>
</body>



</html>
<script>
    window.onload = function() {
    getAllDepartment('<?php echo $_SESSION['user_token'] ?>');
};
</script>