<?php
session_start();
include './includes/header.php';
?>

<link rel="stylesheet" href="assets/css/style_for_generated_requisitions.css">

<div class="container-scroller">
    <?php include './includes/profilebasenavbar.php'; ?>
    <div class="container-fluid page-body-wrapper">
        <?php include './includes/sidebarmenu.php'; ?>
        <div class="main-panel">
            <div class="content-wrapper">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="home-tab">
                            <div class="tab-content tab-content-basic" style="padding: 0;">
                                <div class="tab-pane fade show active" id="overview" role="tabpanel"
                                    aria-labelledby="overview">
                                    <div class="container form-container">
                                        <div class="container mt-4">
                                            <h3 class="mb-4">Operational Ship Requisitions</h3>
                                            <div class="row" id="request-cards-container">
                                                <!-- Request cards will be populated here by AJAX -->
                                            </div>
                                            <nav>
                                                <ul class="pagination justify-content-center" id="pagination-links">
                                                    <!-- Pagination links will be populated here -->
                                                </ul>
                                            </nav>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include './includes/footer.php'; ?>
        </div>
    </div>
</div>

<?php include './includes/dependancy.php'; ?>

<!-- Details Modal -->
<div id="detailsModal" class="vmodel" style="display: none;">
    <div class="vmodel-content" style="width: 80%; margin: auto; max-height: 80vh; overflow: auto; scrollbar-width: thin; scrollbar-color: transparent transparent;">
        <h2>Requisition Details</h2>

        <!-- Requisition Header Info -->
        <div id="requisition-details-container" style="margin-bottom: 15px;"></div>

        <!-- Item Table -->
        <table class="table datatable">
            <thead>
                <tr>
                    <th style="display: none;">Item ID</th>
                    <th>Item Name</th>
                    <th>Drawing No</th>
                    <th>Part No</th>
                    <th>Working Qty</th>
                    <th>ROB</th>
                    <th>Requested Qty</th>
                    <th>Accepted Qty</th>
                    <th>Remark</th>
                </tr>
            </thead>
            <tbody id="detailsTableBody">
                <!-- Data will be inserted here dynamically -->
            </tbody>
        </table>

        <div style="text-align: center;">
            <button class="btn btn-outline-success btn-sm" onclick="generateRequisitionPdf()">⬇️ Download PDF</button>
            <button class="btn btn-outline-secondary btn-sm" onclick="closeDetailsModal()">Close</button>
        </div>
    </div>
</div>



<!-- Modal for Update Progress -->
<div id="progressModal" class="vmodel" style="display: none;">
    <div class="vmodel-content" style="width: 30%; margin: auto;">
        <h2>Update Order Progress</h2>

        <form id="updateProgressForm">
            <div class="form-group">
                <div id="deliveryNoteWrapper" style="display: none; text-align: center; margin-top: 20px;">
                    <div style="margin-bottom: 10px;">
                        <span style="font-weight: bold;">Delivery Note:</span>
                        <span id="deliveryNoteComment" style="margin-left: 5px;"></span>
                    </div>
                    <button type="button" class="btn btn-outline-success btn-sm mb-2" id="deliveryNoteLink">Download File</button>
                </div>

                <label for="orderProgress">Select Progress</label>
                <select class="form-control" id="orderProgress" required>
                    <option value="" selected disabled>Select Progress</option>
                    <option value="order_placed">Order Placed</option>
                    <option value="prepare_for_dispatch">Prepare for Dispatch</option>
                    <option value="ready_to_ship">Ready to Ship</option>
                    <option value="intransit">In Transit</option>
                    <option value="delivered">Delivered</option>
                    <option value="closed">Closed</option>
                </select>

                <div id = "closeRemarkWrapper" style="display: none; text-align: center; margin-top: 20px;">
                    <label for="closeRemark"><strong>Close Remark</strong></label>
                    <input type="text" id="closeRemark" name="close_remark" placeholder="Enter Close Remark" class="form-control">
                </div>
            </div>

            <div class="form-group" style="text-align: center;">
                <button type="button" class="btn btn-outline-warning btn-sm" onclick="submitProgressUpdate()">Update Progress</button>
                <button type="button" class="btn btn-outline-secondary btn-sm" onclick="closeProgressModal()">Close</button>
            </div>

            
        </form>
    </div>
</div>


<!-- Modal for track order -->
<div id="trackerModal" class="vmodel" style="display: none;">
    <div class="vmodel-content" style = "width: 50%;margin: auto;">

        <h2>Order Tracker</h2>
        <div class="tracker" id="orderTracker"></div>

        <button class="btn btn-outline-success btn-sm" onclick="closeTrackerModal()">Close</button>
    </div>
</div>

<!-- Delivery Comment Modal -->
<div id="deliveryCommentModal" class="vmodel" style="display: none; position: fixed; z-index: 9999; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.5);">
    <div class="vmodel-content bg-white" style="width: 50%; margin: 100px auto; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0,0,0,0.3);">
        <h4 style="margin-bottom: 15px;">Dispute Note</h4>
        <div id="deliveryCommentContent" style="padding: 10px; font-size: 14px; color: #333;"></div>
        <button class="btn btn-outline-success btn-sm mt-3" onclick="closeDeliveryCommentModal()">Close</button>
    </div>
</div>





<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.29/jspdf.plugin.autotable.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="assets/js/operationalRequisition.js"></script>