// Date : 31-03-2025
// Handle the response from the fetch_rejected_requisition API.

// Function to fetch requisitions data
let totalPages = 0;
function fetchRequisitions(page = 1) {
    var formdata ={
        page: page
    }
    $.ajax({
        url: "./ajax/json_for_fetch_rejected_requisitions_v1_0.php", 
        type: "POST",
        data: formdata,
        dataType: "json",
        success: function (response) {
            console.log("Response:", response); 

            if (response && response.requests) {
                updateRequisitionCards(response.requests);
                totalPages = response.totalPages; 
                updatePagination(totalPages, page);
            } else {
                console.error("Invalid response format:", response);
            }
        },
        error: function (jqXHR, textStatus, errorThrown) {
            console.error("Failed to fetch requisitions. Error:", textStatus, errorThrown);
        }
    });
}

window.changePage = function(page) {
    if (page < 1 || page > totalPages) return;
    fetchRequisitions(page);
};


// Function to update requisition cards
function updateRequisitionCards(requests) {
    const container = document.getElementById('request-cards-container');
    container.innerHTML = '';

    requests.forEach(request => {
        const card = document.createElement('div');
        card.classList.add('col-md-4');
        card.innerHTML = `
            <div class="request-card">
                <h5 class="card-title" style="margin-bottom: -7px; display: flex; justify-content: space-between;">
                    <p><strong>Req no.: ${request.requisition_no}</strong></p>
                    <p style="font-size: 10px;"><strong>Date: ${formatDate(request.requested_date)}</strong></p>
                </h5>
                <p style="margin-bottom: 3px;">Ship Name: ${request.ship_name}</p>
                <p style="margin-bottom: 3px;">Department: ${request.department}</p>
            </div>
        `;
        container.appendChild(card);
    });
}

// Function to update pagination links
function updatePagination(totalPages, currentPage) {
    const pagination = document.getElementById('pagination-links');
    pagination.innerHTML = '';  

    pagination.innerHTML += `<li class="page-item ${currentPage == 1 ? 'disabled' : ''}">
                                <a class="page-link" href="#" onclick="changePage(${currentPage - 1})"><<</a>
                              </li>`;

    for (let page = 1; page <= totalPages; page++) {
        pagination.innerHTML += `<li class="page-item ${page == currentPage ? 'active' : ''}">
                                    <a class="page-link" href="#" onclick="changePage(${page})">${page}</a>
                                  </li>`;
    }

    pagination.innerHTML += `<li class="page-item ${currentPage == totalPages ? 'disabled' : ''}">
                                <a class="page-link" href="#" onclick="changePage(${currentPage + 1})">>></a>
                              </li>`;
}

// Function to format date 
function formatDate(dateString) {
    const date = new Date(dateString);
    const day = String(date.getDate()).padStart(2, '0');
    const month = String(date.getMonth() + 1).padStart(2, '0');
    const year = date.getFullYear();

    return `${day}/${month}/${year}`;  // Format as 'DD/MM/YYYY'
};

fetchRequisitions(1);
