// Date : 01-04-2025
// Handle the response from the fetch_accepted_requisitions API with allocate vendor and po generation.


// Function to fetch requisitions data
let totalPages = 0;
function fetchRequisitions(page = 1) {
    var formdata ={
        page: page
    }
    $.ajax({
        url: "./ajax/json_for_fetch_accepted_requisitions_v1_0.php", 
        type: "POST",
        data: formdata,
        dataType: "json",
        success: function (response) {
            if (response && response.requests) {
                updateRequisitionCards(response.requests);
                totalPages = response.totalPages; 
                updatePagination(totalPages, page);
            } else {
                console.error("Invalid response format:", response);
            }
        },
        error: function () {
            console.error("Failed to fetch requisitions. Please try again later.");
        }
    });
}

// Function to update requisition cards
function updateRequisitionCards(requests) {
    const container = document.getElementById('request-cards-container');
    container.innerHTML = '';

    requests.forEach(request => {
        const card = document.createElement('div');
        card.classList.add('col-md-4');
        card.innerHTML = `
            <div class="request-card bg-white">
                <h5 class="card-title" style="margin-bottom: -7px; display: flex; justify-content: space-between;">
                    <p><strong>Req no.: ${request.requisition_no}</strong></p>
                    <p style="font-size: 10px;"><strong>Date: ${formatDate(request.requested_date)}</strong></p>
                </h5>
                <p style="margin-bottom: 3px;">Ship Name: ${request.ship_name}</p>
                <p style="margin-bottom: 3px;">Department: ${request.department}</p>

                <!-- New button for Update Status of Order -->
                <div style="display: flex; justify-content: center; margin-top: 10px;">
                    <button type="button" class="btn btn-outline-info btn-sm" title="Update Status of Order" onclick="getPoDetails('${request.requisition_no}')">
                        <i class="menu-icon fa fa-arrow-circle-right"></i> Update Status of Order
                    </button>
                </div>
            </div>
        `;
        container.appendChild(card);
    });
}



// Function to update pagination links
function updatePagination(totalPages, currentPage) {
    const pagination = document.getElementById('pagination-links');
    pagination.innerHTML = '';  

    pagination.innerHTML += `<li class="page-item ${currentPage == 1 ? 'disabled' : ''}">
                                <a class="page-link" href="#" onclick="changePage(${currentPage - 1})"><<</a>
                              </li>`;

    for (let page = 1; page <= totalPages; page++) {
        pagination.innerHTML += `<li class="page-item ${page == currentPage ? 'active' : ''}">
                                    <a class="page-link" href="#" onclick="changePage(${page})">${page}</a>
                                  </li>`;
    }

    pagination.innerHTML += `<li class="page-item ${currentPage == totalPages ? 'disabled' : ''}">
                                <a class="page-link" href="#" onclick="changePage(${currentPage + 1})">>></a>
                              </li>`;
}

window.changePage = function(page) {
    if (page < 1 || page > totalPages) return;
    fetchRequisitions(page);
};

// function to format date 
function formatDate(dateString) {
    const date = new Date(dateString);
    const day = String(date.getDate()).padStart(2, '0');
    const month = String(date.getMonth() + 1).padStart(2, '0');
    const year = date.getFullYear();

    return `${day}/${month}/${year}`;  // Format as 'DD/MM/YYYY'
};

fetchRequisitions(1);

// Function to open vendor form
window.openItemForm = function(requisitionNo){
    window.location.href = 'allocate_item_to_vendor.php?requisition_no=' + requisitionNo;
}


 // Fetch the requisition number from the URL
 const urlParams = new URLSearchParams(window.location.search);
 const requisitionNo = urlParams.get('requisition_no');

 // function to fetch requisition header 
 $.ajax({
     url: './ajax/json_for_fetch_accepted_requisitions_v1_0.php',
     type: 'GET',
     data: { requisition_no: requisitionNo },
     success: function(response) {
         const data = JSON.parse(response);
         if (data.status === 'success') {
             const details = data.data;

             // Populate the requisition details dynamically
             $('#requisition-details-container').html(`
                 <form>
                     <div class="row">
                         <div class="col-md-12 d-flex justify-content-between align-items-center"
                             style="border-bottom: 1px solid skyblue; padding-bottom: 5px; margin-bottom: 10px;">
                             <h6 class="mb-0">🚢 Requisition Number : ${details.requisition_no}</h6>
                             <h6 class="mb-0" style="text-decoration: underline;">Date: ${details.creation_date}</h6>
                         </div>

                         <div class="col-md-6 info-row">
                             <div class="info-label">Vessel Name:</div>
                             <div class="info-value">${details.ship_name}</div>
                         </div>

                         <div class="col-md-6 info-row">
                             <div class="info-label">Department Name:</div>
                             <div class="info-value">${details.dept_name}</div>
                         </div>

                         <div class="col-md-6 info-row">
                             <div class="info-label">Equipment Name/Engine Type:</div>
                             <div class="info-value">${details.eq_name}</div>
                         </div>

                         <div class="col-md-6 info-row">
                             <div class="info-label">Model Name/Type:</div>
                             <div class="info-value">${details.model_name}</div>
                         </div>

                         <div class="col-md-6 info-row">
                             <div class="info-label">Maker Name:</div>
                             <div class="info-value">${details.maker_name}</div>
                         </div>

                         <div class="col-md-6 info-row">
                             <div class="info-label">Maker Address:</div>
                             <div class="info-value">${details.maker_address}</div>
                         </div>

                         <div class="col-md-6 info-row">
                             <div class="info-label">Priority Level:</div>
                             <div class="info-value">${details.priority_level}</div>
                         </div>

                         <div class="col-md-6 info-row">
                             <div class="info-label">Category:</div>
                             <div class="info-value">${details.cat_name}</div>
                         </div>
                     </div>
                 </form>
             `);
         } else {
            //  alert(data.message);
         }
     }
 });


 function showWarningModal() {
    document.getElementById('warningModal').style.display = 'flex';
}

function closeWarningModal() {
    document.getElementById('warningModal').style.display = 'none';
}

// tracker details 

const getPoDetails = (reqNo) => {
    $.ajax({
        url: "./ajax/json_for_track_po_v1_0.php",
        type: "POST",
        data: {req_no: reqNo},
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "mode": "1"
        },
        success: function (response) {
                if (response.error_code === 200) {
                    const statusColors = ["bg-yellow", "bg-blue", "bg-orange", "bg-green", "bg-red"];
                    vendors = response.data;
                    document.getElementById("vendorModal").style.display = "flex";
                    const vendorList = document.getElementById("vendorList");
                    vendorList.innerHTML = "";
            
                    vendors.slice(0, 10).forEach(vendor => {
                        const div = document.createElement("div");
                        div.className = `col-md-4 vendor-card ${statusColors[vendor.po_status]} p-3 m-2 rounded`;
                        div.style.minHeight = "120px"; 
                        const name = document.createElement("h5");
                        name.innerText = vendor.ven_name;
                        div.appendChild(name);
            
                        // Track Order button
                        const trackBtn = document.createElement("button");
                        trackBtn.className = "btn btn-outline-success btn-sm me-2";
                        trackBtn.innerText = "Track Order";
                        trackBtn.style.color = "black";
                        trackBtn.onclick = () => tracThisPo(vendor.req_id, vendor.po_id);
            
                        // Update Status button
                        const updateBtn = document.createElement("button");
                        updateBtn.className = "btn btn-outline-success btn-sm";
                        updateBtn.style.color = "black";
                        updateBtn.innerText = "Update Status";
                        updateBtn.onclick = () => updateVendorStatus(vendor.req_id, vendor.po_id); // define this function as needed

                         // Details button
                         const detailsBtn = document.createElement("button");
                         detailsBtn.className = "btn btn-outline-success btn-sm";
                         detailsBtn.style.color = "black";
                         detailsBtn.innerText = "Order Details";
                         detailsBtn.onclick = () => poItemList(vendor.req_id, vendor.po_id); // define this function as needed
            
                        const btnGroup = document.createElement("div");
                        btnGroup.className = "mt-2 d-flex gap-2";
                        btnGroup.appendChild(trackBtn);
                        btnGroup.appendChild(updateBtn);
                        btnGroup.appendChild(detailsBtn);
            
                        div.appendChild(btnGroup);
                        vendorList.appendChild(div);
                    });
            
                } else {
                alert('Error: ' + response.message);
            }
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr.responseText);
            alert("Server error. Please try again.");
        }
    });
}

const tracThisPo = (reqId, poId) => {

    $.ajax({
        url: "./ajax/json_for_track_po_v1_0.php",
        type: "POST",
        data: {req_id: reqId, po_id: poId},
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "mode": "2"
        },
        success: function (response) {
            if (response.error_code === 200) {
                const orderData = response.data[0];
        const steps = [
            { key: "req_date_of_creation", label: "Order Generated" },
            { key: "order_placed", label: `Order Placed (${orderData.ven_name})` },
            { key: "prepare_for_dispatch", label: "Prepare for Dispatch" },
            { key: "ready_to_ship", label: "Ready to Ship" },
            { key: "intransit", label: "In Transit" },
            { key: "delivered", label: "Delivered" }
        ];

        const tracker = document.getElementById("orderTracker");
        tracker.innerHTML = ""; // Clear previous content

        steps.forEach((step, index) => {
            const isCompleted = orderData[step.key] !== null;

            const stepElement = document.createElement("div");
            stepElement.classList.add("step");
            if (isCompleted) stepElement.classList.add("completed");

            stepElement.innerHTML = `
                <div class="circle">${index + 1}</div>
                <div class="text">${step.label} ${isCompleted ? `(${orderData[step.key]})` : ""}</div>
            `;

            tracker.appendChild(stepElement);
        });

        document.getElementById("trackerModal").style.display = "block";

            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr.responseText);
            alert("Server error. Please try again.");
        }
    });

}


const updateVendorStatus = (reqId, poId) => {
    // work on progress 


    $.ajax({
        url: "./ajax/json_for_track_po_v1_0.php",
        type: "POST",
        data: {req_id: reqId, po_id: poId},
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "mode": "5"
        },
        success: function (response) {
            if (response.error_code === 200) {

            const data = response.data;

            const statusMap = {
                order_placed: "Order Placed",
                prepare_for_dispatch: "Prepare for Dispatch",
                ready_to_ship: "Ready to Ship",
                intransit: "Prepare for Intransit"
            };

            const dropdown = document.getElementById("poStatusDropdown");
            dropdown.innerHTML = ""; // Clear previous options

            // Add default "Select Status" option
            const defaultOption = document.createElement("option");
            defaultOption.text = "Select Status";
            defaultOption.disabled = true;
            defaultOption.selected = true;
            dropdown.appendChild(defaultOption);

            let nextStepFound = false;

            for (const key in statusMap) {
                const option = document.createElement("option");
                option.value = key;

                if (data[key] === 1) {
                    option.text = `${statusMap[key]} (Done)`;
                    option.disabled = true;
                } else if (!nextStepFound) {
                    option.text = `${statusMap[key]} (Next)`;
                    nextStepFound = true; // Only the first "0" gets this
                } else {
                    option.text = `${statusMap[key]}`;
                    option.disabled = true;
                }

                dropdown.appendChild(option);
            }

                document.getElementById("po_id_for_status").value = poId;
                document.getElementById("updatePOStatusModal").style.display = "block";
            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr.responseText);
            alert("Server error. Please try again.");
        }
    });

}

const poItemList = (reqId, poId) => {

    // work on progress 


    $.ajax({
        url: "./ajax/json_for_track_po_v1_0.php",
        type: "POST",
        data: {req_id: reqId, po_id: poId},
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "mode": "4"
        },
        success: function (response) {
            if (response.error_code === 200) {
                const data = response.data;

                console.log(data);
                document.getElementById('vendorName').textContent = response.ven_name;
                document.getElementById('poNumber').textContent = response.po_no;
              
                const tbody = document.getElementById('poItemsBody');
                tbody.innerHTML = "";
              
                data.forEach((item, index) => {
                  const row = document.createElement("tr");
                  row.innerHTML = `
                    <td>${index + 1}</td>
                    <td>${item.item_name}</td>
                    <td>${item.item_drawing_no}</td>
                    <td>${item.item_part_no}</td>
                    <td>${item.allocated_qty}</td>
                  `;
                  tbody.appendChild(row);
                });
              
                document.getElementById('poModal').style.display = 'block';

            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr.responseText);
            alert("Server error. Please try again.");
        }
    });

}


const closeTrackerModal = () => {
    document.getElementById("trackerModal").style.display = "none";
}
const closeVendorModal = () => {
    document.getElementById("vendorModal").style.display = "none";
}
function closeModal() {
    document.getElementById('poModal').style.display = 'none';
  }
function closeupdatePOStatusModal() {
    document.getElementById('updatePOStatusModal').style.display = 'none';
  }

const updsateStatus = (status) => {
    poId = document.getElementById("po_id_for_status").value;
    $.ajax({
        url: "./ajax/json_for_track_po_v1_0.php",
        type: "POST",
        data: {status: status, po_id: poId},
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "mode": "6"
        },
        success: function (response) {
            if (response.error_code === 200) {
                const data = response.data;

                console.log(data);
                alert('status Updated');
                document.getElementById("updatePOStatusModal").style.display = "none";

            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr.responseText);
            alert("Server error. Please try again.");
        }
    });


}

  