// Date : 01-04-2025
// Handle the response from the fetch_accepted_requisitions API with allocate vendor and PO generation.
// Handle add new vendor and upload qoatation file from the fetch_vendors API.

// Function to fetch requisitions data
let totalPages = 0;

// Function to fetch requisitions data
function fetchRequisitions(page = 1) {
    var formdata = {
        page: page
    };
    $.ajax({
        url: "./ajax/json_for_fetch_operational_requisitions_v1_0.php",
        type: "POST",
        data: formdata,
        dataType: "json",
        success: function (response) {
            if (response && response.requests) {
                updateRequisitionCards(response.requests);
                totalPages = response.totalPages;
                updatePagination(totalPages, page);  
            } else {
                console.error("Invalid response format:", response);
            }
        },
        error: function () {
            console.error("Failed to fetch requisitions. Please try again later.");
        }
    });
}


// Function to update requisition cards
function updateRequisitionCards(requests) {
    const container = document.getElementById('request-cards-container');
    container.innerHTML = ''; 

    requests.forEach(request => {
        const card = document.createElement('div');
        card.classList.add('col-md-4');
        card.style.padding = '10px';
        card.innerHTML = `
            <div class="request-card bg-white" style="position: relative; border: 1px solid #ccc; border-radius: 10px; overflow: hidden;">
                ${request.closed ? `
                    <!-- Green Checkmark Badge -->
                    <span style="
                        position: absolute;
                        top: 40px;
                        right: 15px;
                        background-color: rgba(76, 175, 80, 0.1); /* light green */
                        color: green;
                        padding: 6px 10px;
                        border-radius: 50%;
                        font-size: 16px;
                        font-weight: bold;
                        box-shadow: 0 1px 4px rgba(0,0,0,0.1);
                    ">
                        <i class="fa fa-cart-arrow-down"></i> 
                    </span>
                ` : ''}
                ${request.delivery_comment ? `
                <!-- Dispute Sign with Tooltip -->
                <span class="dispute-icon" style="position: absolute; top: 40px; left: 237px; cursor: pointer;"  title="View dispute note"
                    onclick="showDeliveryCommentModal('${escapeSingleQuotes(request.delivery_comment)}')">
                    <i class="fa fa-exclamation"></i>
                </span>
                ` : ''}

                <h5 class="card-title" style="margin-bottom: -7px; display: flex; justify-content: space-between;">
                    <p><strong>Req no.: ${request.requisition_no}</strong></p>
                    <p style="font-size: 10px;"><strong>Date: ${formatDate(request.requested_date)}</strong></p>
                </h5>
                <p style="margin-bottom: 3px;">Ship Name: ${request.ship_name}</p>
                <p style="margin-bottom: 3px;">Department: ${request.department}</p>

                <div style="display: flex; justify-content: center; margin-top: 10px; gap: 3px;">
                    <button type="button" class="btn btn-outline-info btn-sm flex-fill" style="font-size: 70%;" title="Show Details" onclick="openDetailsModal(${request.req_id});">
                        <i class="menu-icon fa fa-info-circle" style="font-size:13px;"></i> Details
                    </button>

                    ${request.closed ? '' : `
                    <button type="button" class="btn btn-outline-primary btn-sm" style="font-size: 70%;" title="Update Progress" onclick="openProgressModal(${request.req_id});">
                        <i class="menu-icon fa fa-arrow-circle-right" style="font-size:13px;"></i> Update
                    </button>`}

                    <button type="button" class="btn btn-outline-warning btn-sm flex-fill" style="font-size: 70%;" title="Track Requisition" onclick="opentrackerModal(${request.req_id});">
                        <i class="menu-icon fa fa-bullseye" style="font-size:13px;"></i> Track
                    </button>
                </div>
            </div>
        `;


        container.appendChild(card);
    });
}

function showDeliveryCommentModal(comment) {
    document.getElementById('deliveryCommentContent').innerText = comment;
    document.getElementById('deliveryCommentModal').style.display = 'block';
}

function closeDeliveryCommentModal() {
    document.getElementById('deliveryCommentModal').style.display = 'none';
}

function escapeSingleQuotes(text) {
    return text.replace(/'/g, "\\'");
}


// Function to update pagination links
function updatePagination(totalPages, currentPage) {
    const pagination = document.getElementById('pagination-links');
    pagination.innerHTML = '';  

    pagination.innerHTML += `<li class="page-item ${currentPage == 1 ? 'disabled' : ''}">
                                <a class="page-link" href="#" onclick="changePage(${currentPage - 1})"><<</a>
                              </li>`;

    for (let page = 1; page <= totalPages; page++) {
        pagination.innerHTML += `<li class="page-item ${page == currentPage ? 'active' : ''}">
                                    <a class="page-link" href="#" onclick="changePage(${page})">${page}</a>
                                  </li>`;
    }

    pagination.innerHTML += `<li class="page-item ${currentPage == totalPages ? 'disabled' : ''}">
                                <a class="page-link" href="#" onclick="changePage(${currentPage + 1})">>></a>
                              </li>`;
}


// Change page function
window.changePage = function (page) {
    if (page < 1 || page > totalPages) return;  
    fetchRequisitions(page);
};

// Function to format date 
function formatDate(dateString) {
    const date = new Date(dateString);
    const day = String(date.getDate()).padStart(2, '0');
    const month = String(date.getMonth() + 1).padStart(2, '0');
    const year = date.getFullYear();

    return `${day}/${month}/${year}`; 
};

fetchRequisitions(1);


// function for show details 
let currentRequisitionDetails = null;
let currentRequisitionItems = [];

function openDetailsModal(requisitionId) {
    $.ajax({
        url: './ajax/json_for_requisition_details_v1_0.php',
        type: 'POST',
        data: { req_id: requisitionId },
        dataType: 'json',
        success: function(response) {
            console.log('Response:', response);

            if (
                response &&
                response.error_code === 200 &&
                response.data &&
                response.data.header &&
                Array.isArray(response.data.items)
            ) {
                const details = response.data.header;
                const items = response.data.items;

                currentRequisitionDetails = details;
                currentRequisitionItems = items;
                window.reportMeta = response.data.report_meta || {};


                // Rendering requisition details
                $('#requisition-details-container').html(`
                    <div style="padding: 15px; border: 1px solid #ccc; border-radius: 6px; background-color: #f9f9f9; margin-bottom: 20px;">
                        <div style="display: flex; justify-content: space-between; border-bottom: 2px solid skyblue; padding-bottom: 5px; margin-bottom: 15px; background-color: #f1f8ff;">
                            <h5 style="margin: 0; color: #0056b3;">🚢 Requisition Number: <strong>${details.req_no || '-'}</strong></h5>
                            <h6 style="margin: 0; text-decoration: underline; color: #0056b3;">Date: ${details.creation_date || '-'}</h6>
                        </div>

                        <div class="row" style="display: flex; flex-wrap: wrap; gap: 10px; font-size:15px;">
                            ${renderInfoRow("Vessel Name", details.ship_name || "-", "Department Name", details.dept_name || "-")}
                            ${renderInfoRow("Equipment Name / Engine Type", details.req_eq_name_engine_type || "-", "Model Name / Type", details.req_model_type || "-")}
                            ${renderInfoRow("Maker Details", details.req_maker_name || "-", "Serial No", details.req_serial_no || "-")}
                            ${renderInfoRow("Priority Level", details.priority_level || "-", "Category", details.req_eq_name_engine_type || "-")}
                        </div>
                    </div>
                `);

                // Rendering items in the table
                const tbody = document.getElementById("detailsTableBody");
                tbody.innerHTML = "";

                if (items.length > 0) {
                    items.forEach(item => {
                        const row = document.createElement("tr");
                        row.innerHTML = `
                            <td style="display: none;">${item.item_id || "-"}</td>
                            <td>${item.item_name || "-"}</td>
                            <td>${item.item_drawing_no || "-"}</td>
                            <td>${item.item_part_no || "-"}</td>
                            <td>${item.working_qty || "-"}</td>
                            <td>${item.rob || "-"}</td>
                            <td>${item.req_qty || "-"}</td>
                            <td>${item.accepted_qty || "-"}</td>
                            <td>${item.remark || "-"}</td>
                        `;
                        tbody.appendChild(row);
                    });
                } else {
                    const row = document.createElement("tr");
                    row.innerHTML = `<td colspan="8" class="text-center">No items available</td>`;
                    tbody.appendChild(row);
                }

                document.getElementById("detailsModal").style.display = "block";
            } else {
                alert("No details found or invalid response.");
                console.error("Response Error:", response);
            }
        },
        error: function(xhr) {
            console.error("Error:", xhr.responseText);
            alert("Error fetching requisition details.");
        }
    });
}


// Helper to render two data in one row with four columns
function renderInfoRow(label1, value1, label2, value2) {
    return `
        <div class="info-row" style="display: flex; justify-content: space-between; width: 100%; margin-bottom: 10px;">
            <div style="width: 45%; display: flex; justify-content: space-between;">
                <strong>${label1}:</strong>
                <span>${value1 || '-'}</span>
            </div>
            <div style="width: 45%; display: flex; justify-content: space-between;">
                <strong>${label2}:</strong>
                <span>${value2 || '-'}</span>
            </div>
        </div>
    `;
}


async function toDataURL(url) {
    const response = await fetch(url);
    const blob = await response.blob();
    return new Promise((resolve) => {
        const reader = new FileReader();
        reader.onloadend = () => resolve(reader.result);
        reader.readAsDataURL(blob);
    });
}

async function generateRequisitionPdf() {
    const { jsPDF } = window.jspdf;
    const doc = new jsPDF();
    const pageWidth = doc.internal.pageSize.getWidth();
    const margin = 10;

    const logoUrl = "assets/images/logo/ksm_logo.jpg";
    const logoX = margin;
    const logoY = 10;
    const logoWidth = 20;
    const logoHeight = 15;
    const imageData = await toDataURL(logoUrl);
    doc.addImage(imageData, 'JPEG', logoX, logoY, logoWidth, logoHeight);

    const meta = {
        report_name: window.reportMeta?.report_name,
        report_code: window.reportMeta?.report_code,
        revision_number: window.reportMeta?.revision_number,
        created_date: window.reportMeta?.created_date,
        approved_by: window.reportMeta?.approved_by,
        prepared_by: window.reportMeta?.prepared_by
    };

    // Header Text
    doc.setFont("helvetica", "bold");
    doc.setFontSize(10);

    const centerTitleX = (pageWidth / 2) - (doc.getTextWidth(meta.report_name) / 2);
    const centerCodeX = (pageWidth / 2) - (doc.getTextWidth(meta.report_code) / 2);
    doc.text(meta.report_name, centerTitleX, logoY + 5);
    doc.text(meta.report_code, centerCodeX, logoY + 9);

    const revText = `REV.NO. ${meta.revision_number}`;
    const dateText = `DATE: ${meta.created_date}`;

    const revRightX = pageWidth - margin - doc.getTextWidth(revText);
    const dateRightX = pageWidth - margin - doc.getTextWidth(dateText);

    doc.text(revText, revRightX, logoY + 5);
    doc.text(dateText, dateRightX, logoY + 9);

    // Line below header
    doc.setLineWidth(0.5);
    doc.line(margin, logoY + logoHeight + 4, pageWidth - margin, logoY + logoHeight + 4);

    // Requisition Info
    const headers = [
        [`Requisition Number: ${currentRequisitionDetails.req_no || "-"}`, `Date: ${currentRequisitionDetails.creation_date || "-"}`],
        [`Vessel Name: ${currentRequisitionDetails.ship_name || "-"}`, `Department Name: ${currentRequisitionDetails.dept_name || "-"}`],
        [`Equipment Name / Engine Type: ${currentRequisitionDetails.req_eq_name_engine_type || "-"}`, `Model Name / Type: ${currentRequisitionDetails.req_model_type || "-"}`],
        [`Maker Details: ${currentRequisitionDetails.req_maker_name || "-"}`, `Serial Number: ${currentRequisitionDetails.req_serial_no || "-"}`],
        [`Priority Level: ${currentRequisitionDetails.priority_level || "Normal"}`, `Category: ${currentRequisitionDetails.req_eq_name_engine_type || "-"}`],
    ];

    let posY = logoY + logoHeight + 13;
    const leftX = margin;
    const rightX = pageWidth / 2 + 5;
    const lineHeight = 8;

    doc.setFont("helvetica", "bold");
    doc.setFontSize(10);

    headers.forEach(([left, right]) => {
        const leftWrapped = doc.splitTextToSize(left, pageWidth / 2 - 10);
        const rightWrapped = doc.splitTextToSize(right, pageWidth / 2 - 15);
        const maxLines = Math.max(leftWrapped.length, rightWrapped.length);

        for (let i = 0; i < maxLines; i++) {
            if (leftWrapped[i]) doc.text(leftWrapped[i], leftX, posY);
            if (rightWrapped[i]) doc.text(rightWrapped[i], rightX, posY);
            posY += lineHeight;
        }
    });

    posY += 5;

    // Render Table with Items
    const grouped = groupItemsBySystem(currentRequisitionItems);
    for (const [sectionTitle, items] of Object.entries(grouped)) {
        const itemHeaders = [
            "Pos.", "Name of Part(s)", "Drawing No.", "Part No.",
            "Working Qty", "ROB", "Required Qty", "Remarks"
        ];

        const body = items.map((item, index) => [
            String(index + 1),
            item.item_name || "-",
            item.item_drawing_no || "-",
            item.item_part_no || "-",
            item.working_qty || "-",
            item.rob || "-",
            item.req_qty || "-",
            item.remark || "-"
        ]);

        doc.setFontSize(10);
        doc.setFont("helvetica", "bold");
        doc.setTextColor(255, 0, 0);
        doc.text(`REMARK: ${String(currentRequisitionDetails.req_remark || "").toUpperCase()}`, margin, posY);
        doc.setTextColor(0, 0, 0);
        posY += 6;

        doc.autoTable({
            head: [itemHeaders],
            body: body,
            theme: 'grid',
            styles: { fontSize: 8, cellPadding: 2 },
            headStyles: {
                fillColor: [200, 200, 200],
                textColor: 0,
                halign: 'center',
                fontStyle: 'bold'
            },
            startY: posY,
            margin: { left: margin, right: margin },
            didDrawPage: function (data) {
                // Footer
                const footerY = doc.internal.pageSize.getHeight() - 15;
                const pageNumber = doc.internal.getCurrentPageInfo().pageNumber;

                doc.setFontSize(9);
                doc.text("SHIP", margin, footerY);

                const centerX = pageWidth / 2;
                doc.text(`Approved by: ${meta.approved_by}`, centerX, footerY, { align: "center" });

                const rightXy = pageWidth - margin - 5;
                doc.text(`Issued by ${meta.prepared_by} /${pageNumber}`, rightXy, footerY, { align: "right" });
            }
        });

        posY = doc.lastAutoTable.finalY + 15;
    }

    doc.setFont("helvetica", "normal");
    doc.setFontSize(10);
    doc.text("Chief Engineer:", margin, posY);
    doc.text("Master:", pageWidth - 60, posY);

    const fileName = `Requisition_${String(currentRequisitionDetails.req_no || 'Details')}.pdf`;
    doc.save(fileName);
}


// function for items grouping
function groupItemsBySystem(items) {
    const grouped = {};
    items.forEach(item => {
        const section = item.system || "General";
        if (!grouped[section]) grouped[section] = [];
        grouped[section].push(item);
    });
    return grouped;
}

// script to close details modal
function closeDetailsModal() {
    document.getElementById("detailsModal").style.display = "none";
}

// Function to open progress modal
const progressOrder = [
    'order_placed',
    'prepare_for_dispatch',
    'ready_to_ship',
    'intransit',
    'delivered',
    'closed'
];

function openProgressModal(requisitionId) {
    window.currentRequisitionId = requisitionId;

    $.ajax({
        url: './ajax/json_for_tracker_v1_0.php',
        type: 'POST',
        data: { req_id: requisitionId },
        dataType: 'json',
        success: function (response) {
            if (response.error_code === 200) {
                const data = response.data[0];
                let currentStepIndex = -1;

                progressOrder.forEach((step, index) => {
                    if (data[step]) currentStepIndex = index;
                });

                const select = document.getElementById('orderProgress');
                [...select.options].forEach((option, index) => {
                    option.disabled = index <= currentStepIndex;
                });

                
                if (data.delivered) {
                    showDeliveryNoteInProgressModal(data);
                } else {
                    document.getElementById('deliveryNoteWrapper').style.display = 'none';
                    document.getElementById('closeRemarkWrapper').style.display = 'none';
                }


                document.getElementById('progressModal').style.display = 'flex';
            } else {
                alert('Unable to fetch progress data.');
            }
        },
        error: function () {
            alert('Server error while fetching progress.');
        }
    });
}


// Show the delivery note in progress modal if delivered
function showDeliveryNoteInProgressModal(orderData) {
    const progressModal = document.getElementById('progressModal');
    const deliveryNoteWrapper = document.getElementById('deliveryNoteWrapper');
    const closeRemarkWrapper = document.getElementById('closeRemarkWrapper');
    const deliveryNoteComment = document.getElementById('deliveryNoteComment');
    const deliveryNoteLink = document.getElementById('deliveryNoteLink');

    if (orderData.delivery_file) {
        deliveryNoteComment.textContent = orderData.delivery_note || "Delivery Note Available";

        deliveryNoteLink.onclick = function () {
            openDeliveryModal(orderData.delivery_file);
        };

        deliveryNoteWrapper.style.display = 'block';
        closeRemarkWrapper.style.display = 'block';
    } else {
        deliveryNoteWrapper.style.display = 'none';
        closeRemarkWrapper.style.display = 'none';
    }

    progressModal.style.display = 'flex';
}



// Function to submit progress update
function submitProgressUpdate() {
    const progress = document.getElementById('orderProgress').value;
    const requisitionId = window.currentRequisitionId;
    const closeRemark = (progress === 'closed') ? document.getElementById('closeRemark').value : '';

    $.ajax({
        url: './ajax/json_for_tracker_v1_0.php',
        type: 'POST',
        data: {
            req_id: requisitionId,
            action: 'update_progress',
            progress: progress,
            close_remark: closeRemark
        },
        dataType: 'json',
        success: function (response) {
            if (response.error_code === 200) {
                alert("Progress updated successfully!");
                closeProgressModal();
                location.reload();
            } else {
                alert("Error: " + response.message);
            }
        },
        error: function (xhr) {
            console.error("AJAX Error:", xhr.responseText);
            alert("Server error. Please try again.");
        }
    });
}


function closeProgressModal() {
    document.getElementById('progressModal').style.display = 'none';
}

// Function to open tracker Modal
function opentrackerModal(requisitionId) {
    window.currentRequisitionId = requisitionId;
    document.getElementById('trackerModal').style.display = '';
    tracker(requisitionId);
}

const tracker = (requisitionId) => {
    $.ajax({
        url: "./ajax/json_for_tracker_v1_0.php",
        type: "POST",
        data: { req_id: requisitionId },
        dataType: "json",
        success: function (response) {
            if (response.error_code === 200) {
                const orderData = response.data[0];

                const steps = [
                    { key: "requested", label: "Order Requested" },
                    { key: "order_placed", label: "Order Placed" },
                    { key: "prepare_for_dispatch", label: "Prepare for Dispatch" },
                    { key: "ready_to_ship", label: "Ready to Ship" },
                    { key: "intransit", label: "In Transit" },
                    { key: "delivered", label: "Delivered" },
                    { key: "closed", label: "Closed" }
                ];

                const tracker = document.getElementById("orderTracker");
                tracker.innerHTML = "";

                steps.forEach((step, index) => {
                const isCompleted = orderData[step.key] !== null;
                let label = step.label;
                let labelHTML = label;
                let circleContent = isCompleted ? "✓" : index + 1;

                if (step.key === "delivered" && orderData.delivery_comment) {
                    labelHTML = `<span style="color:red;">Delivered (Disputed)</span>`;
                    circleContent = "✗"; // Disputed delivery
                }

                const stepElement = document.createElement("div");
                stepElement.classList.add("step");
                if (isCompleted) stepElement.classList.add("completed");
                if (index === steps.length - 1) stepElement.classList.add("last");

                stepElement.innerHTML = `
                    <div class="circle">${circleContent}</div>
                    <div class="step-content">
                        <div class="text">${labelHTML}</div>
                        <div class="date">${isCompleted ? formatDate(orderData[step.key]) : ""}</div>
                    </div>
                `;

                tracker.appendChild(stepElement);
            });


                document.getElementById("trackerModal").style.display = "block";
            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr.responseText);
            alert("Server error. Please try again.");
        }
    });
};

// Trigger file download directly
function openDeliveryModal(fileName) {
    const downloadLink = document.createElement('a');
   // downloadLink.href = `http://localhost/E-SHIP/e_ship_ksm/uploads/${fileName}`;
   downloadLink.href = `https://kaizen.miscos.in/v1_1/e_ship_ksm/uploads/${fileName}`;
    downloadLink.download = fileName;  // This triggers the file download
    downloadLink.click();
}



function closeTrackerModal() {
    document.getElementById('trackerModal').style.display = 'none';
}