// Date : 25-03-2025
// script to handle index page.

var map = L.map('map').setView([20.5937, 78.9629], 5);
L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
    attribution: 'Ship Office Locations'
}).addTo(map);

var ships = [{
        name: "EAST AYUTTHAYA",
        lat: 18.9200,
        lon: 72.8200
    }, // Arabian Sea (West of Mumbai)
    {
        name: "SOUTH ANDAMAN",
        lat: 13.1000,
        lon: 81.0000
    }, // Bay of Bengal (East of Chennai)
    {
        name: "NORTH MANDALAY",
        lat: 8.5000,
        lon: 76.5000
    }, // Indian Ocean (South of Kerala)
    {
        name: "SOUTH SONGKHALA",
        lat: 11.6800,
        lon: 92.7600
    }, // Andaman Sea (Near Andaman & Nicobar Islands)
    {
        name: "CENTRAL AYUTTHAYA",
        lat: 9.1500,
        lon: 79.5000
    } // Gulf of Mannar (Between India and Sri Lanka)
];



function filterShipsInSea(ships) {
    return ships.filter(function(ship) {
        return ship.lat >= 6.0 && ship.lat <= 30.0 &&
            ship.lon >= 60.0 && ship.lon <= 100.0;
    });
}

var shipsInSea = filterShipsInSea(ships);

var shipMarkers = [];

shipsInSea.forEach(function(ship) {
    var shipMarker = L.marker([ship.lat, ship.lon]).addTo(map);
    shipMarker.bindPopup("<b>" + ship.name + "</b><br>Location: (" + ship.lat.toFixed(4) + ", " + ship.lon
        .toFixed(4) + ")");
    shipMarkers.push({
        marker: shipMarker,
        name: ship.name,
        lat: ship.lat,
        lon: ship.lon
    });
});

function fetchShipCoordinates(ship) {
    return {
        lat: ship.lat + (Math.random() - 0.5) * 0.02,
        lon: ship.lon + (Math.random() - 0.5) * 0.02
    };
}

function updateShipPositions() {
    shipMarkers.forEach(function(ship) {
        var coords = fetchShipCoordinates(ship);

        ship.marker.setLatLng([coords.lat, coords.lon]);

        ship.lat = coords.lat;
        ship.lon = coords.lon;

        ship.marker.setPopupContent("<b>" + ship.name + "</b><br>Location: (" + coords.lat.toFixed(4) + ", " +
            coords.lon.toFixed(4) + ")");
    });
}

// Update the ships' positions every 5 seconds
setInterval(updateShipPositions, 5000); // Update every 5 seconds



// auto scroll 

function duplicateList() {
    let list = document.getElementById("scroll-list");
    let items = list.innerHTML; // Get current list items
    list.innerHTML += items; // Duplicate list items
}

window.onload = duplicateList;