// Date : 27-03-2025
// Handle the response from the add_subcategory API.

$(document).ready(function() {
    // Fetch departments
    $.ajax({
        url: './ajax/json_for_add_sub_category_v1_0.php',
        type: 'GET',
        data: { action: 'fetch_departments' },
        success: function(response) {
            var departments = JSON.parse(response);
            var departmentSelect = $('#department_select');
            departmentSelect.empty();
            departmentSelect.append('<option value="">Select Department</option>');

            departments.forEach(function(department) {
                departmentSelect.append('<option value="' + department.dept_id + '">' + department.dept_name + '</option>');
            });

            loadSubCategories();
        },
        error: function(xhr, status, error) {
            console.error("Error fetching departments: " + error);
            alert("An error occurred while fetching departments.");
        }
    });

    // Fetch categories based on selected department
    $("#department_select").change(function() {
        var deptId = $(this).val();

        $.ajax({
            url: './ajax/json_for_add_sub_category_v1_0.php',
            type: 'GET',
            data: { action: 'fetch_categories', dept_id: deptId },
            success: function(response) {
                var categories = JSON.parse(response);
                var categorySelect = $('#category_select');
                categorySelect.empty();
                categorySelect.append('<option value="">Select Category</option>');

                categories.forEach(function(category) {
                    categorySelect.append('<option value="' + category.cat_id + '">' + category.cat_name + '</option>');
                });
            },
            error: function(xhr, status, error) {
                console.error("Error fetching categories: " + error);
                alert("An error occurred while fetching categories.");
            }
        });
    });

    // Handle sub-category form submission
    $("#addSubCategoryForm").submit(function(event) {
        event.preventDefault();

        var deptId = $("#department_select").val();
        var catId = $("#category_select").val();
        var subCategoryName = $("#sub_category_name").val();

        if (deptId === "" || catId === "" || subCategoryName === "") {
            alert("Please select a department, category, and enter a sub-category name.");
            return;
        }

        $.ajax({
            url: "./ajax/json_for_add_sub_category_v1_0.php",
            type: "POST",
            data: { dept_id: deptId, cat_id: catId, sub_cat_name: subCategoryName },
            success: function(response) {
                var result = JSON.parse(response);

                if (result.success) {
                    $("#sub_category_name").val(""); 
                    loadSubCategories(); 
                } else {
                    alert(result.message);
                }
            },
            error: function(xhr, status, error) {
                alert("An error occurred: " + error);
            }
        });
    });

    // Function to load sub-categories
    function loadSubCategories(deptId = '', catId = '', searchQuery = '', page = 1) {
        $.ajax({
            url: "./ajax/json_for_add_sub_category_v1_0.php",
            type: "GET",
            data: { dept_id: deptId, cat_id: catId, search: searchQuery, page: page },
            success: function(response) {
                var result = JSON.parse(response);

                if (result.success) {
                    var subCategories = result.data;
                    var subCategoriesHtml = '';

                    subCategories.forEach(function(subCategory) {
                        subCategoriesHtml += `
                            <tr>
                                <td>${subCategory.sub_cat_name}</td>
                                <td>${subCategory.cat_name}</td>
                                <td>${subCategory.dept_name}</td>
                                <td>${subCategory.sub_cat_status === 'Y' ? 'Special' : 'Normal'}</td>
                            </tr>
                        `;
                    });

                    $("#subCategoriesList").html(subCategoriesHtml);
                    updatePagination(result.total_pages, result.current_page);
                } else {
                    alert(result.message);
                }
            },
            error: function(xhr, status, error) {
                alert("An error occurred while fetching sub-categories: " + error);
            }
        });
    }

    // Update pagination links
    function updatePagination(totalPages, currentPage) {
        const pagination = document.getElementById('pagination-links');
        pagination.innerHTML = '';

        if (totalPages <= 1) return;

        pagination.innerHTML += `
            <li class="page-item ${currentPage === 1 ? 'disabled' : ''}">
                <a class="page-link" href="#" onclick="changePage(${currentPage - 1})"><<</a>
            </li>
        `;

        for (let page = 1; page <= totalPages; page++) {
            pagination.innerHTML += `
                <li class="page-item ${page === currentPage ? 'active' : ''}">
                    <a class="page-link" href="#" onclick="changePage(${page})">${page}</a>
                </li>
            `;
        }

        pagination.innerHTML += `
            <li class="page-item ${currentPage === totalPages ? 'disabled' : ''}">
                <a class="page-link" href="#" onclick="changePage(${currentPage + 1})">>></a>
            </li>
        `;
    }

    // Handle page change
    window.changePage = function(page) {
        var totalPages = parseInt($('#pagination-links').data('total-pages'));
        if (page < 1 || page > totalPages) return;

        var deptId = $("#department_select").val();
        var catId = $("#category_select").val();
        var searchQuery = $("#searchSubCategory").val();
        loadSubCategories(deptId, catId, searchQuery, page);
    };

    // Handle search bar input for sub-categories
    $("#searchSubCategory").on('input', function() {
        var deptId = $("#department_select").val();
        var catId = $("#category_select").val();
        var searchQuery = $(this).val();
        loadSubCategories(deptId, catId, searchQuery, 1);
    });
});
