// Date : 27-03-2025
// Handle the response from the add_department API.

$(document).ready(function() {
    var currentPage = 1; 
    var totalPages = 1;  

    // function to show department with pagination 
    function loadDepartments(searchQuery = '', page = 1) {
        $.ajax({
            url: "./ajax/json_for_add_department_v1_0.php", 
            type: "GET",
            data: { search: searchQuery, page: page },
            success: function(response) {
                var result = JSON.parse(response);
                if (result.success) {
                    var departments = result.data;
                    var departmentsHtml = '';

                    departments.forEach(function(department) {
                        departmentsHtml += `
                            <tr>
                                <td>${department.dept_no}</td>
                                <td>${department.dept_name}</td>
                                <td>${department.dept_status == 1 ? 'Active' : 'Inactive'}</td>
                            </tr>
                        `;
                    });

                    // Insert the rows into the table body
                    $("#departmentsList").html(departmentsHtml);
                    totalPages = result.total_pages;
                    currentPage = result.current_page;

                    // Update pagination after search or page change
                    updatePagination(totalPages, currentPage);
                } else {
                    alert(result.message);
                }
            },
            error: function(xhr, status, error) {
                alert("An error occurred while fetching departments: " + error);
            }
        });
    }

    // Update pagination links
    function updatePagination(totalPages, currentPage) {
        const pagination = document.getElementById('pagination-links');
        pagination.innerHTML = ''; 

        if (totalPages < 1) return;

        pagination.innerHTML += `<li class="page-item ${currentPage == 1 ? 'disabled' : ''}">
                                    <a class="page-link" href="#" onclick="changePage(${currentPage - 1})"><<</a>
                                  </li>`;

        for (let page = 1; page <= totalPages; page++) {
            pagination.innerHTML += `<li class="page-item ${page == currentPage ? 'active' : ''}">
                                        <a class="page-link" href="#" onclick="changePage(${page})">${page}</a>
                                      </li>`;
        }

        pagination.innerHTML += `<li class="page-item ${currentPage == totalPages ? 'disabled' : ''}">
                                    <a class="page-link" href="#" onclick="changePage(${currentPage + 1})">>></a>
                                  </li>`;
    }

    // Function to handle page change
    window.changePage = function(page) {
        if (page < 1 || page > totalPages) return;  // Ensure page is within valid range
        loadDepartments($("#searchDepartment").val(), page);  // Reload departments with new page
    };
    loadDepartments();

    // Handle search bar input
    $("#searchDepartment").on('input', function() {
        var searchQuery = $(this).val();
        loadDepartments(searchQuery, 1); 
    });

    // Handle Add Department form submission
    $("#addDepartmentForm").submit(function(event) {
        event.preventDefault();

        var departmentName = $("#department_name").val();

        if (departmentName === "") {
            alert("Please enter a department name.");
            return;
        }

        // Perform the Ajax request to add the department
        $.ajax({
            url: "./ajax/json_for_add_department_v1_0.php",
            type: "POST",
            data: { department_name: departmentName },
            success: function(response) {
                var result = JSON.parse(response);

                if (result.success) {
                    alert(result.message);
                    $("#department_name").val(""); 
                    loadDepartments($("#searchDepartment").val(), 1); 
                } else {
                    alert(result.message);
                }
            },
            error: function(xhr, status, error) {
                alert("An error occurred: " + error);
            }
        });
    });
});
