$(document).ready(function() {
    // Fetch departments
    $.ajax({
        url: './ajax/json_for_add_category_v1_0.php',
        type: 'GET',
        data: { action: 'fetch_departments' },
        success: function(response) {
            var departments = JSON.parse(response);
            var departmentSelect = $('#department_select');
            departmentSelect.empty();
            departmentSelect.append('<option value="">Select Department</option>');

            departments.forEach(function(department) {
                departmentSelect.append('<option value="' + department.dept_id + '">' + department.dept_name + '</option>');
            });

            loadCategories();
        },
        error: function(xhr, status, error) {
            console.error("Error fetching departments: " + error);
            alert("An error occurred while fetching departments.");
        }
    });

    // Add category to the database
    $("#addCategoryForm").submit(function(event) {
        event.preventDefault();

        var deptId = $("#department_select").val();
        var categoryName = $("#category_name").val();

        if (deptId === "" || categoryName === "") {
            alert("Please select a department and enter a category name.");
            return;
        }

        $.ajax({
            
            url: "./ajax/json_for_add_category_v1_0.php",
            type: "POST",
            data: { dept_id: deptId, cat_name: categoryName },
            success: function(response) {
                var result = JSON.parse(response);

                if (result.success_code == 200) {
                    alert(result.message);  // Show success message
                    $("#category_name").val("");  // Clear category name field
                    loadCategories();  // Reload the categories after adding a new one
                } else {
                    alert(result.message);  // Show error message
                }
            },
            error: function(xhr, status, error) {
                alert("An error occurred: " + error);
            }
        });
    });

    // Function to load categories
    function loadCategories(deptId = '', searchQuery = '', page = 1) {
        $.ajax({
            url: "./ajax/json_for_add_category_v1_0.php", 
            type: "GET",
            data: { dept_id: deptId, search: searchQuery, page: page },
            success: function(response) {
                var result = JSON.parse(response);
                if (result.success_code == 200) {
                    var categories = result.data;
                    var categoriesHtml = '';

                    categories.forEach(function(category) {
                        categoriesHtml += `
                            <tr>
                                <td>${category.cat_name}</td>
                                <td>${category.dept_name}</td>
                                <td>${category.cat_status == 1 ? 'Active' : 'Inactive'}</td>
                            </tr>
                        `;
                    });

                    $("#categoriesList").html(categoriesHtml);
                    updatePagination(result.total_pages, result.current_page);
                } else {
                    alert(result.message);
                }
            },
            error: function(xhr, status, error) {
                alert("An error occurred while fetching categories: " + error);
            }
        });
    }

    // Function to update pagination links
    function updatePagination(totalPages, currentPage) {
        const pagination = document.getElementById('pagination-links');
        pagination.innerHTML = ''; 

        if (totalPages <= 1) return;

        pagination.innerHTML += `
            <li class="page-item ${currentPage === 1 ? 'disabled' : ''}">
                <a class="page-link" href="#" onclick="changePage(${currentPage - 1})"><<</a>
            </li>
        `;

        for (let page = 1; page <= totalPages; page++) {
            pagination.innerHTML += `
                <li class="page-item ${page === currentPage ? 'active' : ''}">
                    <a class="page-link" href="#" onclick="changePage(${page})">${page}</a>
                </li>
            `;
        }

        pagination.innerHTML += `
            <li class="page-item ${currentPage === totalPages ? 'disabled' : ''}">
                <a class="page-link" href="#" onclick="changePage(${currentPage + 1})">>></a>
            </li>
        `;
    }

    // Handle page change
    window.changePage = function(page) {
        var totalPages = parseInt($('#pagination-links').data('total-pages')); 
        if (page < 1 || page > totalPages) return; 

        var deptId = $("#department_select").val();
        var searchQuery = $("#searchCategory").val();
        loadCategories(deptId, searchQuery, page);
    };

    // Handle department change
    $("#department_select").change(function() {
        var deptId = $(this).val();
        loadCategories(deptId, $("#searchCategory").val(), 1);
    });

    // Handle search bar input for categories
    $("#searchCategory").on('input', function() {
        var deptId = $("#department_select").val();
        var searchQuery = $(this).val();
        loadCategories(deptId, searchQuery, 1);
    });
});
