<?php
session_start();
require_once './includes/header.php';

$requisition_no = isset($_GET['requisition_no']) ? $_GET['requisition_no'] : '';
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <link rel="stylesheet" href="assets/css/style_for_requisition_items.css">
</head>

<body class="with-welcome-text">
    <div class="container-scroller">
        <!-- partial:partials/_navbar.html -->
        <?php include './includes/profilebasenavbar.php'; ?>
        <!-- partial -->
        <div class="container-fluid page-body-wrapper">
            <!-- partial:partials/_sidebar.html -->
            <?php include './includes/sidebarmenu.php'; ?>
            <!-- partial -->
            <div class="main-panel">
                <div class="content-wrapper">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="home-tab">
                                <div class="tab-content tab-content-basic" style="padding: 0;">
                                    <div class="tab-pane fade show active" id="overview" role="tabpanel"
                                        aria-labelledby="overview">
                                        <div class="container form-container" id="requisition-details-container" style="width: 95%;">
                                            <!-- Requisition details will be populated here by JavaScript -->
                                        </div>

                                        <!-- Display the Added Items Table directly -->
                                        <div class="container form-container" style="margin-top: 20px;width: 95%;">
                                            <div class="">
                                                <div class="col-md-4 mx-auto text-center">
                                                    <label for="vendorSelect">Select Vendor for Allocation</label>
                                                    <div class="d-flex align-items-center">
                                                        <select id="vendorSelect" name="vendor_id"
                                                            onchange="generatePo(this.value, '<?php echo $_GET['requisition_no'] ?>');"
                                                            class="form-control">
                                                            <option value="" selected disabled>Select Vendor</option>
                                                        </select>
                                                        <input type="hidden" id="poidHidden">

                                                        <button class="btn btn-outline-success btn-sm ms-2"
                                                            style="width: 45%;" onclick="showVendorModal();">
                                                            New Vendor
                                                        </button>

                                                    </div>
                                                </div>

                                                <div id="vedDetails" class="col-md-4 mx-auto text-center"
                                                    style="display:">


                                                </div>

                                                <div class="mt-3">
                                                    <table
                                                        class="table table-bordered table-sm text-center align-middle"
                                                        id="itemTable">
                                                        <thead class="table-light">
                                                            <tr>
                                                                <th class="hidden-column">Item Id</th>
                                                                <th>Item Name</th>
                                                                <th>Drawing No</th>
                                                                <th>Part No</th>
                                                                <th style="width: 100px;">Working Qty</th>
                                                                <th style="width: 100px;">prev vendors</th>
                                                                <th style="width: 100px;">Accepted Qty</th>
                                                                <th style="width: 100px;">Pending Qty</th>
                                                                <th style="width: 100px;">Allocate Qty</th>
                                                                <th style="width: 120px;">AMT per Unit</th>
                                                                <th>Select</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="itemListContainer">
                                                            <!-- Items will be inserted here dynamically by JavaScript -->
                                                        </tbody>
                                                    </table>

                                                    <div
                                                        style="display: flex; justify-content: center; margin-top: 10px;">
                                                        <button class="btn btn-outline-secondary btn-sm"
                                                            onclick="window.location.href='accepted_request.php';">Back</button>
                                                            <button class="btn btn-outline-primary btn-sm"
                                                                    id="allocateVendorBtn"
                                                                    onclick="generatePoforVendor();"
                                                                    style="display: none;"
                                                                    disabled>
                                                                <i class="menu-icon fa fa-tags"></i> Allocate Vendor
                                                            </button>

                                                        <button class="btn btn-outline-warning btn-sm" id="showItem"
                                                            onclick="showAllVendorItems();" style="display: none;">
                                                            <i class="menu-icon fa fa-list"></i> Show Item List
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php include './includes/footer.php'; ?>
            </div>
        </div>
    </div>
    <?php include './includes/dependancy.php'; ?>
</body>

<!-- New Vendor Modal -->
<div class="modal-overlay" id="newVendorModal" style="display: none;">
    <div class="modal-box">
        <div class="modal-header">
            <h5 class="modal-title" id="newVendorModalLabel">Add New Vendor</h5>
            <button onclick="closeAddVendorModal();" style="width: 10%;">&times;</button>
        </div>
        <div class="modal-body">
            <form id="newVendorForm">
                <div class="mb-3">
                    <label for="vendorName" class="form-label">Vendor Name</label>
                    <input type="text" class="form-control" id="vendorName" name="vendor_name" required>
                </div>
                <div class="mb-3">
                    <label for="vendorAddress" class="form-label">Vendor Address</label>
                    <input type="text" class="form-control" id="vendorAddress" name="vendor_address" required>
                </div>

                <div class="flex-grow-1">
                    <label for="vendorCurrency" class="form-label">Vendor Currency</label>
                    <select id="vendorCurrency" name="vendor_currency" class="form-control">
                        <option value="" selected disabled>Select Currency</option>
                        <option value="USD">$ USD</option>
                        <option value="EUR">€ EUR</option>
                        <option value="INR">₹ INR</option>
                        <option value="GBP">£ GBP</option>
                        <option value="AUD">A$ AUD</option>
                        <option value="CAD">CA$ CAD</option>
                        <option value="JPY">¥ JPY</option>
                        <option value="CNY">¥ CNY</option>
                        <option value="MXN">$ MXN</option>
                        <option value="BRL">R$ BRL</option>
                    </select>
                </div>
                <div class="text-center">
                    <button type="submit" class="btn btn-outline-primary btn-sm">Add Vendor</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Structure  for PO-->
<div class="modal-overlay" id="expectedpoModal" style="display: none;">
    <div class="modal-box" style="max-width: 70%; max-height: 90%; overflow-y: auto;">
        <div class="modal-header" style="position: relative; justify-content: center; padding-right: 40px;">
            <h4 style="margin: 0 auto;">PURCHASE ORDER</h4>
            <button onclick="closeSuccessfulMsg();" style="position: absolute; right: 10px; top: 50%; transform: translateY(-50%); border: none; background: none; font-size: 20px;">
                &times;
            </button>
        </div>
        <input type="hidden" id="poIdModal" name="po_id" required>
        <input type="hidden" id="reqIdModal" name="req_id" required>


        <div class="modal-body" id="poPdfContent" style="background:white;">
            <div style="display: flex; align-items: center; gap: 15px; margin-bottom: 10px;">
                <img src="assets/images/logo/ksm_logo.jpg" alt="Company Logo" style="height: 50px;">
                <h2 style="margin: 0; font-size: 20px; font-weight: bold;">
                    KAIZEN SHIP MANAGEMENT CO. LTD
                </h2>
            </div>
            <div style="display: flex; justify-content: space-between; font-size: 14px;">
                <div style="width: 48%;">
                    <label class="me-2">Company Address:</label>
                    <textarea class="form-control form-control-sm" rows="4" id="companyAddressInput" style="width: 60%; height: 33%; border: 1px solid #000;background-color: white" wrap="soft" disabled>1023 MS Siam Tower, 36th floor,  Rama 3 road,  Chongnonsi,Yannawa, Bangkok, 10120 Thailand..</textarea>
                    <label class="me-2" style="font-weight: normal;">Phone:</label>
                    <input type="text" class="form-control form-control-sm" id="phoneInput" style="width: 60%; border: 1px solid #000;background-color: white" value="+662 675 8430-8" disabled>
                    <label class="me-2" style="font-weight: normal;">Fax:</label>
                    <input type="text" class="form-control form-control-sm" id="faxInput" style="width: 60%; border: 1px solid #000;background-color: white" value="+662 673 9838" disabled>
                    <label class="me-2" style="font-weight: normal;">Email:</label>
                    <input type="text" class="form-control form-control-sm" id="companyEmailInput" style="width: 60%; border: 1px solid #000;background-color: white" value="main@kaizenship.net, purchase@kaizenship.net" disabled>
                </div>

                <div style="width: 48%;">
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label class="me-2" style="font-weight: normal;">Date:</label>
                        <input type="text" class="form-control form-control-sm" id="date" style="width: 60%; border: 1px solid #000;background-color: white" disabled>
                    </div>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label class="me-2" style="font-weight: normal;">PO No:</label>
                        <input type="text" class="form-control form-control-sm" id="poNoModal" style="width: 60%; border: 1px solid #000;background-color: white" name="po_no" disabled>
                    </div>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label class="me-2" style="font-weight: normal;">Ref PR:</label>
                        <input type="text" class="form-control form-control-sm" id="refPrInput" style="width: 60%; border: 1px solid #000;background-color: white">
                    </div>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label class="me-2" style="font-weight: normal;">Credit Terms:</label>               
                        <input type="number" class="form-control form-control-sm" id="creditTerms" style="width: 60%; border: 1px solid #000;background-color: white">
                    </div>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label class="me-2" style="font-weight: normal;">Order Purpose:</label>
                        <input type="text" class="form-control form-control-sm" id="purchaseCategory" style="width: 60%; border: 1px solid #000;background-color: white">
                    </div>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label class="me-2" style="font-weight: normal;">F.O.B.:</label>
                        <input type="text" class="form-control form-control-sm" id="fobInput" style="width: 60%; border: 1px solid #000;background-color: white">
                    </div>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label class="me-2" style="font-weight: normal;">Ref No:</label>
                        <input type="text" class="form-control form-control-sm" id="refNoInput" style="width: 60%; border: 1px solid #000;background-color: white">
                    </div>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label class="me-2" style="font-weight: normal;">Currency:</label>
                        <input type="text" class="form-control form-control-sm" id="currencyInput" style="width: 60%; border: 1px solid #000;background-color: white">
                    </div>
                </div>
            </div>
            
            <hr>

            <div style="display: flex; justify-content: space-between; font-size: 14px;">
                <div style="width: 48%;">
                    <h6 style="font-weight: bold;">Vendor Details</h6>
                    <div class="mb-1 d-flex align-items-center">
                        <label class="me-2" style="font-weight: normal;">Name:</label>
                        <span id="vendorNameDisplay"> HANA POWER SYSTEM SERVICE CO.,LTD.</span>
                    </div>
                    <div class="mb-1 d-flex align-items-center">
                        <label class="me-2" style="font-weight: normal;">Address:</label>
                        <span id="vendorAddressDisplay">322, Gongdan-Ro, Seongsan-Gu, Changwon, Kyoungnam, Korea, 51569</span>
                    </div>
                    <div class="mb-1 d-flex align-items-center">
                        <label class="me-2" style="font-weight: normal;">Email:</label>
                        <span id="vendorEmailDisplay">hpss@hanapower.com</span>
                    </div>
                </div>

                <div style="width: 48%;">
                    <h6 style="font-weight: bold;">Send To</h6>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label class="me-2" style="font-weight: normal;">Ship Name:</label>
                        <input type="text" class="form-control form-control-sm mb-2" id="shipNameInput" style="width: 70%; border: 1px solid #000;font-weight:bold;" value="EAST AYUTHHAYA">
                    </div>
                    <div class="mb-1 d-flex justify-content-between align-items-center">
                        <label for="shippingType" style="font-weight: normal;">Shipping Type:</label>
                        <select id="shippingType" class="form-control form-control-sm" required style="width: 70%; border: 1px solid #000;">
                            <option value="">Select Type</option>
                            <option value="1">By Air</option>
                            <option value="2">By Sea</option>
                            <option value="3">By Road</option>
                            <option value="4">Self Pickup</option>
                            <option value="5">Express Delivery</option>
                            <option value="6">Standard Delivery</option>
                        </select>
                    </div>
                </div>
            </div>

            <hr>

            <div class="mb-3">
                <label for="remarkNote"><strong>Remarks:</strong></label>
                <textarea id="remarkNote" name="remarkNote" rows="4" style="border: 1px solid #000; height: 10%;" wrap="soft" class="form-control form-control-sm" placeholder="Enter any remark here..." required></textarea>
            </div>

            <table class="table table-bordered" style="font-size: 12px;">
                <thead>
                    <tr>
                        <th>#.</th>
                        <th>Item Name</th>
                        <th>Code Number</th>
                        <th>Account Code</th>
                        <th>QTY</th>
                        <th>Unit Price</th>
                        <th>Total</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>1</td>
                        <td>Main Engine Spare 6 Monthly- E-063-24</td>
                        <td>0</td>
                        <td>5126-02</td>
                        <td>1</td>
                        <td>8,879.17</td>
                        <td>8,879.17</td>
                    </tr>
                </tbody>
            </table>
            <hr>
            <div class="row mt-3">
                <div class="col-md-6">
                    <h6><strong>Other Comments or Special Instructions</strong></h6>
                    <div style="border: 1px solid #000; padding: 10px; background-color: white; font-size: 13px;">
                        <p style="margin: 0;"><strong>Billing Invoice to:</strong></p>
                        <p style="margin: 0;">East Ayutthaya Co., Ltd.</p>
                        <p style="margin: 0;">1023 MS Siam Tower, 36th floor,</p>
                        <p style="margin: 0;">Rama 3 Road, Chongnonsi, Yannawa, Bangkok,</p>
                        <p style="margin: 0;">10120 Thailand</p>
                        <p style="margin: 0;"><strong>Tax ID:</strong> 0105559097453</p>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="row">
                        <div class="col-8 text-end">
                            <strong style="font-weight: normal;">Sub Total</strong>
                        </div>
                        <div class="col-4">
                            <input type="text" class="form-control form-control-sm" id="subTotalInput"
                                style="border: 1px solid #000;background-color: white" value="8,879.17" disabled>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-8 text-end">
                            <strong style="font-weight: normal;">Discount</strong>
                        </div>
                        <div class="col-4">
                            <input type="number" class="form-control form-control-sm" id="discountInput"
                                style="border: 1px solid #000;background-color: white" placeholder="Enter Discount"
                                oninput="updateTotal()">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-8 text-end">
                            <strong style="font-weight: normal;">Add. Charges</strong>
                        </div>
                        <div class="col-4">
                            <input type="number" class="form-control form-control-sm" id="addChargesInput"
                                style="border: 1px solid #000;background-color: white" placeholder="Enter Additional Charges"
                                oninput="updateTotal()">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-8 text-end">
                            <strong style="font-weight: normal;">Tax Amount</strong>
                        </div>
                        <div class="col-4">
                            <input type="number" class="form-control form-control-sm" id="taxAmountInput"
                                style="border: 1px solid #000;background-color: white" placeholder="Enter Tax Amount"
                                oninput="updateTotal()">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-8 text-end">
                            <strong>TOTAL</strong>
                        </div>
                        <div class="col-4">
                            <input type="text" class="form-control form-control-sm" id="totalInput"
                                style="border: 1px solid #000;background-color: white" value="8,879.17" disabled>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-12">
                    <h6><strong>INVOICE INSTRUCTIONS:</strong></h6>
                    <div style="border: 1px solid #000; padding: 10px; background-color: white; font-size: 13px; line-height: 1.6;">
                        <p style="margin: 0;">I) BILLING ADDRESS TO BE IN NAME OF PRINCIPALS</p>
                        <p style="margin: 0;">II) ALL LPO'S AND ANY REVISION OF PO AS APPLICABLE TO BE INCLUDED WITH THE INVOICE COPY OR PURCHASE EMAIL</p>
                        <p style="margin: 0;">III) MASTER'S SIGNED / STAMPED RECEIPT TO ACCOMPANY THE INVOICE.</p>
                        <p style="margin: 0;">IV) ACTUAL INVOICE OF AIR FREIGHT / LOCAL CUSTOMS CHARGES TO BE ATTACHED WITH THE INVOICE.</p>
                        <p style="margin: 0;">V) INVOICE AND DELIVERY RECEIPT WITH MASTER SIGN/STAMP TO BE FORWARDED TO <strong>accounts@kaizenship.net</strong></p>
                        <p style="margin: 0;">VI) ORIGINAL FINAL DA, INVOICE, ALONG WITH THE ORIGINAL THIRD PARTY INVOICE / RECEIPT TO BE SENT TO THAILAND OFFICE PRIOR PAYMENT OF THE FINAL DA.</p>
                        <p style="margin: 0;">VII) FOR PAYMENT IN CURRENCIES OTHER THAN USD, WE WILL USE EXCHANGE RATE FROM <strong>WWW.OANDA.COM</strong> ON THE DATE OF PAYMENT</p>
                        <p style="margin: 0;">VIII) PAYMENT WILL BE ARRANGED IN USD ONLY. PAYMENT WILL NOT BE PROCESSED UNLESS SUPPLIER ASBESTOS FREE DECLARATION IS PROVIDED ALONG WITH INVOICE.</p>

                        <div style="margin-top: 10px; padding: 8px; background-color: yellow; border: 1px solid #000; font-weight: bold; text-align: center;">
                            INVOICES NOT COMPLIED WITH ABOVE INSTRUCTIONS WILL NOT BE PROCESSED.
                        </div>
                    </div>
                </div>
            </div>
            
            <hr>
            <span><strong>ITEM LIST</stong></span>
            <table class="table table-bordered" style="font-size: 12px;">
                <thead>
                    <tr>
                        <th>No.</th>
                        <th>Description</th>
                        <th>Drowing Number</th>
                        <th>Working Qty</th>
                        <th>ROB</th>
                        <th>Unit</th>
                        <th>Qty</th>
                        <th>Unit Price</th>
                        <th>Total Price</th>
                        <th>Remark</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>1</td>
                        <td>Bolt</td>
                        <td>P90101-0147-187</td>
                        <td>24</td>
                        <td>4</td>
                        <td></td>
                        <td>20</td>
                        <td>5.14</td>
                        <td>102.80</td>
                        <td>12 Days</td>
                    </tr>
                    <tr>
                        <td>2</td>
                        <td>O-ring</td>
                        <td>P90101-0147-092</td>
                        <td>12</td>
                        <td>0</td>
                        <td></td>
                        <td>36</td>
                        <td>19.69</td>
                        <td>708.84</td>
                        <td>12 Days</td>
                    </tr>
                </tbody>
            </table>
            <hr>
            
            <div class="row">
                <div class="col-10 text-end"style="font-weight: normal;">
                    Sub Total
                </div>
                <div class="col-2 text-end"style="font-weight: normal;">
                    <input type="text" class="form-control form-control-sm" id="subTotalInput" style="width: 100%; border: 1px solid #000;background-color: white" value="8,879.17" disabled>
                </div>
            </div>

            <div class="row">
                <div class="col-10 text-end"style="font-weight: normal;">
                    Discount
                </div>
                <div class="col-2 text-end"style="font-weight: normal;">
                    <input type="number" class="form-control form-control-sm" id="discountInput" style="width: 100%; border: 1px solid #000;background-color: white" placeholder="Enter Discount" oninput="updateTotal()">
                </div>
            </div>

            <div class="row">
                <div class="col-10 text-end"style="font-weight: normal;">
                    Trans. Charges
                </div>
                <div class="col-2 text-end"style="font-weight: normal;">
                    <input type="number" class="form-control form-control-sm" id="addChargesInput" style="width: 100%; border: 1px solid #000;background-color: white" placeholder="Enter Transaction Charges" oninput="updateTotal()">
                </div>
            </div>

            <div class="row">
                <div class="col-10 text-end"style="font-weight: normal;">
                    Grand Total
                </div>
                <div class="col-2 text-end"style="font-weight: normal;">
                    <input type="text" class="form-control form-control-sm" id="totalInput" style="width: 100%; border: 1px solid #000;background-color: white" value="8,879.17" disabled>
                </div>
            </div> 
            <div class="row">
                <div class="col-10 text-end"style="font-weight: normal;">
                    Credit Terms
                </div>
                <div class="col-2 text-end"style="font-weight: normal;">
                    <input type="text" class="form-control form-control-sm" id="creditTermsInput" style="width: 100%; border: 1px solid #000;background-color: white" value="30 Days">
                </div>
            </div>
            <div class="row">
                <div class="col-10 text-end"style="font-weight: normal;">
                    Lead Time 
                </div>
                <div class="col-2 text-end"style="font-weight: normal;">
                    <input type="number" class="form-control form-control-sm" id="leadTimeInput" style="width: 100%; border: 1px solid #000;background-color: white">
                </div>
            </div>
            <div class="row">
                <div class="col-10 text-end"style="font-weight: normal;">
                    Currency 
                </div>
                <div class="col-2 text-end"style="font-weight: normal;">
                    <input type="text" class="form-control form-control-sm" id="currencyInput" style="width: 100%; border: 1px solid #000;background-color: white" value="USD">
                </div>
            </div>
            <div class="row">
                <div class="col-10 text-end">
                    <strong>USD</strong>
                </div>
                <div class="col-2 text-end">
                    <input type="text" class="form-control form-control-sm" id="usdInput" style="width: 100%; border: 1px solid #000;background-color: white" value="8,879.17" disabled>
                </div>
            </div>
            <hr>

        </div>
        <div class="text-center mb-3">
            <button class="btn btn-info btn-sm" onclick="activatePOForOperations();">OK</button>
            <button class="btn btn-danger btn-sm" onclick="generatePOPdf();">Download as PDF</button>
        </div>
    </div>
</div>

<!-- Modal for PO Created -->
<div class="modal-overlay" id="poModal" style="display: none;">
    <div class="modal-box">
        <div class="modal-body text-center">
            <h5 class="modal-title">Purchase order created successfully for this requisition..!</h5>
            <div class="modal-body text-center">
                <button class="btn btn-outline-success btn-sm" onclick = "closePoSuccessModal();" id="okBtn">OK</button>
            </div>
        </div>
    </div>
</div>

<div id="vendorModal" style="display: none; position: fixed; top: 10%; left: 50%; transform: translateX(-50%); width: 50%; background: #fff; border: 1px solid #ccc; padding: 20px; box-shadow: 0 0 10px rgba(0,0,0,0.3); z-index: 9999; border-radius: 10px;">
    <h3 style="text-align: center;padding: 10px;color: #2f618a;">Previous Vendors</h3>
    <div id="vendorModalContent" style="display: flex; flex-wrap: wrap; gap: 20px; max-height: 300px; overflow-y: auto; padding-right: 10px;"></div>
    <button class="btn btn-outline-success" onclick="closeVendorModal()" style="margin-top: 10px;">Close</button>
</div>


<script src="assets/js/acceptedRequisition.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>


<script>
    // function for update total
    function updateTotal() {
        function parseNumber(value) {
            return parseFloat(value.replace(/,/g, '')) || 0;
        }

        const subTotal = parseNumber(document.getElementById("subTotalInput").value);
        const discountPercent = parseNumber(document.getElementById("discountInput").value);
        const addCharges = parseNumber(document.getElementById("addChargesInput").value);
        const taxAmount = parseNumber(document.getElementById("taxAmountInput").value);
        const discountAmount = (discountPercent / 100) * subTotal;
        const total = subTotal - discountAmount + addCharges + taxAmount;

        document.getElementById("totalInput").value = total.toLocaleString(undefined, {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        });
    }

    // function for date format 
    const dateElement = document.getElementById('date');
    const date = new Date();
    const day = String(date.getDate()).padStart(2, '0');
    const monthNames = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
        'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
    const month = monthNames[date.getMonth()];
    const year = date.getFullYear();
    dateElement.value = `${day}/${month}/${year}`;

    // function for genearte pdf
    async function generatePOPdf() {
        const { jsPDF } = window.jspdf;

        const fullContent = document.getElementById("poPdfContent");
        const clone = fullContent.cloneNode(true);

        const headerRow = clone.querySelector("div[style*='display: flex'][style*='align-items: center']");
        if (headerRow) {
            const poTitle = document.createElement("h3");
            poTitle.textContent = "PURCHASE ORDER";
            poTitle.style.marginLeft = "auto";
            poTitle.style.marginTop = "5px";
            poTitle.style.fontSize = "16px";
            poTitle.style.fontWeight = "bold";
            headerRow.appendChild(poTitle);
        }

        // Replace inputs, selects, and textareas with static text
        clone.querySelectorAll("input, textarea, select").forEach((el) => {
            const div = document.createElement("div");
            div.style.whiteSpace = "pre-wrap";
            div.style.marginBottom = "5px";
            div.style.fontSize = "14px";

            if (el.tagName === "SELECT") {
                div.textContent = el.options[el.selectedIndex]?.text || '';
            } else {
                div.textContent = el.value || el.innerText;
            }

            el.replaceWith(div);
        });

        // Split the content before and after "ITEM LIST"
        const allChildren = Array.from(clone.children);
        const itemListIndex = allChildren.findIndex(el =>
            el.textContent.toLowerCase().includes('item list')
        );

        const part1 = document.createElement("div");
        const part2 = document.createElement("div");

        allChildren.forEach((el, i) => {
            (i < itemListIndex ? part1 : part2).appendChild(el.cloneNode(true));
        });

        // Create jsPDF instance
        const pdf = new jsPDF("p", "mm", "a4");

        const renderedPages = [];

        // Helper to render HTML content to PDF and store image and height
        async function renderToImage(container) {
            container.style.position = "fixed";
            container.style.left = "-9999px";
            container.style.top = "0";
            container.style.zIndex = "-1";
            document.body.appendChild(container);

            const canvas = await html2canvas(container, { scale: 2 });
            const imgData = canvas.toDataURL("image/png");

            const imgProps = pdf.getImageProperties(imgData);
            const pageWidth = pdf.internal.pageSize.getWidth();
            const pageHeight = pdf.internal.pageSize.getHeight();
            const pdfWidth = pageWidth - 20;
            const pdfHeight = (imgProps.height * pdfWidth) / imgProps.width;

            document.body.removeChild(container);
            return { imgData, pdfWidth, pdfHeight };
        }

        const container1 = document.createElement("div");
        container1.appendChild(part1);

        const container2 = document.createElement("div");
        container2.appendChild(part2);

        // Render both parts to images
        const image1 = await renderToImage(container1);
        const image2 = await renderToImage(container2);
        renderedPages.push(image1);
        renderedPages.push(image2);
        const totalPages = renderedPages.length;
        renderedPages.forEach((img, i) => {
            if (i > 0) pdf.addPage();

            const pageWidth = pdf.internal.pageSize.getWidth();
            const pageHeight = pdf.internal.pageSize.getHeight();
            // function for border 
            pdf.setDrawColor(0); 
            pdf.setLineWidth(0.5);
            pdf.rect(5, 5, pageWidth - 10, pageHeight - 10); 

            pdf.addImage(img.imgData, 'PNG', 10, 10, img.pdfWidth, img.pdfHeight);

            // Function for page number 
            const pageNumText = `Page ${i + 1} of ${totalPages}`;
            pdf.setFontSize(10);
            const textWidth = pdf.getTextWidth(pageNumText);
            pdf.text(pageNumText, (pageWidth - textWidth) / 2, pageHeight - 10);

        });
        pdf.save("purchase_order.pdf");
    }
</script>

</html>