<?php
/*
objective : This API handles the submission of requisition data into two tables: requisition_header_all and item_requisition_header_all.
file version : 1.0
API NO : KDN03
Date of creation : 06/05/2025

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Logic Zone :

Date  : 06/05/2025

Request Method:
Type: POST

Headers: Content-Type: application/json

Request Parameters:
{
    "req_no": "REQ12345",
    "dept_id": 1,
    "cat_id": 2,
    "sub_cat_id": 3,
    "sec_sub_cat_id": 4,
    "user_id": 5,
    "req_serial_no": "SN123",
    "req_for": 1,
    "req_priority": 1,
    "req_status": 1,
    "req_eq_name_engine_type": "Engine Model X",
    "req_model_type": "Model Y",
    "req_maker_name": "Maker Z",
    "req_maker_address": "Address ABC",
    "req_remark": "Urgent requirement"
}

Execution Process

*Step 1: Database Connection
- Establishes a connection using a defined SqlServerConnection class.
- If connection fails, returns error_code 500.

*Step 2: Requisition Header Insert
- Inserts data into the requisition_header_all table.
- If insertion fails, returns error_code 501.

*Step 3: Item Requisition Header Insert
- Inserts each item from the 'items' array into the item_requisition_header_all table.
- If insertion fails, returns error_code 502.

*Step 4: Commit Transaction
- If all insertions are successful, commits the transaction.
- If any insertion fails, rolls back the transaction.

Response Structure

*Success Response
{
    "error_code": 200,
    "message": "Requisition data submitted successfully"
}

*Failure Responses

error_code: 500
message: "SQL Server connection failed"

error_code: 501
message: "Requisition header insert failed"

error_code: 502
message: "Item requisition header insert failed"

-------------------------------------------------------------------------------------------------------------------------------

Date :

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Error Zone :

Date : 

*/
session_start();
require_once '../config/test.php';
header('Content-Type: application/json');

function escapeStr($str) {
    return str_replace("'", "''", $str);
}

$data = json_decode(file_get_contents("php://input"), true);

if (!$data) {
    echo json_encode(['error_code' => 400, 'message' => 'Invalid input data']);
    exit;
}

$conn = SqlServerConnection::getConnection();
if ($conn === false) {
    echo json_encode([
        'error_code' => 500,
        'message' => 'SQL Server connection failed',
        'details' => sqlsrv_errors()
    ]);
    exit;
}

sqlsrv_begin_transaction($conn);

// Set defaults
$req_status = isset($data['req_status']) ? (int)$data['req_status'] : 1;
$ship_id = 1;

$req_no = escapeStr($data['req_no']);
$req_serial_no = escapeStr($data['req_serial_no']);
$req_eq_name_engine_type = escapeStr($data['req_eq_name_engine_type']);
$req_model_type = escapeStr($data['req_model_type']);
$req_maker_name = escapeStr($data['req_maker_name']);
$req_maker_address = escapeStr($data['req_maker_address']);
$req_remark = escapeStr($data['req_remark']);
$req_for = isset($data['req_for']) && in_array($data['req_for'], ['Spare', 'Store']) ? ($data['req_for'] === 'Spare' ? 1 : 2) : 0; 
$req_priority = isset($data['req_priority']) ? (int)$data['req_priority'] : 1;
$dept_id = isset($data['dept_id']) ? (int)$data['dept_id'] : 0;
$cat_id = isset($data['cat_id']) ? (int)$data['cat_id'] : 0;
$sub_cat_id = isset($data['sub_cat_id']) ? (int)$data['sub_cat_id'] : 0;
$sec_sub_cat_id = isset($data['sec_sub_cat_id']) ? (int)$data['sec_sub_cat_id'] : 0;

// Insert into requisition_header_all
$insertHeaderSQL = "
    INSERT INTO requisition_header_all (
        req_no, ship_id, dept_id, cat_id, sub_cat_id, sec_sub_cat_id, req_serial_no,
        req_for, req_priority, req_status, req_eq_name_engine_type, req_model_type,
        req_maker_name, req_maker_address, req_remark, req_date_of_creation
    ) VALUES (
        N'$req_no', $ship_id, $dept_id, $cat_id, $sub_cat_id, $sec_sub_cat_id, 
        N'$req_serial_no', $req_for, $req_priority, $req_status, 
        N'$req_eq_name_engine_type', N'$req_model_type', N'$req_maker_name', 
        N'$req_maker_address', N'$req_remark', GETDATE()
    )
";

// Execute the query
$insertHeaderResult = sqlsrv_query($conn, $insertHeaderSQL);

if (!$insertHeaderResult) {
    $errors = sqlsrv_errors();
    $errorDetails = [];

    if ($errors) {
        foreach ($errors as $error) {
            $errorDetails[] = "Error: " . $error['message'] . " (Code: " . $error['code'] . ")";
        }
    }

    error_log(json_encode($errorDetails));

    sqlsrv_rollback($conn);

    echo json_encode([
        'error_code' => 501,
        'message' => 'Requisition header insert failed',
        'sql_errors' => $errorDetails
    ]);
    exit;
}

sqlsrv_commit($conn);

echo json_encode(['error_code' => 200, 'message' => 'Requisition header data submitted successfully']);
?>