<?php
include_once '../config/config.php';

$req_id = isset($_POST['req_id']) ? $_POST['req_id'] : null;
$action = isset($_POST['action']) ? $_POST['action'] : null;
$progress = isset($_POST['progress']) ? $_POST['progress'] : null;
$close_remark = isset($_POST['close_remark']) ? trim($_POST['close_remark']) : null;

if (!$req_id) {
    echo json_encode(['error_code' => 400, 'message' => 'req_id is required']);
    exit;
}

try {
    $conn = SqlServerConnection::getConnection();

    if ($action === 'update_progress' && $progress) {
        $validProgress = [
            'order_placed',
            'prepare_for_dispatch',
            'ready_to_ship',
            'intransit',
            'delivered',
            'closed'
        ];

        if (!in_array($progress, $validProgress)) {
            echo json_encode(['error_code' => 400, 'message' => 'Invalid progress value']);
            exit;
        }

        if ($progress === 'closed') {

            $sql1 = "UPDATE tracker_header_all SET closed = GETDATE() WHERE req_id = '$req_id'";
            $sql2 = "UPDATE requisition_header_all SET close_remark = '$close_remark' WHERE req_id = '$req_id'";

            $stmt1 = sqlsrv_query($conn, $sql1);
            $stmt2 = sqlsrv_query($conn, $sql2);

            if ($stmt1 === false || $stmt2 === false) {
                $errors = sqlsrv_errors();
                error_log(print_r($errors, true));
                echo json_encode(['error_code' => 500, 'message' => 'Database update failed']);
                exit;
            }

        } else {
            // For other progress statuses, just update the corresponding field
            $sql = "UPDATE tracker_header_all SET $progress = GETDATE() WHERE req_id = '$req_id'";
            $stmt = sqlsrv_query($conn, $sql);

            if ($stmt === false) {
                echo json_encode(['error_code' => 500, 'message' => 'Database update failed']);
                exit;
            }
        }

        echo json_encode(['error_code' => 200, 'message' => 'Progress updated successfully']);
        exit;
    }

    $sql = "
        SELECT th.req_id, th.requested, th.cancel_or_reject_datetime,
               th.order_placed, th.prepare_for_dispatch, th.ready_to_ship,
               th.intransit, th.delivered, th.closed,
               rh.delivery_file, rh.delivery_note, rh.delivery_comment
        FROM tracker_header_all th
        LEFT JOIN requisition_header_all rh ON th.req_id = rh.req_id
        WHERE th.req_id = '$req_id'
    ";

    $stmt = sqlsrv_query($conn, $sql);

    if ($stmt === false) {
        echo json_encode(['error_code' => 500, 'message' => 'Database query failed']);
        exit;
    }

    $data = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);

    if ($data === null) {
        echo json_encode(['error_code' => 404, 'message' => 'No tracking data found for this req_id']);
        exit;
    }

    function formatDate($date) {
        if ($date instanceof DateTime) {
            return $date->format('m/d/Y');
        }
        return null;
    }

    // Format date fields
    $data['requested'] = formatDate($data['requested']);
    $data['cancel_or_reject_datetime'] = formatDate($data['cancel_or_reject_datetime']);
    $data['order_placed'] = formatDate($data['order_placed']);
    $data['prepare_for_dispatch'] = formatDate($data['prepare_for_dispatch']);
    $data['ready_to_ship'] = formatDate($data['ready_to_ship']);
    $data['intransit'] = formatDate($data['intransit']);
    $data['delivered'] = formatDate($data['delivered']);
    $data['closed'] = formatDate($data['closed']);

    $data['delivery_file'] = $data['delivery_file'] ?? '';
    $data['delivery_note'] = $data['delivery_note'] ?? '';
    $data['delivery_comment'] = $data['delivery_comment'] ?? '';

    $response = [
        'error_code' => 200,
        'message' => 'Success',
        'data' => [$data]
    ];

    echo json_encode($response);

} catch (Exception $e) {
    echo json_encode(['error_code' => 500, 'message' => 'Server error: ' . $e->getMessage()]);
}
?>
