<?php
session_start();
require_once("../config/config.php");

header('Content-Type: application/json');
$conn = SqlServerConnection::getConnection();

$statusMap = [0 => 'Drafted', 1 => 'Generated', 2 => 'Accepted', 3 => 'Rejected', 4 => 'Order Received', 5 => 'Order Closed'];
$typeMap = [1 => 'Spare', 2 => 'Store'];

$shipId = isset($_GET['ship_id']) ? $_GET['ship_id'] : '';
$reportId = 'EDEDAE7F-3E41-F011-98F1-7413EA3D6A70';

// Get requisitions
$sql = "SELECT r.req_id, r.req_no, r.dept_id, r.req_for, r.req_status, r.req_date_of_creation, 
               r.ship_id, r.req_remark, r.delivery_note, d.dept_name, t.delivered
        FROM requisition_header_all r 
        LEFT JOIN department_header_all d ON r.dept_id = d.dept_id
        LEFT JOIN tracker_header_all t ON r.req_id = t.req_id";

if (!empty($shipId)) {
    $sql .= " WHERE r.ship_id = $shipId";
}

$stmt = sqlsrv_query($conn, $sql);
$requisitions = [];

if ($stmt) {
    while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
        $statusCode = $row['req_status'];
        $status = $statusMap[$statusCode] ?? 'Unknown';
        $typeCode = $row['req_for'];
        $type = $typeMap[$typeCode] ?? 'Unknown';
        $date = $row['req_date_of_creation'] instanceof DateTime ? $row['req_date_of_creation']->format('d/m/Y') : '';
        $deliveredDate = $row['delivered'] instanceof DateTime ? $row['delivered']->format('d/m/Y') : '';
        $requisitions[] = [
            'id' => $row['req_id'],
            'req_no' => $row['req_no'],
            'dept' => $row['dept_name'],
            'type' => $type,
            'status_code' => $statusCode,
            'status' => $status,
            'date' => $date,
            'title' => $row['req_remark'],
            'received_date' => $deliveredDate,
            'place' => '',
            'remark' => $row['delivery_note']
        ];
    }
}

// Get ships
$shipStmt = sqlsrv_query($conn, "SELECT ship_id, ship_name FROM ship_header_all ORDER BY ship_name");
$ships = [];

if ($shipStmt) {
    while ($shipRow = sqlsrv_fetch_array($shipStmt, SQLSRV_FETCH_ASSOC)) {
        $ships[] = [
            'ship_id' => $shipRow['ship_id'],
            'ship_name' => $shipRow['ship_name']
        ];
    }
}

// Get report metadata
$reportMeta = [];
$reportQuery = "SELECT TOP 1 report_name, report_code, revision_number, prepared_by, approved_by, 
                       FORMAT(created_date, 'dd MMM yyyy') as created_date
                FROM master_reports
                WHERE id = ?";
$reportStmt = sqlsrv_query($conn, $reportQuery, [$reportId]);

if ($reportStmt && $row = sqlsrv_fetch_array($reportStmt, SQLSRV_FETCH_ASSOC)) {
    $reportMeta = [
        'report_name' => $row['report_name'],
        'report_code' => $row['report_code'],
        'revision_number' => $row['revision_number'],
        'prepared_by' => $row['prepared_by'],
        'approved_by' => $row['approved_by'],
        'created_date' => $row['created_date']
    ];
}

echo json_encode([
    'error_code' => 200,
    'data' => $requisitions,
    'ships' => $ships,
    'report_meta' => $reportMeta
]);
?>
