<?php

/*
Objective: This API handles requisition-related operations, including creating a new requisition, fetching requisition details, and managing requisition items.
File Version: 1.0
API NO: SBK03
Date of Creation: 29/03/2025

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Logic Zone:

Date: 28/03/2025

Request Method:
Type: POST

Headers: Content-Type: application/json

Request Parameters:
The API expects the following parameters in the request body:

mode (integer, required) – Determines the operation type:
  - 1: Create a new requisition.
  - 2: Retrieve requisition details.
  - 3: Fetch paginated item details.
  - 4: Add/update requisition items.

req_no (string, optional) – The requisition number (required for modes 2, 3, 4).


items (array, optional) – List of item details to be added or updated (required for mode 4).

If any required parameter is missing for the selected mode, the API returns an error response.

*****


Authentication & Security

*Step 1: Verify User Session
The system checks if a valid user session exists.

The stored session token is compared against the user_token from the database.

If the tokens do not match, the session is destroyed, and an error response is returned.

*****


Processing Based on Mode

*Mode 1: Update Item Quantity
- Validates required fields.
- Fetches item details and updates 'accepted_qty' or 'status'.
- Returns success or failure message.

****


Response Structure

*Success Response:
If the request is successful, the API returns:

error_code: 200 (indicating success).

data: The requested information or confirmation message.

*Failure Responses:
If authentication fails, the response contains:

error_code: 401
message: "Unauthorized access. Please log in again."

If a required parameter is missing, the response contains:

error_code: 400
message: "Missing required fields."

If an invalid mode is provided, the response contains:

error_code: 300
message: "Invalid mode specified."

If the request method is not POST, the response contains:

error_code: 405
message: "Invalid request method."

-------------------------------------------------------------------------------------------------------------------------------

Date:

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Error Zone:

Date:

*/



session_start();
require_once '../config/config.php';
// Get the database connection (SQL Server)
$conn = SqlServerConnection::getConnection();
// Set response header to return JSON
ob_clean();
header('Content-Type: application/json');
// Retrieve headers
$headers = function_exists('getallheaders') ? getallheaders() : [];
$mode = $headers['mode'] ?? null;
$response = ['error_code' => 300];
// Check request method
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if required fields exist
    if ($mode == 1) {
        // Mode 1: Update Item Quantity
        if (!isset($_POST['req_id']) || !isset($_POST['item_id']) || !isset($_POST['accepted_qty'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }
        $req_id = htmlspecialchars(trim($_POST['req_id'] ?? ''));
        $item_id = htmlspecialchars(trim($_POST['item_id'] ?? ''));
        $new_accepted_qty = htmlspecialchars(trim($_POST['accepted_qty'] ?? ''));
        $new_pending_qty = htmlspecialchars(trim($_POST['accepted_qty'] ?? ''));
        
        // Step 1: Get matching rows from SQL Server
        $query_for_update_qty = "
        SELECT * 
        FROM item_requisition_header_all 
        WHERE req_id = '$req_id'";

        $stmt = sqlsrv_query($conn, $query_for_update_qty);
        if ($stmt === false) {
            die(print_r(sqlsrv_errors(), true));
        }

        if (sqlsrv_has_rows($stmt)) {
            while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
                $irq_line_no = $row['irq_line_no'];
                // Step 2: Check for item_id in columns item_id_1 to item_id_40
                for ($i = 1; $i <= 40; $i++) {
                    $column_item_id = "item_id_" . $i;
                    $column_item_details = "item_details_" . $i;
                    if ($row[$column_item_id] == $item_id) { 
                        // Step 3: Get item details in JSON format
                        $item_details_json = $row[$column_item_details];
                        if (!empty($item_details_json)) {
                            // Step 4: Decode JSON to PHP array
                            $item_details_array = json_decode($item_details_json, true);
                            // print_r($item_details_array);
                            // Step 5: Update accepted_qty
                            // foreach ($item_details_array) {
                                if ($item_details_array['item_id'] == $item_id) {
                                    $item_details_array['accepted_qty'] = $new_accepted_qty; // Update accepted quantity
                                    $item_details_array['pending_qty'] = $new_pending_qty; // Update pending quantity
                                }
                            // }
                            // Step 6: Encode updated array back to JSON
                            $updated_item_details_json = json_encode($item_details_array);
                            // Step 7: Update the database
                            $query_for_update_item_qty = "
                            UPDATE item_requisition_header_all 
                            SET $column_item_details = '$updated_item_details_json' 
                            WHERE req_id = '$req_id' AND irq_line_no = '$irq_line_no'";

                            $stmt_update = sqlsrv_query($conn, $query_for_update_item_qty);
                            if ($stmt_update === false) {
                                $response = [
                                    'error_code' => 500,
                                    'msg' => 'Internal server error'
                                ];
                            } else {
                                $response = [
                                    'error_code' => 200,
                                    'msg' => 'Item updated successfully.'
                                ];
                            }
                        }
                        break 2; // Stop loop once item is found
                    }
                }
            }
        } else {
            $response = [
                'error_code' => 400,
                'msg' => 'Not updated'
            ];
        }
    }

    if ($mode == 2) {
        // Mode 2: Update Allocated Quantity

        // Validate required POST fields
        if (!isset($_POST['req_no']) || !isset($_POST['item_id']) || !isset($_POST['allocated_qty']) || !isset($_POST['po_id']) || !isset($_POST['ven_id']) || !isset($_POST['amount'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }

        $current_date = date("Y-m-d");

        // Sanitize input
        $req_no = htmlspecialchars(trim($_POST['req_no']));
        $po_id = htmlspecialchars(trim($_POST['po_id']));
        $item_id = htmlspecialchars(trim($_POST['item_id']));
        $new_allocated_qty = htmlspecialchars(trim($_POST['allocated_qty']));
        $ven_id = htmlspecialchars(trim($_POST['ven_id']));
        $amount = htmlspecialchars(trim($_POST['amount']));

        // Get req_id from requisition_header_all
        $query_for_get_req_id = "
        SELECT req_id 
        FROM requisition_header_all 
        WHERE req_no = '$req_no'";
        
        $stmt_get_req_id = sqlsrv_query($conn, $query_for_get_req_id);
        if ($stmt_get_req_id === false) {
            die(print_r(sqlsrv_errors(), true));
        }
        
        $get_req_id = sqlsrv_fetch_array($stmt_get_req_id, SQLSRV_FETCH_ASSOC);
        $req_id = $get_req_id['req_id'];

        $query_for_get_ven_currency = "
        SELECT ven_currency 
        FROM vendor_header_all 
        WHERE ven_id = '$ven_id'";
        
        $stmt_get_ven_currency = sqlsrv_query($conn, $query_for_get_ven_currency);
        if ($stmt_get_ven_currency === false) {
            die(print_r(sqlsrv_errors(), true));
        }

        $get_ven_currency = sqlsrv_fetch_array($stmt_get_ven_currency, SQLSRV_FETCH_ASSOC);
        $ven_currency = $get_ven_currency['ven_currency'];

        // Get item details from item_header_all
        $query_for_get_item_details = "
        SELECT item_id, item_name, item_drawing_no, item_part_no 
        FROM item_header_all 
        WHERE item_id = '$item_id'";
        
        $stmt_get_item_details = sqlsrv_query($conn, $query_for_get_item_details);
        if ($stmt_get_item_details === false) {
            die(print_r(sqlsrv_errors(), true));
        }

        $row_item_details = sqlsrv_fetch_array($stmt_get_item_details, SQLSRV_FETCH_ASSOC);

        // Get vendor allocation details
        $query_for_get_item_against_vendor = "
        SELECT * 
        FROM vendor_item_allocation_all 
        WHERE item_id = '$item_id' AND ven_item_line_no = (SELECT MAX(ven_item_line_no) FROM vendor_item_allocation_all WHERE item_id = '$item_id')";
        
        $stmt_get_item_against_vendor = sqlsrv_query($conn, $query_for_get_item_against_vendor);
        if ($stmt_get_item_against_vendor === false) {
            die(print_r(sqlsrv_errors(), true));
        }

        $chek_flag = 0;

        if (sqlsrv_has_rows($stmt_get_item_against_vendor)) {
            while ($row_item_against_vendor = sqlsrv_fetch_array($stmt_get_item_against_vendor, SQLSRV_FETCH_ASSOC)) {
                $line_no = $row_item_against_vendor['ven_item_line_no'];
                $next_line_no = (int)$row_item_against_vendor['ven_item_line_no'] + 1;
                $ven_current_col = $row_item_against_vendor['ven_current_col'];
                $ven_id_col_name = 'ven_id_' . $ven_current_col;
                $ven_current_col_name = 'ven_id_details_' . $ven_current_col;
                $ven_next_col = (int)$row_item_against_vendor['ven_current_col'] + 1;

                for ($i = 1; $i <= 30; $i++) {
                    if (!empty($row_item_against_vendor['ven_id_' . $i]) && $row_item_against_vendor['ven_id_' . $i] == $ven_id) {
                        $ven_id_col = 'ven_id_' . $i;
                        $ven_id_details_col = 'ven_id_details_' . $i;
                        $item_vendor_details = $row_item_against_vendor['ven_id_details_' . $i];
                        $item_vendor_details = json_decode($item_vendor_details, true);
                        $avg = $item_vendor_details['avg'];
                        $current_avg = ($avg + $amount) % 2;
                        $item_vendor_details['avg'] = $current_avg;
                        $item_vendor_details['last_purches_amt'] = $amount;
                        $item_vendor_details['last_purches_date'] = $current_date;
                        $item_vendor_details_json = json_encode($item_vendor_details);
                        $query_for_insert_ven_id_against_item = "
                        UPDATE vendor_item_allocation_all 
                        SET $ven_id_details_col = '$item_vendor_details_json' 
                        WHERE item_id = '$item_id' AND ven_item_line_no = '$line_no'";

                        $chek_flag = 1;
                    } else {
                        break 2;
                    }
                }
            }

            if ($chek_flag == 0) {
                $item_vendor_details = [
                    'ven_id' => $ven_id,
                    'avg' => $amount,
                    'last_purches_amt' => $amount,
                    'currency' => $ven_currency,
                    'last_purches_date' => $current_date
                ];
                $item_vendor_details_json_encode = htmlspecialchars(json_encode($item_vendor_details));
                if ($ven_next_col > 30) {
                    $query_for_insert_ven_id_against_item = "
                    INSERT INTO vendor_item_allocation_all 
                    SET ven_item_line_no = $next_line_no, ven_current_col = 2, item_id = '$item_id', ven_id_1 = '$ven_id', ven_id_details_1 = '$item_vendor_details_json_encode'";
                } else {
                    $query_for_insert_ven_id_against_item = "
                    UPDATE vendor_item_allocation_all 
                    SET $ven_current_col_name = '$item_vendor_details_json_encode', $ven_id_col_name = '$ven_id', ven_current_col = '$ven_next_col' 
                    WHERE item_id = '$item_id' AND ven_item_line_no = '$line_no'";
                }
            }

        } else {
            // No previous vendor allocation found, insert new
            $item_vendor_details = [
                'ven_id' => $ven_id,
                'avg' => $amount,
                'last_purches_amt' => $amount,
                'currency' => $ven_currency,
                'last_purches_date' => $current_date
            ];
            $item_vendor_details_json_encode = htmlspecialchars(json_encode($item_vendor_details));
            $query_for_insert_ven_id_against_item = "
            INSERT INTO vendor_item_allocation_all 
            SET ven_item_line_no = 1, ven_current_col = 2, item_id = '$item_id', ven_id_1 = '$ven_id', ven_id_details_1 = '$item_vendor_details_json_encode'";
        }

        // Prepare item detail JSON for PO insertion/updation
        $item_details_for_perticuler_item = [
            "item_id" => $item_id,
            "item_name" => $row_item_details['item_name'],
            "item_drawing_no" => $row_item_details['item_drawing_no'],
            "item_part_no" => $row_item_details['item_part_no'],
            "allocated_qty" => $new_allocated_qty,
            "amt_per_unit" => $amount,
        ];
        $item_details_for_perticuler_item_json = json_encode($item_details_for_perticuler_item);

        // Check if PO entry already exists
        $query_for_allocated_qty = "
        SELECT * 
        FROM po_item_details_all 
        WHERE req_id = (SELECT req_id FROM requisition_header_all WHERE req_no = '$req_no') 
        AND po_id = '$po_id' 
        AND poi_line_no = (SELECT MAX(poi_line_no) 
                            FROM po_item_details_all 
                            WHERE req_id = (SELECT req_id FROM requisition_header_all WHERE req_no = '$req_no') 
                            AND po_id = '$po_id')";
        
        $stmt_for_allocated_qty = sqlsrv_query($conn, $query_for_allocated_qty);
        if ($stmt_for_allocated_qty === false) {
            die(print_r(sqlsrv_errors(), true));
        }

        if (sqlsrv_has_rows($stmt_for_allocated_qty)) {
            // Update PO row
            $row = sqlsrv_fetch_array($stmt_for_allocated_qty, SQLSRV_FETCH_ASSOC);
            $poi_line_no = (int)$row['poi_line_no'];
            $poi_current_column_no = (int)$row['poi_current_column'];
            $poi_current_column = 'poi_item_id_' . $poi_current_column_no;
            $poi_next_column = $poi_current_column_no + 1;
            $poi_next_line_no = $poi_line_no + 1;

            if ($poi_current_column_no <= 15) {
                $update_items_details_for_po = "
                UPDATE po_item_details_all 
                SET poi_current_column = '$poi_next_column', $poi_current_column = '$item_details_for_perticuler_item_json' 
                WHERE req_id = '$req_id' AND po_id = '$po_id' AND poi_line_no = '$poi_line_no'";
            } else {
                $update_items_details_for_po = "
                INSERT INTO po_item_details_all 
                SET req_id = '$req_id', po_id = '$po_id', ven_id = '$ven_id', poi_current_column = 2, poi_item_id_1 = '$item_details_for_perticuler_item_json', poi_line_no = '$poi_next_line_no'";
            }

            $stmt_update_items_details_for_po = sqlsrv_query($conn, $update_items_details_for_po);
            if ($stmt_update_items_details_for_po === false) {
                die(print_r(sqlsrv_errors(), true));
            }

            if ($stmt_update_items_details_for_po) {
                // Update pending quantity
                $query_for_pending_qty = "
                SELECT * 
                FROM item_requisition_header_all 
                WHERE req_id = '$req_id'";
                
                $stmt_for_pending_qty = sqlsrv_query($conn, $query_for_pending_qty);
                if ($stmt_for_pending_qty === false) {
                    die(print_r(sqlsrv_errors(), true));
                }

                if (sqlsrv_has_rows($stmt_for_pending_qty)) {
                    while ($row = sqlsrv_fetch_array($stmt_for_pending_qty, SQLSRV_FETCH_ASSOC)) {
                        $irq_line_no = $row['irq_line_no'];
                        for ($i = 1; $i <= 40; $i++) {
                            $column_item_id = "item_id_" . $i;
                            $column_item_details = "item_details_" . $i;

                            if ($row[$column_item_id] == $item_id) {
                                // Update quantity
                                $item_details_json = $row[$column_item_details];
                                if (!empty($item_details_json)) {
                                    $item_details_array = json_decode($item_details_json, true);
                                    foreach ($item_details_array as &$item) {
                                        if ($item['item_id'] == $item_id) {
                                            $item['accepted_qty'] = $new_accepted_qty;
                                            $item['pending_qty'] = $new_pending_qty;
                                        }
                                    }
                                    $updated_item_details_json = json_encode($item_details_array);
                                    $query_for_update_item_qty = "
                                    UPDATE item_requisition_header_all 
                                    SET $column_item_details = '$updated_item_details_json' 
                                    WHERE req_id = '$req_id' AND irq_line_no = '$irq_line_no'";

                                    $stmt_update = sqlsrv_query($conn, $query_for_update_item_qty);
                                    if ($stmt_update === false) {
                                        die(print_r(sqlsrv_errors(), true));
                                    }
                                }
                                break;
                            }
                        }
                    }
                }
            }
        }
    }

    if ($mode == 3) {
        // Mode 3: Update Pending Quantity
        if (
            !isset($_POST['req_id']) || !isset($_POST['po_id']) || !isset($_POST['delivery_date']) || !isset($_POST['shipping_type']) || !isset($_POST['remark'])
        ) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }

        $req_id = htmlspecialchars(trim($_POST['req_id']));
        $po_id = htmlspecialchars(trim($_POST['po_id']));
        $delivery_date = htmlspecialchars(trim($_POST['delivery_date']));
        $shipping_type = htmlspecialchars(trim($_POST['shipping_type']));
        $remark = htmlspecialchars(trim($_POST['remark']));
        $order_placed = date('Y-m-d H:i:s'); // current timestamp

        // File upload handling
        $fileName = $_FILES['po_file']['name'];
        $fileTmp = $_FILES['po_file']['tmp_name'];
        $fileError = $_FILES['po_file']['error'];

        $uploadFileName = '';
        $uploadFilePath = '';

        // Get vendor ID from PO
        $query_for_get_ven_id = "SELECT ven_id FROM po_vendor_header_all WHERE po_id = '$po_id'";
        $stmt_for_get_ven_id = sqlsrv_query($conn, $query_for_get_ven_id);
        $ven_id_details = sqlsrv_fetch_array($stmt_for_get_ven_id, SQLSRV_FETCH_ASSOC);
        $ven_id = $ven_id_details['ven_id'];

        if ($fileError === 0) {
            $originalFileName = pathinfo($fileName, PATHINFO_FILENAME);
            $extension = pathinfo($fileName, PATHINFO_EXTENSION);
            $uniqueFileName = $originalFileName . '_' . time() . '.' . $extension;

            // Full directory with req_id and po_id
            $uploadDir = './../files/po/' . $req_id . '/' . $po_id;

            // Create directory if not exists
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }

            $uploadPath = $uploadDir . '/' . $uniqueFileName;

            if (move_uploaded_file($fileTmp, $uploadPath)) {
                $uploadFileName = $uniqueFileName;
                $uploadFilePath = $uploadPath; // Save full path if needed
            } else {
                $response = ['error_code' => 400, 'message' => 'Unable to upload file'];
            }
        }

        // Update PO vendor header
        $query_for_update_po = "UPDATE po_vendor_header_all SET po_shipping_type = '$shipping_type', po_files = '$uploadFilePath', po_delivery_time = '$delivery_date', po_status = 1, po_remark = '$remark' WHERE po_id = '$po_id' AND req_id = '$req_id'";

        if (sqlsrv_query($conn, $query_for_update_po)) {

            // Insert into PO tracker
            $query_for_tracker = "INSERT INTO po_tracker_header_all (req_id, ven_id, po_id, order_placed) VALUES ('$req_id', '$ven_id', '$po_id', '$order_placed')";
            if (sqlsrv_query($conn, $query_for_tracker)) {
                $response = ['error_code' => 200, 'message' => 'PO updated successfully'];
            } else {
                $response = ['error_code' => 500, 'message' => 'Insert failed: ' . print_r(sqlsrv_errors(), true)];
            }

        } else {
            $response = ['error_code' => 500, 'message' => 'Database update failed: ' . print_r(sqlsrv_errors(), true)];
        }
    }

    if ($mode == 4) {
        if (!isset($_POST['req_no']) || !isset($_POST['ven_id'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }

        $req_no = htmlspecialchars(trim($_POST['req_no']));
        $ven_id = htmlspecialchars(trim($_POST['ven_id']));

        // Get req_id from req_no
        $get_req_id = "SELECT req_id FROM requisition_header_all WHERE req_no = '$req_no'";
        $stmt_for_get_req_id = sqlsrv_query($conn, $get_req_id);
        $req_id_details = sqlsrv_fetch_array($stmt_for_get_req_id, SQLSRV_FETCH_ASSOC);
        $req_id = $req_id_details['req_id'];

        // Get vendor currency and name
        $get_ven_currency = "SELECT ven_name, ven_currency FROM vendor_header_all WHERE ven_id = '$ven_id'";
        $stmt_for_get_ven_currency = sqlsrv_query($conn, $get_ven_currency);
        $ven_currency_details = sqlsrv_fetch_array($stmt_for_get_ven_currency, SQLSRV_FETCH_ASSOC);
        $ven_currency = $ven_currency_details['ven_currency'];
        $ven_name = $ven_currency_details['ven_name'];

        // Get PO number
        $result_for_get_po_no = sqlsrv_query($conn, "SELECT u_no FROM unique_id_header_all WHERE u_table_name = 'po_vendor_header_all'");
        if (sqlsrv_num_rows($result_for_get_po_no) == 1) {
            $row = sqlsrv_fetch_array($result_for_get_po_no, SQLSRV_FETCH_ASSOC);
            $po_no = intval($row['u_no']) + 1;
            $po_no_str = 'PO' . '-' . $po_no;
        } else {
            $po_no = 1;
            $po_no_str = 'PO' . '-' . $po_no;
            sqlsrv_query($conn, "INSERT INTO unique_id_header_all (u_table_name, u_no, u_date_of_creation) VALUES ('po_vendor_header_all', 1, GETDATE())");
        }

        // Generate PO
        $query_for_generate_po = "INSERT INTO po_vendor_header_all (req_id, ven_id, po_no, po_currency, po_currency_operation, po_shipping_type, po_files, po_delivery_time, po_status, po_date_of_creation) VALUES ('$req_id', '$ven_id', '$po_no_str', '$ven_currency','','','','', 0, GETDATE())";
        if (sqlsrv_query($conn, $query_for_generate_po)) {
            $po_id = sqlsrv_insert_id($conn);
            sqlsrv_query($conn, "UPDATE unique_id_header_all SET u_no = '$po_no' WHERE u_table_name = 'po_vendor_header_all'");

            $_SESSION['po_no'] = $po_no_str;

            $response = [
                'error_code' => 200,
                'message' => "PO created successfully",
                'po_no' => $po_no_str,
                'ven_name' => $ven_name,
                'po_id' => $po_id,
                'req_id' => $req_id
            ];
        } else {
            $response = [
                'error_code' => 500,
                'message' => "Failed to create PO"
            ];
        }
    }

}
// Return JSON response
echo json_encode($response);

?>