<?php
session_start();
require_once '../config/config.php';

// Get the database connection
$conn = SqlServerConnection::getConnection();

// Set response header to return JSON
ob_clean();
header('Content-Type: application/json');

// Retrieve headers
$headers = function_exists('getallheaders') ? getallheaders() : [];
$mode = $headers['mode'] ?? null;

// Default response
$response = ['error_code' => 300];

// Check request method and mode
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $mode == 1) {

    // Sanitize and fetch input
    $ship_id = trim($_POST['ship_id'] ?? '');

    // Query 1: Count statuses
    $query1 = "SELECT req_status FROM requisition_header_all";
    $result1 = sqlsrv_query($conn, $query1);

    $partial = $pending = $accepted = $rejected = $return = $operative = $complete = 0;

    if ($result1 !== false) {
        while ($row = sqlsrv_fetch_array($result1, SQLSRV_FETCH_ASSOC)) {
            switch ($row['req_status']) {
                case 0: $partial++; break;
                case 1: $pending++; break;
                case 2: $accepted++; break;
                case 3: $rejected++; break;
                case 4: $return++; break;
                case 5: $operative++; break;
                case 6: $complete++; break;
            }
        }

        // Query 2: Last 15 days data
        $last15Date = date('Y-m-d', strtotime('-15 days'));
        $query2 = "SELECT * FROM requisition_header_all WHERE req_date_of_creation >= ?";
        $params = [$last15Date];
        $result2 = sqlsrv_query($conn, $query2, $params);

        $items = [];
        if ($result2 !== false) {
            while ($row = sqlsrv_fetch_array($result2, SQLSRV_FETCH_ASSOC)) {
                $items[] = $row;
            }
        }

        $response = [
            'error_code' => 200,
            'message' => 'Data retrieved successfully',
            'data' => $items,
            'status_counts' => [
                'partial' => $partial,
                'pending' => $pending,
                'accepted' => $accepted,
                'rejected' => $rejected,
                'return' => $return,
                'operative' => $operative,
                'complete' => $complete
            ]
        ];
    } else {
        $response = ['error_code' => 500, 'message' => 'Failed to fetch requisition data'];
    }
}

// Return JSON response
echo json_encode($response);
?>
