<?php
session_start();
include './includes/header.php';
?>

<link rel="stylesheet" href="assets/css/style_for_generated_requisitions.css">

<div class="container-scroller">
    <?php include './includes/profilebasenavbar.php'; ?>
    <div class="container-fluid page-body-wrapper">
        <?php include './includes/sidebarmenu.php'; ?>
        <div class="main-panel">
            <div class="content-wrapper">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="home-tab">
                            <div class="tab-content tab-content-basic" style="padding: 0;">
                                <div class="tab-pane fade show active" id="overview" role="tabpanel" aria-labelledby="overview">
                                    <div class="container form-container">
                                        <div class="container mt-2">
                                            <h4 class="mb-4">Add New Item</h4>

                                            <div class="card">
                                                <form id="addItemForm" action="add_item.php" method="POST">
                                                    <div class="form-group text-center row justify-content-center">
                                                        <div class="col-md-3">
                                                            <label for="department_select"><strong>Department</strong></label>
                                                            <select id="department_select" class="form-control" required>
                                                                <option value="">Select Department</option>
                                                            </select>
                                                        </div>

                                                        <div class="col-md-3">
                                                            <label for="category_select"><strong>Category</strong></label>
                                                            <select id="category_select" class="form-control" required>
                                                                <option value="">Select Category</option>
                                                            </select>
                                                        </div>

                                                        <div class="col-md-3">
                                                            <label for="subcategory_select"><strong>Subcategory</strong></label>
                                                            <select id="subcategory_select" class="form-control" required>
                                                                <option value="">Select Subcategory</option>
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="form-group text-center row justify-content-center mt-4">
                                                        <div class="col-md-3">
                                                            <label for="item_name"><strong>Item Name</strong></label>
                                                            <input type="text" id="item_name" name="item_name" class="form-control" placeholder="Enter item name" required>
                                                        </div>

                                                        <div class="col-md-3">
                                                            <label for="drawing_no"><strong>Drawing No</strong></label>
                                                            <input type="text" id="drawing_no" name="drawing_no" class="form-control" placeholder="Enter drawing number" required>
                                                        </div>

                                                        <div class="col-md-3">
                                                            <label for="part_no"><strong>Part No</strong></label>
                                                            <input type="text" id="part_no" name="part_no" class="form-control" placeholder="Enter part number" required>
                                                        </div>
                                                    </div>

                                                    <button type="submit" class="btn btn-outline-primary mx-auto d-block">Add Item</button>
                                                </form>

                                                <div class="mt-1" style="display: flex; justify-content: flex-end;">
                                                    <input type="text" id="searchItem" class="form-control" placeholder="Search item" style="max-width: 17%;height: 30px;font-size: 82%;">
                                                </div>

                                                <div id="itemTable" class="mt-4">
                                                    <table class="table datatable">
                                                        <thead>
                                                            <tr>
                                                                <th>Item Name</th>
                                                                <th>Drawing No</th>
                                                                <th>Part No</th>
                                                                <th>Department</th>
                                                                <th>Category</th>
                                                                <th>Subcategory</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="itemList">
                                                            <!-- Item data will be loaded here -->
                                                        </tbody>
                                                    </table>
                                                </div>

                                                <div id="pagination-links" class="pagination justify-content-center">
                                                    <!-- Pagination buttons will be injected here -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include './includes/footer.php'; ?>
        </div>
    </div>
</div>

<?php include './includes/dependancy.php'; ?>
<script src="assets/js/addItem.js"></script>
