<?php
/*
    API: Get Requisition Items (KDN03)
    Version: 1.0
    Date: 2025-06-03
*/

session_start();
require_once '../config/config.php';
header('Content-Type: application/json');


function logError($label, $data) {
    file_put_contents(__DIR__ . '/debug_log.txt', "[$label] " . print_r($data, true) . "\n", FILE_APPEND);
}

// Read JSON input
$data = json_decode(file_get_contents("php://input"), true);
if (!$data || !isset($data['reqNo'])) {
    echo json_encode(['error_code' => 400, 'message' => 'Invalid input data']);
    exit;
}

$req_no = str_replace("'", "''", $data['reqNo']);

$conn = SqlServerConnection::getConnection();
if ($conn === false) {
    $errors = sqlsrv_errors();
    logError('SQL Connection Failed', $errors);
    echo json_encode(['error_code' => 500, 'message' => 'Database connection failed', 'sql_errors' => $errors]);
    exit;
}

$sql = "SELECT req_id FROM requisition_header_all WHERE req_no = '$req_no'";
$stmt = sqlsrv_query($conn, $sql);
if (!$stmt || !($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC))) {
    logError('Failed to fetch req_id', sqlsrv_errors());
    echo json_encode(['error_code' => 404, 'message' => 'Requisition not found']);
    exit;
}

$req_id = (int)$row['req_id'];

$itemSQL = "SELECT * FROM item_requisition_header_all WHERE req_id = $req_id";
$itemStmt = sqlsrv_query($conn, $itemSQL);
if (!$itemStmt) {
    logError('Item Query Failed', sqlsrv_errors());
    echo json_encode(['error_code' => 500, 'message' => 'Failed to fetch item details']);
    exit;
}

$items = [];

while ($itemRow = sqlsrv_fetch_array($itemStmt, SQLSRV_FETCH_ASSOC)) {

    for ($col = 1; $col <= 40; $col++) {
        $key = "item_details_" . $col;
        if (!empty($itemRow[$key])) {
            $jsonStr = $itemRow[$key];
            if (is_string($jsonStr)) {
                $decoded = json_decode($jsonStr, true);
                if (json_last_error() === JSON_ERROR_NONE) {
                    if (isset($decoded['status']) && $decoded['status'] === 'A') {
                        if (isset($decoded['item_id'])) {
                            $items[] = $decoded['item_id'];
                        }
                    }
                } else {
                    logError("JSON Decode Failed (irq_line_no $itemRow[irq_line_no], col $col)", json_last_error_msg());
                }
            }
        } else {
            break;
        }
    }
}


echo json_encode([
    'error_code' => 200,
    'message' => 'Items retrieved successfully',
    'data' => $items
]);
?>
