<?php 
/*
objective : This API retrieves hierarchical category and item data including departments, categories, sub-categories, and second-level sub-categories. It also fetches specific item details based on item_name if provided via GET.
file version : 1.0
API NO : KDN02
Date of creation : 05/05/2025

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Logic Zone :

Date  : 06/05/2025

Request Method:
Type: GET

Headers: Content-Type: application/json

Request Parameters (Optional):
item_name (string) – Name of the item to fetch its drawing and part number.

***********

Execution Process

*Step 1: Database Connection
- Establishes a connection using a defined SqlServerConnection class.
- If connection fails, returns error_code 500.

*Step 2: Item Details Fetch (if item_name is provided)
- Queries the item_header_all table using the provided item_name.
- If query fails, returns error_code 501.
- If no result is found, returns null values.

*Step 3: Department Fetch
- Retrieves departments from department_header_all.
- If query fails, returns error_code 502.

*Step 4: Category and Item Hierarchy
- Fetches categories and their sub-categories.
- Each sub-category retrieves second-level sub-categories and items with requisition_type = 1.
- If any sub-query fails, returns error_code 503.

*Step 5: Flat Item List
- Fetches items where requisition_type = 2 from item_header_all.
- If query fails, returns error_code 504.

********

Response Structure

*Success Response
{
    "error_code": 200,
    "departments": [...],
    "categories": [...],
    "flatItems": [...]
}

*Failure Responses

error_code: 500
message: "SQL Server connection failed"

error_code: 501
message: "Item query failed"

error_code: 502
message: "Department query failed"

error_code: 503
message: "Category or Sub-category query failed"

error_code: 504
message: "Flat items query failed"

-------------------------------------------------------------------------------------------------------------------------------

Date :

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Error Zone :

Date : 

*/

session_start();
require_once '../config/config.php';

header('Content-Type: application/json');
$conn = SqlServerConnection::getConnection();

if ($conn === false) {
    die(json_encode([
        'error_code' => 500,
        'error' => 'SQL Server connection failed',
        'details' => sqlsrv_errors()
    ]));
}

$type = isset($_GET['type']) ? $_GET['type'] : null;

// Step 1: Item Details Fetch (if requested)
if (isset($_GET['item_id'])) {
    $item_id = $_GET['item_id'];

    $sql = "SELECT item_drawing_no, item_part_no FROM item_header_all WHERE item_id = N'$item_id'";
    $result = sqlsrv_query($conn, $sql);

    if ($result === false) {
        echo json_encode([
            'error_code' => 501,
            'item_drawing_no' => null,
            'item_part_no' => null,
            'message' => 'Item query failed'
        ]);
        exit;
    }

    $row = sqlsrv_fetch_array($result, SQLSRV_FETCH_ASSOC);
    echo json_encode([
        'error_code' => 200,
        'item_drawing_no' => $row['item_drawing_no'] ?? null,
        'item_part_no' => $row['item_part_no'] ?? null
    ]);
    exit;
}

// Step 2: Fetch Departments
$departments = [];
$sql_dept = "SELECT dept_id, dept_name FROM department_header_all";
$dept_result = sqlsrv_query($conn, $sql_dept);
if ($dept_result === false) {
    die(json_encode([
        'error_code' => 502,
        'error' => 'Department query failed',
        'details' => sqlsrv_errors()
    ]));
}
while ($row = sqlsrv_fetch_array($dept_result, SQLSRV_FETCH_ASSOC)) {
    $departments[] = $row;
}

// Step 3: Type-based Data Processing
$categories = [];
$indexedCategories = [];
$flatItems = [];

if ($type == 1) {
    // Fetch Category
    $sql = "SELECT cat_id, cat_name FROM category_header_all";
    $result = sqlsrv_query($conn, $sql);
    if ($result === false) die(json_encode(['error_code' => 503, 'error' => 'Category query failed', 'details' => sqlsrv_errors()]));
    while ($row = sqlsrv_fetch_array($result, SQLSRV_FETCH_ASSOC)) {
        $categories[$row['cat_id']] = [
            'cat_id' => $row['cat_id'],
            'cat_name' => $row['cat_name'],
            'sub_categories' => []
        ];
    }

    // Sub Category
    $sql = "SELECT sub_cat_id, sub_cat_name, cat_id FROM sub_category_header_all";
    $result = sqlsrv_query($conn, $sql);
    while ($row = sqlsrv_fetch_array($result, SQLSRV_FETCH_ASSOC)) {
        if (isset($categories[$row['cat_id']])) {
            $categories[$row['cat_id']]['sub_categories'][$row['sub_cat_id']] = [
                'sub_cat_id' => $row['sub_cat_id'],
                'sub_cat_name' => $row['sub_cat_name'],
                'second_sub_categories' => []
            ];
        }
    }

    // Second Sub Category
    $sql = "SELECT sec_sub_cat_id, sec_sub_cat_name, sub_cat_id FROM second_sub_category_header_all";
    $result = sqlsrv_query($conn, $sql);
    while ($row = sqlsrv_fetch_array($result, SQLSRV_FETCH_ASSOC)) {
        foreach ($categories as &$cat) {
            if (isset($cat['sub_categories'][$row['sub_cat_id']])) {
                $cat['sub_categories'][$row['sub_cat_id']]['second_sub_categories'][$row['sec_sub_cat_id']] = [
                    'sec_sub_cat_id' => $row['sec_sub_cat_id'],
                    'sec_sub_cat_name' => $row['sec_sub_cat_name'],
                    'third_sub_categories' => []
                ];
            }
        }
    }

    // Third Sub Category
    $sql = "SELECT third_sub_cat_id, third_sub_cat_name, sec_sub_cat_id FROM third_sub_category_header_all";
    $result = sqlsrv_query($conn, $sql);
    while ($row = sqlsrv_fetch_array($result, SQLSRV_FETCH_ASSOC)) {
        foreach ($categories as &$cat) {
            foreach ($cat['sub_categories'] as &$sub) {
                if (isset($sub['second_sub_categories'][$row['sec_sub_cat_id']])) {
                    $sub['second_sub_categories'][$row['sec_sub_cat_id']]['third_sub_categories'][$row['third_sub_cat_id']] = [
                        'third_sub_cat_id' => $row['third_sub_cat_id'],
                        'third_sub_cat_name' => $row['third_sub_cat_name'],
                        'items' => []
                    ];
                }
            }
        }
    }

    // Items
    $sql = "SELECT item_id, item_name, item_part_no, third_sub_cat_id FROM item_header_all WHERE type = 1";
    $result = sqlsrv_query($conn, $sql);
    while ($row = sqlsrv_fetch_array($result, SQLSRV_FETCH_ASSOC)) {
        foreach ($categories as &$cat) {
            foreach ($cat['sub_categories'] as &$sub) {
                foreach ($sub['second_sub_categories'] as &$sec) {
                    if (isset($sec['third_sub_categories'][$row['third_sub_cat_id']])) {
                        $sec['third_sub_categories'][$row['third_sub_cat_id']]['items'][] = [
                            'item_id' => $row['item_id'],
                            'item_name' => $row['item_name'],
                            'item_part_no' => $row['item_part_no']
                        ];
                    }
                }
            }
        }
    }

    // Convert to indexed arrays for response
    $indexedCategories = array_values(array_map(function($cat) {
        $cat['sub_categories'] = array_values(array_map(function($sub) {
            $sub['second_sub_categories'] = array_values(array_map(function($sec) {
                $sec['third_sub_categories'] = array_values($sec['third_sub_categories']);
                return $sec;
            }, $sub['second_sub_categories']));
            return $sub;
        }, $cat['sub_categories']));
        return $cat;
    }, $categories));

} else if($type == 2) {
// type = 2

$sql_flat = "SELECT item_id, item_name, item_part_no, uom FROM item_header_all WHERE type = 2";
$flat_result = sqlsrv_query($conn, $sql_flat);

if ($flat_result === false) {
    die(json_encode([
        'error_code' => 504,
        'error' => 'Flat items query failed',
        'details' => sqlsrv_errors()
    ]));
}

while ($item = sqlsrv_fetch_array($flat_result, SQLSRV_FETCH_ASSOC)) {
    $flatItems[] = $item;
}

//$flatItems = sqlsrv_fetch_array($flat_result, SQLSRV_FETCH_ASSOC);
}

// Final Response
$response = [
    'error_code' => 200,
    'departments' => $departments,
    'categories' => $indexedCategories,
    'flatItems' => $flatItems
];

echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
?>