<?php
/*
    API: Save Requisition as Draft (KDN03)
    Version: 1.0
    Date: 2025-05-27
*/


session_start();
require_once '../config/config.php';
header('Content-Type: application/json');

function escapeStr($str) {
    return str_replace("'", "''", $str);
}

function logError($label, $data) {
    file_put_contents(__DIR__ . '/debug_log.txt', "[$label] " . print_r($data, true) . "\n", FILE_APPEND);
}

$data = json_decode(file_get_contents("php://input"), true);
if (!$data) {
    echo json_encode(['error_code' => 400, 'message' => 'Invalid input data']);
    exit;
}

$conn = SqlServerConnection::getConnection();
if ($conn === false) {
    $errors = sqlsrv_errors();
    logError('SQL Connection Failed', $errors);
    echo json_encode(['error_code' => 500, 'message' => 'SQL Server connection failed', 'sql_errors' => $errors]);
    exit;
}

sqlsrv_begin_transaction($conn);

$req_no = escapeStr($data['req_no']);
$req_serial_no = escapeStr($data['req_serial_no']);
$req_eq_name_engine_type = escapeStr($data['req_eq_name_engine_type']);
$req_model_type = escapeStr($data['req_model_type']);
$req_maker_name = escapeStr($data['req_maker_name']);
$req_remark = escapeStr($data['req_remark']);
$req_for = ($data['req_for'] === 'Spare') ? 1 : (($data['req_for'] === 'Store') ? 2 : 0);
$req_priority = (int)$data['req_priority'];
$req_status = isset($data['req_status']) ? (int)$data['req_status'] : 1;
$dept_id = (int)$data['dept_id'];
$cat_id = (int)$data['cat_id'];
$sub_cat_id = (int)$data['sub_cat_id'];
$sec_sub_cat_id = (int)$data['sec_sub_cat_id'];
$third_sub_cat_id = (int)$data['third_sub_cat_id'];  
$ship_id = 1;  

$req_id = null;
$sql = "SELECT req_id FROM requisition_header_all WHERE req_no = '$req_no'";
    $stmt = sqlsrv_query($conn, $sql);

    if ($stmt && $row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
        $req_id = (int)$row['req_id'];
    } else {
        sqlsrv_rollback($conn);
        logError('Failed to retrieve req_id', sqlsrv_errors());
        echo json_encode(['error_code' => 503, 'message' => 'Failed to retrieve req_id']);
        exit;
    }
//Insert requisition header
$query_for_get_current_col_and_line = "SELECT irq_line_no, current_col_no FROM item_requisition_header_all WHERE req_id = $req_id AND irq_line_no = (SELECT MAX(irq_line_no) FROM item_requisition_header_all WHERE req_id = $req_id)";

$query_for_get_current_col_and_line_result = sqlsrv_query($conn, $query_for_get_current_col_and_line);

if ($query_for_get_current_col_and_line_result === false) {
    die(print_r(sqlsrv_errors(), true));
}

$irq_line_no = null;
$current_col_no = null;

if ($row = sqlsrv_fetch_array($query_for_get_current_col_and_line_result, SQLSRV_FETCH_ASSOC)) {
    $irq_line_no = $row['irq_line_no'];
    $current_col_no = $row['current_col_no'];
}


$items = $data['items'] ?? [];
$max_items = 40;
$item_ids = array_fill(0, $max_items, 'NULL');
$ref_array = array_fill(0, $max_items, 'NULL');
$item_details = array_fill(0, $max_items, 'NULL');

foreach ($items as $index => $item) {
    $current_col_no = (int)$current_col_no + 1;
    if ($index >= $max_items) break;

    $item_id = (int)($item['item_id'] ?? 0);
    
    $item_ids[$index] = $item_id;

    $cat_id = (int)($item['cat_id'] ?? 0);
    $sub_cat_id = (int)($item['sub_cat_id'] ?? 0);
    $sec_sub_cat_id = (int)($item['sec_sub_cat_id'] ?? 0);
    $third_sub_cat_id = (int)($item['third_sub_cat_id'] ?? 0); 

    if ($req_for === 1) { 
        if($third_sub_cat_id != 0) {
            $ref = 4;
        } else if($sec_sub_cat_id != 0){
            $ref = 3;
        } else if($sub_cat_id  != 0){
            $ref = 2;
        } else if($cat_id != 0){
            $ref = 1;
        } else {
            $ref = "NULL";
        }
    } else {
        $ref = "NULL"; 
    }
    $ref_array[$index] = $ref;

    $details = [
        'req_no' => $req_no,
        'cat_id' => (int)($item['cat_id'] ?? 0),
        'sub_cat_id' => (int)($item['sub_cat_id'] ?? 0),
        'sec_sub_cat_id' => (int)($item['sec_sub_cat_id'] ?? 0),
        'third_sub_cat_id' => (int)($item['third_sub_cat_id'] ?? 0),  
        'item_id' => $item_id,
        'drawing_no' => $item['drawing_no'] ?? '',
        'part_no' => $item['part_no'] ?? '',
        'working_qty' => $item['working_qty'] ?? '',
        'rob' => $item['rob'] ?? '',
        'req_qty' => $item['req_qty'] ?? '',
        'accepted_qty' => $item['req_qty'] ?? '',
        'unit' => $item['unit'] ?? '',
        'remark' => $item['remark'] ?? '',
        'status' => 'A'
    ];

    $jsonDetail = json_encode($details, JSON_UNESCAPED_UNICODE);
    if ($jsonDetail === false) {
        sqlsrv_rollback($conn);
        $jsonError = json_last_error_msg();
        logError('JSON Encode Failed', $details);
        echo json_encode(['error_code' => 504, 'message' => 'JSON encoding failed', 'details' => $jsonError]);
        exit;
    }

$item_details[$index] = "N'" . escapeStr($jsonDetail) . "'";
    if($current_col_no <= 40) {

        $updateSet = "current_col_no = $current_col_no";

        $updateSet .= ", item_id_" . $current_col_no . " = $item_id";
        $updateSet .= ", ref_" . $current_col_no . " = '$ref'";
        $updateSet .= ", item_details_" . $current_col_no . " = '" . $jsonDetail . "'";

        $insertItemsSQL = "UPDATE item_requisition_header_all SET $updateSet WHERE req_id = $req_id AND irq_line_no = $irq_line_no";


        $insertItemsResult = sqlsrv_query($conn, $insertItemsSQL);
        if (!$insertItemsResult) {
            $errors = sqlsrv_errors();
            sqlsrv_rollback($conn);
            logError('Items Insert Failed', $errors);
            echo json_encode(['error_code' => 502, 'message' => 'Item requisition insert failed', 'sql_errors' => $errors]);
            exit;
        }
    } else {
        $current_col_no = 1;
        $irq_line_no = (int)$irq_line_no + 1;
        $insertItemsSQL = "
        INSERT INTO item_requisition_header_all (
            req_id, irq_line_no, current_col_no, 
            item_id_$current_col_no, ref_$current_col_no, item_details_$current_col_no
        ) VALUES (
            $req_id, $irq_line_no, 1,
            $item_id, '$ref', '" . $jsonDetail . "'
        )";


        $insertItemsResult = sqlsrv_query($conn, $insertItemsSQL);
        if (!$insertItemsResult) {
            $errors = sqlsrv_errors();
            sqlsrv_rollback($conn);
            logError('Items Insert Failed', $errors);
            echo json_encode(['error_code' => 502, 'message' => 'Item requisition insert failed', 'sql_errors' => $errors]);
            exit;
        }
    }
}

// Insert into tracker_header_all
$insertTrackerSQL = "
    INSERT INTO tracker_header_all (req_id, requested)
    VALUES ($req_id, GETDATE())
";

$insertTrackerResult = sqlsrv_query($conn, $insertTrackerSQL);
if (!$insertTrackerResult) {
    $errors = sqlsrv_errors();
    sqlsrv_rollback($conn);
    logError('Tracker Insert Failed', $errors);
    echo json_encode(['error_code' => 505, 'message' => 'Tracker insert failed', 'sql_errors' => $errors]);
    exit;
}


$change_req_status = "UPDATE requisition_header_all SET req_status = 1, req_date_of_creation = GETDATE() WHERE req_id = $req_id ";
$change_req_status_result = sqlsrv_query($conn, $change_req_status);

sqlsrv_commit($conn);
echo json_encode(['error_code' => 200, 'message' => 'Draft saved successfully']);

?>
