<?php 
session_start();
require_once '../config/config.php';
header('Content-Type: application/json');
$conn = SqlServerConnection::getConnection();
if ($conn === false) {
    $errors = sqlsrv_errors();
    logError('SQL Connection Failed', $errors);
    echo json_encode(['error_code' => 500, 'message' => 'SQL Server connection failed', 'sql_errors' => $errors]);
    exit;
}

// Use POST if sending via AJAX POST
$req_id = isset($_POST['reqId']) ? (int)$_POST['reqId'] : 0;
$item_id_value = isset($_POST['itemId']) ? (int)$_POST['itemId'] : 0;

$response = ['error_code' => 500, 'message' => 'Unknown error'];

$itemSQL = "SELECT * FROM item_requisition_header_all WHERE req_id = $req_id";
$itemResult = sqlsrv_query($conn, $itemSQL);

if ($itemResult) {
    while($itemRow = sqlsrv_fetch_array($itemResult, SQLSRV_FETCH_ASSOC)) {
        $line_no = $itemRow["irq_line_no"] ?? null;

        for ($i = 1; $i <= 40; $i++) {
            $item_id = $itemRow["item_id_$i"] ?? null;
            $jsonField = $itemRow["item_details_$i"] ?? null;

            if ($item_id == $item_id_value) {
                $decoded = json_decode($jsonField, true);
                if (is_array($decoded) && isset($decoded['item_id']) && $decoded['status'] == 'A') {
                    // Update status to R
                    $decoded['status'] = 'R';
                    $str = json_encode($decoded, JSON_UNESCAPED_UNICODE);
                    $col = "item_details_$i";

                    $itemNameSQL = "UPDATE item_requisition_header_all SET $col = ? WHERE req_id = ? AND irq_line_no = ?";
                    $itemNameResult = sqlsrv_query($conn, $itemNameSQL, [$str, $req_id, $line_no]);

                    if ($itemNameResult) {
                        $response = ['error_code' => 200, 'message' => 'Status updated successfully'];
                    } else {
                        $response = ['error_code' => 400, 'message' => 'Update failed'];
                    }

                    break 2; // Exit both loops
                }
            }
        }
    }
} else {
    $response = ['error_code' => 400, 'message' => 'Query failed'];
}

echo json_encode($response);
?>
